/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;
import org.jboss.as.clustering.infinispan.TransactionManagerProvider;
import org.jboss.as.clustering.infinispan.TransactionSynchronizationRegistryProvider;
import org.jboss.as.clustering.infinispan.subsystem.AbstractCacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.SecurityActions;
import org.jboss.modules.ModuleLoader;

public class CacheConfigurationService
extends AbstractCacheConfigurationService {
    private final ConfigurationBuilder builder;
    private final Dependencies dependencies;

    public CacheConfigurationService(String name, ConfigurationBuilder builder, Dependencies dependencies) {
        super(name);
        this.builder = builder;
        this.dependencies = dependencies;
    }

    @Override
    protected EmbeddedCacheManager getCacheContainer() {
        return this.dependencies.getCacheContainer();
    }

    @Override
    protected ConfigurationBuilder getConfigurationBuilder() {
        TransactionSynchronizationRegistry tsr;
        ConfigurationBuilder builder = new ConfigurationBuilder();
        Configuration templateConfiguration = this.dependencies.getTemplateConfiguration();
        if (templateConfiguration != null) {
            builder.read(templateConfiguration);
        }
        Configuration configuration = this.builder.build();
        builder.read(configuration);
        builder.template(configuration.isTemplate());
        GlobalConfiguration globalConfiguration = SecurityActions.getCacheManagerConfiguration(this.dependencies.getCacheContainer());
        builder.statistics().enabled(globalConfiguration.statistics());
        TransactionManager tm = this.dependencies.getTransactionManager();
        if (tm != null) {
            builder.transaction().transactionManagerLookup((TransactionManagerLookup)new TransactionManagerProvider());
        }
        if ((tsr = this.dependencies.getTransactionSynchronizationRegistry()) != null) {
            builder.transaction().transactionSynchronizationRegistryLookup((TransactionSynchronizationRegistryLookup)new TransactionSynchronizationRegistryProvider(tsr));
        }
        return builder;
    }

    static interface Dependencies {
        public ModuleLoader getModuleLoader();

        public EmbeddedCacheManager getCacheContainer();

        public TransactionManager getTransactionManager();

        public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry();

        public Configuration getTemplateConfiguration();
    }
}

