package org.infinitenature.herbariorum.business;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class Institution
{
   private int irn;
   private String organization;
   private String code;
   private String division;
   private String department;
   private int specimenTotal;
   private Address address;
   private Contact contact;
   private Location location;
   private LocalDate dateModified;


   public int getIrn()
   {
      return irn;
   }

   public void setIrn(int irn)
   {
      this.irn = irn;
   }

   public String getOrganization()
   {
      return organization;
   }

   public void setOrganization(String organization)
   {
      this.organization = organization;
   }

   public String getCode()
   {
      return code;
   }

   public void setCode(String code)
   {
      this.code = code;
   }

   public String getDivision()
   {
      return division;
   }

   public void setDivision(String division)
   {
      this.division = division;
   }

   public String getDepartment()
   {
      return department;
   }

   public void setDepartment(String department)
   {
      this.department = department;
   }

   public int getSpecimenTotal()
   {
      return specimenTotal;
   }

   public void setSpecimenTotal(int specimenTotal)
   {
      this.specimenTotal = specimenTotal;
   }

   public Address getAddress()
   {
      return address;
   }

   public void setAddress(Address address)
   {
      this.address = address;
   }

   public Contact getContact()
   {
      return contact;
   }

   public void setContact(Contact contact)
   {
      this.contact = contact;
   }

   public Location getLocation()
   {
      return location;
   }

   public void setLocation(Location location)
   {
      this.location = location;
   }

   public LocalDate getDateModified()
   {
      return dateModified;
   }

   public void setDateModified(String dateModified)
   {
      DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
      this.dateModified = LocalDate.parse(dateModified, dateTimeFormatter);
   }

   @Override
   public String toString()
   {
      return "Institution{" + "irn=" + irn + ", organization='" + organization
            + '\'' + ", code='" + code + '\'' + ", division='" + division + '\''
            + ", department='" + department + '\'' + ", specimenTotal="
            + specimenTotal + ", address=" + address + ", contact=" + contact
            + ", location=" + location + ", dateModified=" + dateModified + '}';
   }
}
