package org.infinitenature.herbariorum.client;

import org.infinitenature.herbariorum.resource.CountryResource;
import org.infinitenature.herbariorum.resource.InstitutionResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

import javax.ws.rs.client.ClientRequestFilter;

public class Herbariorum
{
   private final ResteasyClient client = new ResteasyClientBuilder().build();
   private final ResteasyWebTarget target;
   private final String url;

   public Herbariorum(String url)
   {
      this.url = url;
      target = client.target(url);
   }

   public Herbariorum(String url, ClientRequestFilter filter)
   {
      this.url = url;
      client.register(filter);
      target = client.target(url);
   }

   public InstitutionResource institutions()
   {
      return target.proxy(InstitutionResource.class);
   }

   public CountryResource countries()
   {
      return target.proxy(CountryResource.class);
   }

   @Override
   public String toString()
   {
      StringBuilder builder = new StringBuilder();
      builder.append("Herbariorum [url=");
      builder.append(url);
      builder.append("]");
      return builder.toString();
   }
}
