/*
 * Decompiled with CFR 0.152.
 */
package org.infinitenature.herbariorum.client;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.infinitenature.herbariorum.client.Client;
import org.infinitenature.herbariorum.client.Herbariorum;
import org.infinitenature.herbariorum.entities.Institution;

public class HerbariorumMemoryClient
implements Client {
    private Herbariorum herbariorum = new Herbariorum("http://sweetgum.nybg.org");
    private List<Institution> institutions = this.herbariorum.institutions().findAll().getInstitutions();
    protected Collection<String> countries = this.herbariorum.countries().findCountries().getCountries();

    @Override
    public List<Institution> findInstitutionsByCountryAndName(String country, String name) {
        if (country == null) {
            return Collections.emptyList();
        }
        return this.institutions.stream().filter(institution -> institution.getAddress().getPostalCountry().equalsIgnoreCase(country)).filter(institution -> institution.getOrganization().contains(name)).collect(Collectors.toList());
    }

    @Override
    public int countInstitutionsByCountryAndName(String country, String name) {
        if (country == null) {
            return 0;
        }
        return (int)this.institutions.stream().filter(institution -> institution.getAddress().getPostalCountry().equalsIgnoreCase(country)).filter(institution -> institution.getOrganization().contains(name)).count();
    }

    @Override
    public List<String> findCountriesByName(String name) {
        return this.countries.stream().filter(country -> country.contains(name)).collect(Collectors.toList());
    }

    @Override
    public int countCountriesByName(String name) {
        return (int)this.countries.stream().filter(country -> country.contains(name)).count();
    }

    @Override
    public void setInstitutions(List<Institution> institutions) {
        this.institutions = institutions;
    }

    @Override
    public void setCountries(Collection<String> countries) {
        this.countries = countries;
    }

    @Override
    public void setGermanCountries() {
    }

    @Override
    public void setHerbariorum(Herbariorum herbariorum) {
        this.herbariorum = herbariorum;
    }
}

