/*
 * Decompiled with CFR 0.152.
 */
package org.infinitest.toolkit.filter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TestType {
    ALL,
    UNIT,
    INTEGRATION,
    CONTAINER,
    LOAD,
    PERFORMANCE,
    SLOW;


    static List<String> testTypesFrom(Properties properties) {
        String testType = properties.getProperty("org.infinitest.filter.types");
        if (StringUtils.isBlank((String)testType)) {
            testType = ALL.name();
        }
        return TestType.parseTypes(testType);
    }

    private static List<String> parseTypes(String testTypeProperty) {
        ArrayList typesToMatch = Lists.newArrayList();
        for (String each : testTypeProperty.toUpperCase().split("[, ]")) {
            typesToMatch.add(each.trim());
        }
        return typesToMatch;
    }
}

