/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.guava.internal.generator;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import org.instancio.Random;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.Hint;
import org.instancio.generator.Hints;
import org.instancio.guava.generator.specs.MultimapGeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.InternalContainerHint;
import org.instancio.internal.util.NumberUtils;

public class GuavaArrayListMultimapGenerator<K, V>
implements Generator<Multimap<K, V>>,
MultimapGeneratorSpec<K, V> {
    private GeneratorContext context;
    private int minSize = 2;
    private int maxSize = 6;

    public void init(GeneratorContext context) {
        this.context = context;
    }

    @Override
    public MultimapGeneratorSpec<K, V> size(int size) {
        this.minSize = ApiValidator.validateSize((int)size);
        this.maxSize = size;
        return this;
    }

    @Override
    public MultimapGeneratorSpec<K, V> minSize(int size) {
        this.minSize = ApiValidator.validateSize((int)size);
        this.maxSize = NumberUtils.calculateNewMaxSize((Integer)this.maxSize, (Integer)this.minSize);
        return this;
    }

    @Override
    public MultimapGeneratorSpec<K, V> maxSize(int size) {
        this.maxSize = ApiValidator.validateSize((int)size);
        this.minSize = NumberUtils.calculateNewMinSize((Integer)this.minSize, (Integer)this.maxSize);
        return this;
    }

    public Multimap<K, V> generate(Random random) {
        return ArrayListMultimap.create();
    }

    public Hints hints() {
        int generateEntries = this.context.random().intRange(this.minSize, this.maxSize);
        return Hints.builder().with((Hint)InternalContainerHint.builder().generateEntries(generateEntries).addFunction((map, args) -> map.put(args[0], args[1])).build()).build();
    }
}

