/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.guava.internal.generator;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import org.instancio.Random;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.Hint;
import org.instancio.generator.Hints;
import org.instancio.guava.generator.specs.TableGeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.InternalContainerHint;
import org.instancio.internal.util.NumberUtils;

public class GuavaHashBasedTableGenerator<R, C, V>
implements Generator<Table<R, C, V>>,
TableGeneratorSpec<R, C, V> {
    private GeneratorContext context;
    private int minSize = 2;
    private int maxSize = 6;

    public void init(GeneratorContext context) {
        this.context = context;
    }

    @Override
    public GuavaHashBasedTableGenerator<R, C, V> size(int size) {
        this.minSize = ApiValidator.validateSize((int)size);
        this.maxSize = size;
        return this;
    }

    @Override
    public GuavaHashBasedTableGenerator<R, C, V> minSize(int size) {
        this.minSize = ApiValidator.validateSize((int)size);
        this.maxSize = NumberUtils.calculateNewMaxSize((Integer)this.maxSize, (Integer)this.minSize);
        return this;
    }

    @Override
    public GuavaHashBasedTableGenerator<R, C, V> maxSize(int size) {
        this.maxSize = ApiValidator.validateSize((int)size);
        this.minSize = NumberUtils.calculateNewMinSize((Integer)this.minSize, (Integer)this.maxSize);
        return this;
    }

    public Table<R, C, V> generate(Random random) {
        return HashBasedTable.create();
    }

    public Hints hints() {
        int generateEntries = this.context.random().intRange(this.minSize, this.maxSize);
        return Hints.builder().with((Hint)InternalContainerHint.builder().generateEntries(generateEntries).addFunction((table, args) -> table.put(args[0], args[1], args[2])).build()).build();
    }
}

