/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.guava.internal.spi;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.Table;
import com.google.common.collect.TreeMultimap;
import com.google.common.collect.TreeMultiset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.instancio.guava.internal.util.GuavaFunctions;
import org.instancio.internal.spi.InternalServiceProvider;
import org.instancio.internal.util.CollectionUtils;

public class GuavaInternalServiceProvider
implements InternalServiceProvider {
    private static final Map<Class<?>, Function<?, ?>> MAPPING_FUNCTIONS = GuavaInternalServiceProvider.getMappingFunctions();
    private static final Set<Class<?>> CONTAINER_CLASSES = GuavaInternalServiceProvider.getContainerClasses();

    private static Map<Class<?>, Function<?, ?>> getMappingFunctions() {
        HashMap<Class, Function<Object, Object>> map = new HashMap<Class, Function<Object, Object>>();
        map.put(ConcurrentHashMultiset.class, GuavaFunctions.fromCollection(ConcurrentHashMultiset::create));
        map.put(HashMultiset.class, GuavaFunctions.fromCollection(HashMultiset::create));
        map.put(ImmutableList.class, GuavaFunctions.fromCollection(ImmutableList::copyOf));
        map.put(ImmutableMultiset.class, GuavaFunctions.fromCollection(ImmutableMultiset::copyOf));
        map.put(ImmutableSet.class, GuavaFunctions.fromCollection(ImmutableSet::copyOf));
        map.put(ImmutableSortedMultiset.class, GuavaFunctions.fromCollection(ImmutableSortedMultiset::copyOf));
        map.put(ImmutableSortedSet.class, GuavaFunctions.fromCollection(ImmutableSortedSet::copyOf));
        map.put(LinkedHashMultiset.class, GuavaFunctions.fromCollection(LinkedHashMultiset::create));
        map.put(Multiset.class, GuavaFunctions.fromCollection(HashMultiset::create));
        map.put(SortedMultiset.class, GuavaFunctions.fromCollection(TreeMultiset::create));
        map.put(TreeMultiset.class, GuavaFunctions.fromCollection(TreeMultiset::create));
        map.put(BiMap.class, GuavaFunctions.fromMap(HashBiMap::create));
        map.put(HashBiMap.class, GuavaFunctions.fromMap(HashBiMap::create));
        map.put(ImmutableBiMap.class, GuavaFunctions.fromMap(ImmutableBiMap::copyOf));
        map.put(ImmutableMap.class, GuavaFunctions.fromMap(ImmutableMap::copyOf));
        map.put(ImmutableSortedMap.class, GuavaFunctions.fromMap(ImmutableSortedMap::copyOf));
        map.put(HashMultimap.class, GuavaFunctions.fromMultimap(HashMultimap::create));
        map.put(ImmutableListMultimap.class, GuavaFunctions.fromMultimap(ImmutableListMultimap::copyOf));
        map.put(ImmutableMultimap.class, GuavaFunctions.fromMultimap(ImmutableMultimap::copyOf));
        map.put(ImmutableSetMultimap.class, GuavaFunctions.fromMultimap(ImmutableSetMultimap::copyOf));
        map.put(LinkedHashMultimap.class, GuavaFunctions.fromMultimap(LinkedHashMultimap::create));
        map.put(LinkedListMultimap.class, GuavaFunctions.fromMultimap(LinkedListMultimap::create));
        map.put(SetMultimap.class, GuavaFunctions.fromMultimap(HashMultimap::create));
        map.put(SortedSetMultimap.class, GuavaFunctions.fromMultimap(TreeMultimap::create));
        map.put(TreeMultimap.class, GuavaFunctions.fromMultimap(TreeMultimap::create));
        map.put(ImmutableTable.class, GuavaFunctions.fromTable(ImmutableTable::copyOf));
        return Collections.unmodifiableMap(map);
    }

    private static Set<Class<?>> getContainerClasses() {
        return Collections.unmodifiableSet(CollectionUtils.asSet((Object[])new Class[]{ArrayListMultimap.class, HashMultimap.class, ImmutableListMultimap.class, ImmutableMultimap.class, ImmutableSetMultimap.class, ImmutableTable.class, LinkedHashMultimap.class, LinkedListMultimap.class, ListMultimap.class, SetMultimap.class, SortedSetMultimap.class, Table.class, TreeMultimap.class}));
    }

    public InternalServiceProvider.InternalContainerFactoryProvider getContainerFactoryProvider() {
        return new InternalServiceProvider.InternalContainerFactoryProvider(){

            public <T, R> Function<T, R> getMappingFunction(Class<R> type, List<Class<?>> typeArguments) {
                return (Function)MAPPING_FUNCTIONS.get(type);
            }

            public boolean isContainer(Class<?> type) {
                return CONTAINER_CLASSES.contains(type);
            }
        };
    }
}

