/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.junit.internal;

import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.instancio.Instancio;
import org.instancio.InstancioApi;
import org.instancio.Random;
import org.instancio.junit.InstancioSource;
import org.instancio.junit.internal.ExtensionSupport;
import org.instancio.settings.Settings;
import org.instancio.support.ThreadLocalRandom;
import org.instancio.support.ThreadLocalSettings;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;

public class InstancioArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<InstancioSource> {
    public void accept(InstancioSource instancioSource) {
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.getInstance();
        ThreadLocalSettings threadLocalSettings = ThreadLocalSettings.getInstance();
        ExtensionSupport.processAnnotations(context, threadLocalRandom, threadLocalSettings);
        Random random = threadLocalRandom.get();
        Settings settings = threadLocalSettings.get();
        Type[] paramTypes = context.getRequiredTestMethod().getGenericParameterTypes();
        Object[] args = InstancioArgumentsProvider.createObjectsGroupingByType(paramTypes, random, settings);
        return args.length == 0 ? Stream.of(new Arguments[0]) : Stream.of(Arguments.of((Object[])args));
    }

    static Object[] createObjectsGroupingByType(Type[] types, Random random, Settings settings) {
        Map counts = Arrays.stream(types).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        LinkedHashMap resultsByType = new LinkedHashMap();
        counts.forEach((type, count) -> {
            InstancioApi api = Instancio.of(() -> type);
            if (settings != null) {
                api.withSettings(settings);
            }
            Queue results = api.withSeed(random.getSeed()).stream().limit((long)count).collect(Collectors.toCollection(ArrayDeque::new));
            resultsByType.put(type, results);
        });
        Object[] results = new Object[types.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = ((Queue)resultsByType.get(types[i])).poll();
        }
        return results;
    }
}

