/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.junit.internal;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.stream.Stream;
import org.instancio.Instancio;
import org.instancio.InstancioApi;
import org.instancio.Random;
import org.instancio.junit.InstancioSource;
import org.instancio.junit.internal.ExtensionSupport;
import org.instancio.settings.Settings;
import org.instancio.support.ThreadLocalRandom;
import org.instancio.support.ThreadLocalSettings;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;

public class InstancioArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<InstancioSource> {
    public void accept(InstancioSource instancioSource) {
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.getInstance();
        ThreadLocalSettings threadLocalSettings = ThreadLocalSettings.getInstance();
        ExtensionSupport.processAnnotations(context, threadLocalRandom, threadLocalSettings);
        Random random = threadLocalRandom.get();
        Settings settings = threadLocalSettings.get();
        Type[] paramTypes = context.getRequiredTestMethod().getGenericParameterTypes();
        Object[] args = InstancioArgumentsProvider.createObjects(paramTypes, random, settings);
        return Stream.of(Arguments.of((Object[])args));
    }

    static Object[] createObjects(Type[] types, Random random, Settings settings) {
        return Arrays.stream(types).map(type -> InstancioArgumentsProvider.createObject(type, random, settings)).toArray();
    }

    static Object createObject(Type type, Random random, Settings settings) {
        InstancioApi api = Instancio.of(() -> type);
        if (settings != null) {
            api.withSettings(settings);
        }
        return api.withSeed(random.longRange(1L, Long.MAX_VALUE)).create();
    }
}

