/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import org.instancio.internal.util.Fail;
import org.instancio.junit.Given;
import org.instancio.junit.InstancioSource;
import org.instancio.junit.internal.ElementAnnotations;
import org.instancio.junit.internal.ExtensionSupport;
import org.instancio.junit.internal.FieldAnnotationMap;
import org.instancio.junit.internal.ObjectCreator;
import org.instancio.junit.internal.ReflectionUtils;
import org.instancio.support.DefaultRandom;
import org.instancio.support.ThreadLocalRandom;
import org.instancio.support.ThreadLocalSettings;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstancioExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback,
AfterTestExecutionCallback,
ParameterResolver {
    private static final Logger LOG = LoggerFactory.getLogger(InstancioExtension.class);
    private static final ExtensionContext.Namespace INSTANCIO = ExtensionContext.Namespace.create((Object[])new Object[]{"org.instancio"});
    private static final String ELEMENT_ANNOTATIONS = "elementAnnotations";
    private static final String ANNOTATION_MAP = "annotationMap";
    private final ThreadLocalRandom threadLocalRandom;
    private final ThreadLocalSettings threadLocalSettings;

    public InstancioExtension() {
        this.threadLocalRandom = ThreadLocalRandom.getInstance();
        this.threadLocalSettings = ThreadLocalSettings.getInstance();
    }

    InstancioExtension(ThreadLocalRandom threadLocalRandom, ThreadLocalSettings threadLocalSettings) {
        this.threadLocalRandom = threadLocalRandom;
        this.threadLocalSettings = threadLocalSettings;
    }

    public void beforeAll(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        context.getStore(INSTANCIO).put((Object)ANNOTATION_MAP, (Object)new FieldAnnotationMap(testClass));
    }

    public void beforeEach(ExtensionContext context) throws IllegalAccessException {
        ExtensionSupport.processAnnotations(context, this.threadLocalRandom, this.threadLocalSettings);
        FieldAnnotationMap annotationMap = (FieldAnnotationMap)context.getStore(INSTANCIO).get((Object)ANNOTATION_MAP, FieldAnnotationMap.class);
        for (Field field : context.getRequiredTestClass().getDeclaredFields()) {
            List<Annotation> annotations = annotationMap.get(field);
            if (!InstancioExtension.containsAnnotation(annotations, Given.class)) continue;
            if (Modifier.isStatic(field.getModifiers())) {
                throw Fail.withUsageError((String)"@Given annotation is not supported for static fields", (Object[])new Object[0]);
            }
            Object testInstance = context.getRequiredTestInstance();
            ElementAnnotations elementAnnotations = new ElementAnnotations(annotations);
            Object fieldValue = new ObjectCreator(this.threadLocalSettings.get(), this.threadLocalRandom.get()).createObject(field, field.getGenericType(), elementAnnotations);
            ReflectionUtils.setAccessible(field).set(testInstance, fieldValue);
        }
    }

    public void afterAll(ExtensionContext context) {
        context.getStore(INSTANCIO).remove((Object)ANNOTATION_MAP, FieldAnnotationMap.class);
    }

    public void afterEach(ExtensionContext context) {
        this.threadLocalRandom.remove();
        this.threadLocalSettings.remove();
        context.getStore(INSTANCIO).remove((Object)ELEMENT_ANNOTATIONS, ElementAnnotations.class);
    }

    public void afterTestExecution(ExtensionContext context) {
        if (context.getExecutionException().isPresent()) {
            Method testMethod = context.getRequiredTestMethod();
            DefaultRandom random = (DefaultRandom)this.threadLocalRandom.get();
            long seed = random.getSeed();
            String seedMsg = String.format("Test method '%s' failed with seed: %d (seed source: %s)%n", testMethod.getName(), seed, random.getSource().getDescription());
            context.publishReportEntry("Instancio", seedMsg);
            LOG.error(seedMsg);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        boolean supportsParameter;
        if (parameterContext.getDeclaringExecutable() instanceof Constructor) {
            return false;
        }
        Parameter parameter = parameterContext.getParameter();
        List<Annotation> annotations = ReflectionUtils.collectionAnnotations(parameter);
        boolean bl = supportsParameter = InstancioExtension.containsAnnotation(annotations, Given.class) && !extensionContext.getTestMethod().map(m -> m.getDeclaredAnnotation(InstancioSource.class)).isPresent();
        if (supportsParameter) {
            extensionContext.getStore(INSTANCIO).put((Object)ELEMENT_ANNOTATIONS, (Object)new ElementAnnotations(annotations));
        }
        return supportsParameter;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Parameter parameter = parameterContext.getParameter();
        ElementAnnotations elementAnnotations = (ElementAnnotations)extensionContext.getStore(INSTANCIO).get((Object)ELEMENT_ANNOTATIONS, ElementAnnotations.class);
        Type targetType = parameter.getParameterizedType();
        return new ObjectCreator(this.threadLocalSettings.get(), this.threadLocalRandom.get()).createObject(parameter, targetType, elementAnnotations);
    }

    private static boolean containsAnnotation(List<Annotation> annotations, Class<? extends Annotation> annotationType) {
        for (Annotation a : annotations) {
            if (a.annotationType() != annotationType) continue;
            return true;
        }
        return false;
    }
}

