/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.junit.internal;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import org.instancio.Random;
import org.instancio.junit.Seed;
import org.instancio.junit.WithSettings;
import org.instancio.junit.internal.Fail;
import org.instancio.junit.internal.ReflectionUtils;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;
import org.instancio.support.DefaultRandom;
import org.instancio.support.Global;
import org.instancio.support.Seeds;
import org.instancio.support.ThreadLocalRandom;
import org.instancio.support.ThreadLocalSettings;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class ExtensionSupport {
    public static void processAnnotations(ExtensionContext context, ThreadLocalRandom threadLocalRandom, ThreadLocalSettings threadLocalSettings) {
        try {
            ExtensionSupport.processWithSettingsAnnotation(context, threadLocalSettings);
            ExtensionSupport.processSeedAnnotation(context, threadLocalRandom);
        }
        catch (Exception ex) {
            threadLocalRandom.remove();
            threadLocalSettings.remove();
            throw ex;
        }
    }

    private static void processSeedAnnotation(ExtensionContext context, ThreadLocalRandom threadLocalRandom) {
        Seeds.Source source;
        long seed;
        Long tlSeed;
        Seed seedAnnotation = context.getTestMethod().map(m -> m.getAnnotation(Seed.class)).orElse(null);
        Settings tlSettings = ThreadLocalSettings.getInstance().get();
        Long l = tlSeed = tlSettings == null ? null : (Long)tlSettings.get(Keys.SEED);
        if (tlSeed != null) {
            seed = tlSeed;
            source = Seeds.Source.WITH_SETTINGS_ANNOTATION;
        } else if (seedAnnotation != null) {
            seed = seedAnnotation.value();
            source = Seeds.Source.SEED_ANNOTATION;
        } else if (Global.getConfiguredRandom() != null) {
            seed = Global.getConfiguredRandom().getSeed();
            source = Seeds.Source.GLOBAL;
        } else {
            seed = Seeds.randomSeed();
            source = Seeds.Source.RANDOM;
        }
        threadLocalRandom.set((Random)new DefaultRandom(seed, source));
    }

    private static void processWithSettingsAnnotation(ExtensionContext context, ThreadLocalSettings threadLocalSettings) {
        Optional testClass = context.getTestClass();
        if (!testClass.isPresent()) {
            return;
        }
        List<Field> fields = ReflectionUtils.getAnnotatedFields((Class)testClass.get(), WithSettings.class);
        if (fields.size() > 1) {
            throw Fail.multipleAnnotatedFields(fields);
        }
        if (fields.size() == 1) {
            Field field = fields.get(0);
            Optional testInstance = context.getTestInstance();
            Object settings = ReflectionUtils.getFieldValue(field, testInstance.orElse(null));
            if (testInstance.isPresent() && settings == null) {
                throw Fail.withSettingsOnNullField();
            }
            if (settings == null) {
                throw Fail.withSettingsOnNullOrNonStaticField();
            }
            if (!(settings instanceof Settings)) {
                throw Fail.withSettingsOnWrongFieldType(field);
            }
            threadLocalSettings.set((Settings)settings);
        }
    }

    private ExtensionSupport() {
    }
}

