/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.junit.internal;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.instancio.Instancio;
import org.instancio.InstancioApi;
import org.instancio.InstancioFeedApi;
import org.instancio.Random;
import org.instancio.documentation.InternalApi;
import org.instancio.feed.Feed;
import org.instancio.internal.util.TypeUtils;
import org.instancio.internal.util.Verify;
import org.instancio.junit.GivenProvider;
import org.instancio.junit.internal.ElementAnnotations;
import org.instancio.junit.internal.InternalElementContext;
import org.instancio.junit.internal.ReflectionUtils;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;

@InternalApi
public class ObjectCreator {
    private final Settings settings;
    private final Random random;

    public ObjectCreator(Settings settings, Random random) {
        this.settings = settings;
        this.random = (Random)Verify.notNull((Object)random, (String)"null random", (Object[])new Object[0]);
    }

    public Object createObject(AnnotatedElement annotatedElement, Type targetType, ElementAnnotations elementAnnotations) {
        List<Class<? extends GivenProvider>> providerClasses = elementAnnotations.getProviderClasses();
        Class targetClass = TypeUtils.getRawType((Type)targetType);
        Type actualTargetType = targetClass == Supplier.class || targetClass == Stream.class ? ((ParameterizedType)targetType).getActualTypeArguments()[0] : targetType;
        Supplier<Object> supplier = providerClasses.isEmpty() ? () -> this.instancioCreate(actualTargetType) : () -> {
            InternalElementContext elementContext = new InternalElementContext(annotatedElement, actualTargetType, elementAnnotations, this.random);
            GivenProvider provider = (GivenProvider)ReflectionUtils.newInstance((Class)this.random.oneOf((Collection)providerClasses));
            return provider.provide(elementContext);
        };
        if (targetClass == Supplier.class) {
            return supplier;
        }
        if (targetClass == Stream.class) {
            return Stream.generate(supplier);
        }
        return supplier.get();
    }

    private Object instancioCreate(Type targetType) {
        Class targetClass = TypeUtils.getRawType((Type)targetType);
        long nextSeed = this.random.longRange(1L, Long.MAX_VALUE);
        if (Feed.class.isAssignableFrom(targetClass)) {
            InstancioFeedApi api = Instancio.ofFeed((Class)targetClass);
            if (this.settings != null) {
                api.withSettings(this.settings);
            }
            return api.withSetting(Keys.SEED, (Object)nextSeed).create();
        }
        InstancioApi api = Instancio.of(() -> targetType);
        if (this.settings != null) {
            api.withSettings(this.settings);
        }
        return api.withSeed(nextSeed).create();
    }
}

