/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.fmi.jnifmuapi;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.zip.ZipException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.intocps.fmi.Fmi2Status;
import org.intocps.fmi.FmiInvalidNativeStateException;
import org.intocps.fmi.FmuInvocationException;
import org.intocps.fmi.FmuMissingLibraryException;
import org.intocps.fmi.IFmiComponent;
import org.intocps.fmi.IFmu;
import org.intocps.fmi.IFmuCallback;
import org.intocps.fmi.jnifmuapi.FmiUtil;
import org.intocps.fmi.jnifmuapi.FmuComponent;
import org.intocps.fmi.jnifmuapi.NativeFmu;

class DirectoryFmu
extends NativeFmu
implements IFmu {
    protected static final Object lock = new Object();
    protected static final String MODEL_DESCRIPTION = "modelDescription.xml";
    public final String name;
    public final File dir;
    boolean loaded;
    private long fmuPtr;

    public DirectoryFmu(File path, String name) throws FmuInvocationException {
        this.dir = path;
        this.name = name;
    }

    long getFmuPtr() {
        return this.fmuPtr;
    }

    public void load() throws FmuInvocationException, FmuMissingLibraryException {
        File libraryPath;
        if (this.loaded) {
            return;
        }
        String modelIdentifier = null;
        String errorMsg = "Fmu do not conform to the standard. Unable to obtain modelIndentifier '%s' for co-simulation, defaulting to archieve name '%s'";
        String recovery_log_message = "Attempting to recover loading of the library by setting modelIdentifier to '%s'";
        try {
            modelIdentifier = FmiUtil.getModelIdentifier(this.getModelDescription());
        }
        catch (IOException e) {
            logger.error(String.format("Fmu do not conform to the standard. Unable to obtain modelIndentifier '%s' for co-simulation, defaulting to archieve name '%s'", "", this.name), (Throwable)e);
            logger.warn("Attempting to recover loading of the library by setting modelIdentifier to '%s'", (Object)this.name);
            modelIdentifier = this.name;
        }
        if (modelIdentifier == null) {
            logger.error(String.format("Fmu do not conform to the standard. Unable to obtain modelIndentifier '%s' for co-simulation, defaulting to archieve name '%s'", "", this.name));
            logger.warn("Attempting to recover loading of the library by setting modelIdentifier to '%s'", (Object)this.name);
            modelIdentifier = this.name;
        }
        if (!(libraryPath = this.generateLibraryFile(modelIdentifier)).exists()) {
            logger.error(String.format("The library corresponding to the modelIdentifier '%s' could not be found at: '%s", modelIdentifier, DirectoryFmu.logMessageLibraryPath(libraryPath)));
            logger.warn(String.format("Attempting to recover loading of the library by setting modelIdentifier to '%s'", this.name));
            modelIdentifier = this.name;
            libraryPath = this.generateLibraryFile(modelIdentifier);
        }
        this.internalLoad(libraryPath);
    }

    public File generateLibraryFile(String modelIdentifier) {
        String osName = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        return FmiUtil.generateLibraryFileFromPlatform(osName, arch, modelIdentifier, this.dir);
    }

    public static String logMessageLibraryPath(File libraryPath) {
        Path p = libraryPath.toPath();
        int pLength = p.getNameCount();
        String desiredPath = p.subpath(pLength - 3, pLength).toString();
        return desiredPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalLoad(File libraryPath) throws FmuInvocationException, FmuMissingLibraryException {
        if (this.loaded) {
            return;
        }
        if (libraryPath == null || !libraryPath.exists()) {
            String errorMsg = DirectoryFmu.logMessageLibraryPath(libraryPath);
            throw new FmuMissingLibraryException("The library for the architecture and OS does not exist within the FMU at: " + errorMsg);
        }
        logger.debug("Loading FMU library: {}", (Object)libraryPath);
        NativeFmu.loadNativeApi();
        Object object = lock;
        synchronized (object) {
            this.fmuPtr = this.nLoadLibrary(libraryPath.getAbsolutePath());
        }
        if (this.fmuPtr == 0L) {
            throw new FmuInvocationException("Load failed");
        }
        this.loaded = true;
        logger.debug("Dll pointer: " + this.fmuPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFmiComponent instantiate(String guid, String name, boolean visible, boolean loggingOn, final IFmuCallback callback) throws XPathExpressionException, FmiInvalidNativeStateException {
        if (!this.loaded) {
            return null;
        }
        File resourceDir = new File(this.dir, "resources");
        resourceDir.mkdirs();
        URI resourceUri = resourceDir.toURI();
        if (System.getProperty("fmi.instantiate.with.empty.authority") != null && resourceUri.getAuthority() == null) {
            try {
                logger.debug("Inserting empty authority into URI: {}", (Object)resourceUri);
                resourceUri = new URI(resourceUri.getScheme(), "", resourceUri.getPath(), null);
                logger.trace("URI changed to '{}'", (Object)resourceUri);
            }
            catch (URISyntaxException e) {
                logger.error("Failed to create resourceUri with empty authority");
            }
        }
        String resourceLocation = resourceUri.toString();
        logger.trace("resourceLocationURI is: '{}'", (Object)resourceUri);
        NativeFmu.ICallback cb = null;
        if (callback != null) {
            cb = new NativeFmu.ICallback(){

                @Override
                public void log(String name, byte status, String category, String message) {
                    callback.log(name, Fmi2Status.valueOf((byte)status), category, message);
                }

                @Override
                public void stepFinished(byte fmuStatus) {
                    callback.stepFinished(Fmi2Status.valueOf((byte)fmuStatus));
                }
            };
        }
        this.checkState();
        long c = 0L;
        Object object = lock;
        synchronized (object) {
            c = this.ninstantiate(this.fmuPtr, name, guid, resourceLocation, visible, loggingOn, cb);
        }
        if (c == 0L) {
            return null;
        }
        return new FmuComponent(this, c, guid, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLoad() throws FmiInvalidNativeStateException {
        if (!this.loaded) {
            return;
        }
        this.checkState();
        Object object = lock;
        synchronized (object) {
            this.nUnLoad(this.fmuPtr);
        }
        this.loaded = false;
    }

    public String getVersion() throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nGetVersion(this.fmuPtr);
    }

    public String getTypesPlatform() throws FmiInvalidNativeStateException {
        this.checkState();
        return this.nGetTypesPlatform(this.fmuPtr);
    }

    public InputStream getModelDescription() throws ZipException, IOException {
        File path = new File(this.dir, MODEL_DESCRIPTION);
        if (!path.exists() || !path.canRead()) {
            return null;
        }
        byte[] bytes = IOUtils.toByteArray((InputStream)new FileInputStream(path));
        return new ByteArrayInputStream(bytes);
    }

    public boolean isValid() {
        return this.fmuPtr != 0L;
    }

    protected void checkState() throws FmiInvalidNativeStateException {
        if (!this.isValid()) {
            throw new FmiInvalidNativeStateException("The internal " + (this.fmuPtr != 0L ? "" : " FMU state is invalid. "));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void synchronizedFree(FmuComponent comp) throws FmiInvalidNativeStateException {
        Object object = lock;
        synchronized (object) {
            comp.internalFreeInstance();
        }
    }
}

