/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.fmi.jnifmuapi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FmiUtil {
    static final Logger logger = LoggerFactory.getLogger(FmiUtil.class);

    public static File generateLibraryFileFromPlatform(String osName, String osArch, String modelIdentifier, File fmuRoot) {
        String arch = osArch;
        String libDir = "";
        String libExtension = "";
        if (osName.toLowerCase().contains("windows")) {
            libExtension = ".dll";
            libDir = arch.contains("amd64") ? "win64" : "win32";
        } else if (osName.indexOf("nix") >= 0 || osName.indexOf("nux") >= 0 || osName.indexOf("aix") > 0) {
            libExtension = ".so";
            libDir = arch.contains("amd64") ? "linux64" : "linux32";
        } else if (osName.toLowerCase().contains("mac")) {
            libExtension = ".dylib";
            libDir = arch.contains("x86_64") ? "darwin64" : "darwin32";
        }
        File libraryPath = new File(new File(new File(fmuRoot, "binaries"), libDir), modelIdentifier + libExtension);
        return libraryPath;
    }

    public static String getModelIdentifier(InputStream modelDescription) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(modelDescription);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("fmiModelDescription/CoSimulation/@modelIdentifier");
            NodeList list = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            if (list != null) {
                Node n = list.item(0);
                return n.getNodeValue();
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            logger.error("Unable to parse model description", (Throwable)e);
        }
        return null;
    }
}

