/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.fmi.jnifmuapi;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.intocps.fmi.FmiInvalidNativeStateException;
import org.intocps.fmi.FmuInvocationException;
import org.intocps.fmi.FmuMissingLibraryException;
import org.intocps.fmi.jnifmuapi.DirectoryFmu;
import org.intocps.fmi.jnifmuapi.TempDirectory;
import org.intocps.fmi.jnifmuapi.ZipUtility;

final class Fmu
extends DirectoryFmu {
    private final File tmpFolder;
    final File path;
    boolean unpacked = false;

    public Fmu(File path) throws IOException, FmuInvocationException {
        this(path, Fmu.createTempDir(Fmu.getFmuName(path)), true);
    }

    public Fmu(File path, File extractDirectory) throws FmuInvocationException {
        this(path, extractDirectory, false);
    }

    public Fmu(File path, File extractDirectory, boolean usingTemp) throws FmuInvocationException {
        super(extractDirectory, Fmu.getFmuName(path));
        this.path = path;
        this.tmpFolder = usingTemp ? extractDirectory : null;
    }

    private static File createTempDir(String prefix) {
        TempDirectory dir = new TempDirectory(prefix);
        dir.deleteOnExit();
        return dir.getPath().toFile();
    }

    private static String getFmuName(File path) throws FmuInvocationException {
        if (path.getName().indexOf(".fmu") == -1) {
            throw new FmuInvocationException("invalid fmu name: " + path.getName());
        }
        return path.getName().substring(0, path.getName().indexOf(46));
    }

    public void unPack() throws IOException {
        this.dir.mkdirs();
        logger.debug("Extracting: " + this.path.getAbsolutePath() + " to " + this.dir.getAbsolutePath());
        ZipUtility.unzipApacheCompress(this.path, this.dir);
        logger.debug("Extracted '" + this.path.getAbsolutePath() + "' to '" + this.dir.getAbsolutePath() + "'");
        this.unpacked = true;
    }

    @Override
    public void load() throws FmuInvocationException, FmuMissingLibraryException {
        logger.debug("Load FMU {}", (Object)this.path);
        if (this.loaded) {
            return;
        }
        if (!this.unpacked) {
            try {
                this.unPack();
            }
            catch (ZipException e) {
                throw new FmuInvocationException(e.getMessage());
            }
            catch (IOException e) {
                throw new FmuInvocationException(e.getMessage());
            }
        }
        super.load();
    }

    @Override
    public void unLoad() throws FmiInvalidNativeStateException {
        logger.debug("UnLoad FMU {}, temp folder", (Object)this.path, (Object)this.tmpFolder);
        super.unLoad();
        if (this.tmpFolder != null && this.tmpFolder.exists()) {
            logger.debug("Deleting temp folder {}", (Object)this.tmpFolder);
            TempDirectory.delete(this.tmpFolder.toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getModelDescription() throws ZipException, IOException {
        if (!this.path.exists() || !this.path.canRead()) {
            return null;
        }
        try (ZipFile zipFile = null;){
            zipFile = new ZipFile(this.path);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().equals("modelDescription.xml")) continue;
                byte[] bytes = IOUtils.toByteArray((InputStream)zipFile.getInputStream(entry));
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                return byteArrayInputStream;
            }
        }
        return null;
    }

    public void testNativeCallback() throws FmiInvalidNativeStateException {
        this.checkState();
        super.callbackTest(this.getFmuPtr(), this.name);
    }
}

