/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.fmi.jnifmuapi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.intocps.fmi.jnifmuapi.xml.NamedNodeMapIterator;
import org.intocps.fmi.jnifmuapi.xml.NodeIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FmuModelDescription {
    private static final boolean DEBUG = false;
    private final File file;
    final Document doc;
    final XPath xpath;

    public FmuModelDescription(File file) throws ParserConfigurationException, SAXException, IOException {
        this.file = file;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.doc = builder.parse(file);
        XPathFactory xPathfactory = XPathFactory.newInstance();
        this.xpath = xPathfactory.newXPath();
    }

    public String getModelId() throws XPathExpressionException {
        Node name = FmuModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/@modelName");
        return name.getNodeValue();
    }

    public String getGuid() throws XPathExpressionException {
        Node name = FmuModelDescription.lookupSingle(this.doc, this.xpath, "fmiModelDescription/@guid");
        return name.getNodeValue();
    }

    public boolean validate() throws FileNotFoundException {
        return FmuModelDescription.validateAgainstXSD(new FileInputStream(this.file), new File("modeldescription").listFiles());
    }

    static Node lookupSingle(Object doc, XPath xpath, String expression) throws XPathExpressionException {
        NodeList list = FmuModelDescription.lookup(doc, xpath, expression);
        if (list != null) {
            return list.item(0);
        }
        return null;
    }

    static NodeList lookup(Object doc, XPath xpath, String expression) throws XPathExpressionException {
        XPathExpression expr = xpath.compile(expression);
        NodeList list = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        boolean first = true;
        for (Node n : new NodeIterator(list)) {
            first = false;
        }
        if (first) {
            // empty if block
        }
        return list;
    }

    public static String formateNodeWithAtt(Object o) {
        if (o instanceof Document) {
            return "Root document";
        }
        if (o instanceof Node) {
            Node node = (Node)o;
            String tmp = "";
            tmp = node.getLocalName();
            if (node.hasAttributes()) {
                for (Node att : new NamedNodeMapIterator(node.getAttributes())) {
                    tmp = tmp + " " + att + ", ";
                }
            }
            return tmp;
        }
        return o.toString();
    }

    static boolean validateAgainstXSD(InputStream xml, File ... xsd) {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Source[] sources = new Source[xsd.length];
            for (int i = 0; i < xsd.length; ++i) {
                sources[i] = new StreamSource(xsd[i]);
            }
            Schema schema = factory.newSchema(sources);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            Document document = docBuilderFactory.newDocumentBuilder().parse(xml);
            schema.newValidator().validate(new DOMSource(document));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(xml));
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

