/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.fmi.jnifmuapi;

import java.io.File;
import org.intocps.fmi.jnifmuapi.NativeFmuApi;
import org.intocps.fmi.jnifmuapi.NativeLibraryLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class NativeFmu {
    static final Logger logger = LoggerFactory.getLogger(NativeFmu.class);
    private static boolean isLoaded;

    NativeFmu() {
    }

    public static void loadNativeApi() {
        if (isLoaded) {
            return;
        }
        String libPath = NativeFmuApi.getPlatformSpecificLibaryPath("fmuapi");
        logger.debug("Loading library: " + libPath);
        try {
            File lib = new NativeLibraryLoader().loadLibrary(libPath);
            logger.debug("Loaded Library file: " + lib);
            isLoaded = true;
        }
        catch (Exception e) {
            logger.error("Failed to load native Library file: " + libPath, (Throwable)e);
            isLoaded = false;
            throw new RuntimeException("Failed to load native Library file: " + libPath, e);
        }
    }

    public static boolean isNativeApiLoaded() {
        return isLoaded;
    }

    protected native String nGetTypesPlatform(long var1);

    protected native String nGetVersion(long var1);

    protected native long ninstantiate(long var1, String var3, String var4, String var5, boolean var6, boolean var7, ICallback var8);

    protected synchronized native long nLoadLibrary(String var1);

    protected synchronized native void nUnLoad(long var1);

    protected native void callbackTest(long var1, String var3);

    protected native void throwExceptionTest() throws Exception;

    public static native long getJniApiVersion();

    static interface ICallback {
        public void log(String var1, byte var2, String var3, String var4);

        public void stepFinished(byte var1);
    }
}

