/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.fmi.jnifmuapi;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import org.intocps.fmi.jnifmuapi.TempDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NativeLibraryLoader {
    static final Logger logger = LoggerFactory.getLogger(NativeLibraryLoader.class);
    static Map<String, File> loadedLibs = new HashMap<String, File>();

    NativeLibraryLoader() {
    }

    public static File getTempFolder() {
        TempDirectory tempDir = new TempDirectory("jnifmuapi");
        tempDir.deleteOnExit();
        return tempDir.getPath().toFile();
    }

    public File loadLibrary(String relativeLibraryPath) throws Exception {
        if (loadedLibs.containsKey(relativeLibraryPath)) {
            return loadedLibs.get(relativeLibraryPath);
        }
        logger.debug("Extracting library from: {}", (Object)relativeLibraryPath);
        File lib = this.extractNativeLibrary(NativeLibraryLoader.getTempFolder(), relativeLibraryPath);
        logger.debug("Extracted library: {}", (Object)lib);
        if (lib == null) {
            throw new FileNotFoundException("Unable to find the native lib: " + relativeLibraryPath);
        }
        System.load(lib.getAbsolutePath());
        loadedLibs.put(relativeLibraryPath, lib);
        return lib;
    }

    public File extractNativeLibrary(File outputFolder, String relativeLibraryPath) throws IOException {
        String osName;
        int index;
        String name = relativeLibraryPath;
        int slashIndex = name.lastIndexOf(47);
        if (slashIndex != -1) {
            name = name.substring(slashIndex + 1);
        }
        if ((index = (osName = System.getProperty("os.name")).indexOf(32)) != -1) {
            osName = osName.substring(0, index);
        }
        outputFolder = new File(outputFolder, "jnifmuapi-" + osName + "-" + System.getProperty("os.arch"));
        outputFolder.mkdirs();
        File library = new File(outputFolder, name);
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(relativeLibraryPath);
        if (in != null) {
            Files.copy(in, Paths.get(library.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            return library;
        }
        return null;
    }
}

