/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.fmi.jnifmuapi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.io.IOUtils;

public class ZipUtility {
    protected static final short PERM_READ = 1;
    protected static final short PERM_WRITE = 2;
    protected static final short PERM_EXECUTE = 4;
    protected static final short PERM_APPEND = 8;
    protected static final short PERM_GFS_APPEND = 16;
    protected static final short PERM_CREATE = 32;
    protected static final short PERM_TRUNCATE = 64;
    protected static final short PERM_STRICT_READ = 128;
    protected static final short PERM_DELETE = 256;
    protected static final short PERM_SUID_SGID = 16384;
    protected static final short READ_MASK = 129;
    protected static final short WRITE_MASK = 378;
    protected static final short EXEC_MASK = 4;
    protected static final short READ_ONLY_MASK = 365;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File file, File outputDir) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryDestination = new File(outputDir, entry.getName());
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                    continue;
                }
                entryDestination.getParentFile().mkdirs();
                InputStream in = zipFile.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(entryDestination);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                IOUtils.closeQuietly((InputStream)in);
                ((OutputStream)out).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipApacheCompress(File archiveFile, File toDir) throws IOException {
        org.apache.commons.compress.archivers.zip.ZipFile zipFile = null;
        try {
            zipFile = new org.apache.commons.compress.archivers.zip.ZipFile(archiveFile);
            Enumeration zipEntries = zipFile.getEntriesInPhysicalOrder();
            while (zipEntries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)zipEntries.nextElement();
                String entryName = entry.getName();
                File outFile = new File(toDir, entryName);
                if (outFile.getParentFile().exists() || !outFile.getParentFile().mkdirs()) {
                    // empty if block
                }
                if (entry.isDirectory()) {
                    if (outFile.mkdir()) continue;
                    continue;
                }
                InputStream zipStream = null;
                FileOutputStream outFileStream = null;
                zipStream = zipFile.getInputStream(entry);
                outFileStream = new FileOutputStream(outFile);
                try {
                    IOUtils.copy((InputStream)zipStream, (OutputStream)outFileStream);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)zipStream);
                    IOUtils.closeQuietly((OutputStream)outFileStream);
                    if ((entry.getUnixMode() & 4) == 0) continue;
                    outFile.setExecutable(true);
                }
            }
        }
        catch (Throwable throwable) {
            org.apache.commons.compress.archivers.zip.ZipFile.closeQuietly(zipFile);
            throw throwable;
        }
        org.apache.commons.compress.archivers.zip.ZipFile.closeQuietly((org.apache.commons.compress.archivers.zip.ZipFile)zipFile);
    }
}

