/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.IokeObject;
import ioke.lang.Message;
import ioke.lang.NativeMethod;
import ioke.lang.Runtime;
import ioke.lang.exceptions.ControlFlow;
import java.util.List;

public class CaseBehavior {
    public static IokeObject transformWhenStatement(Object when, IokeObject context, IokeObject message, IokeObject caseMimic) throws ControlFlow {
        String outerName = Message.name(when);
        if (caseMimic.getCells().containsKey("case:" + outerName)) {
            IokeObject cp = Message.deepCopy(when);
            CaseBehavior.replaceAllCaseNames(cp, context, message, caseMimic);
            return cp;
        }
        return IokeObject.as(when, context);
    }

    private static void replaceAllCaseNames(IokeObject when, IokeObject context, IokeObject message, IokeObject caseMimic) throws ControlFlow {
        String theName = "case:" + Message.name(when);
        if (caseMimic.getCells().containsKey(theName)) {
            Message.setName(when, theName);
            for (Object arg : when.getArguments()) {
                CaseBehavior.replaceAllCaseNames(IokeObject.as(arg, context), context, message, caseMimic);
            }
        }
    }

    public static void init(IokeObject obj) throws ControlFlow {
        Runtime runtime = obj.runtime;
        obj.setKind("DefaultBehavior Case");
        obj.registerMethod(runtime.newNativeMethod("takes one argument that should evaluate to a value, zero or more whenAndThen pairs and one optional else clause. will first evaluate the initial value, then check each whenAndThen pair against this value. if the when part of a pair returns true, then return the result of evaluating the then part. if no pair matches and no else clause is present, returns nil. if an else clause is there, it should be the last one. each whenAndThen pair is comprised of two arguments, where the first is the when argument and the second is the then argument. the when part will be evaluated and the result of this evaluation will be sent a === message with the value as argument.", new NativeMethod("case"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositional("value").withRestUnevaluated("whensAndThens").withOptionalPositionalUnevaluated("elseCode").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                Runtime runtime = context.runtime;
                List<Object> args = message.getArguments();
                int argCount = args.size();
                int index = 0;
                IokeObject msg = IokeObject.as(args.get(index++), context);
                Object value = ((Message)IokeObject.data(msg)).evaluateCompleteWithoutExplicitReceiver(msg, context, context.getRealContext());
                --argCount;
                while (argCount > 1) {
                    msg = CaseBehavior.transformWhenStatement(args.get(index++), context, message, obj);
                    Object when = ((Message)IokeObject.data(msg)).evaluateCompleteWithoutExplicitReceiver(msg, context, context.getRealContext());
                    if (IokeObject.isTrue(((Message)IokeObject.data(runtime.eqqMessage)).sendTo(runtime.eqqMessage, context, when, value))) {
                        msg = IokeObject.as(args.get(index++), context);
                        return ((Message)IokeObject.data(msg)).evaluateCompleteWithoutExplicitReceiver(msg, context, context.getRealContext());
                    }
                    ++index;
                    argCount -= 2;
                }
                if (argCount == 1) {
                    msg = IokeObject.as(args.get(index++), context);
                    return ((Message)IokeObject.data(msg)).evaluateCompleteWithoutExplicitReceiver(msg, context, context.getRealContext());
                }
                return runtime.nil;
            }
        }));
    }
}

