/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.IokeData;
import ioke.lang.IokeObject;
import ioke.lang.NativeMethod;
import ioke.lang.Runtime;
import ioke.lang.TypeCheckingArgumentsDefinition;
import ioke.lang.TypeCheckingNativeMethod;
import ioke.lang.exceptions.ControlFlow;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DateTime
extends IokeData {
    private org.joda.time.DateTime dateTime;

    public DateTime() {
        this(new org.joda.time.DateTime());
    }

    public DateTime(org.joda.time.DateTime val) {
        this.dateTime = val;
    }

    public DateTime(long instant) {
        this(new org.joda.time.DateTime(instant));
    }

    public static org.joda.time.DateTime getDateTime(Object on) {
        return ((DateTime)IokeObject.data((Object)on)).dateTime;
    }

    public void init(IokeObject obj) throws ControlFlow {
        Runtime runtime = obj.runtime;
        obj.setKind("DateTime");
        obj.registerMethod(runtime.newNativeMethod("returns true if the left hand side datetime is equal to the right hand side datetime.", new TypeCheckingNativeMethod("=="){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.dateTime).withRequiredPositional("other").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                DateTime d = (DateTime)IokeObject.data(on);
                Object other = args.get(0);
                return other instanceof IokeObject && IokeObject.data(other) instanceof DateTime && d.dateTime.equals(((DateTime)IokeObject.data(other)).dateTime) ? context.runtime._true : context.runtime._false;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("Returns a new DateTime representing the current instant in time in the default TimeZone.", new NativeMethod.WithNoArguments("now"){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return method.runtime.newDateTime(new org.joda.time.DateTime());
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("Expects to get one DateTime as argument, and returns the difference between this instant and that instant, in milliseconds.", new TypeCheckingNativeMethod("-"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.dateTime).withRequiredPositional("subtrahend").whichMustMimic(runtime.dateTime).getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                long diff = DateTime.getDateTime(on).getMillis() - DateTime.getDateTime(args.get(0)).getMillis();
                return context.runtime.newNumber(diff);
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("Returns a text inspection of the object", new TypeCheckingNativeMethod.WithNoArguments("inspect", runtime.dateTime){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return method.runtime.newText(DateTime.getInspect(on));
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("Returns a brief text inspection of the object", new TypeCheckingNativeMethod.WithNoArguments("notice", runtime.dateTime){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return method.runtime.newText(DateTime.getNotice(on));
            }
        }));
    }

    public IokeData cloneData(IokeObject obj, IokeObject m, IokeObject context) {
        return this;
    }

    public static String getInspect(Object on) throws ControlFlow {
        return ((DateTime)IokeObject.data(on)).inspect(on);
    }

    public static String getNotice(Object on) throws ControlFlow {
        return ((DateTime)IokeObject.data(on)).notice(on);
    }

    public String toString() {
        return this.dateTime.toString();
    }

    public String toString(IokeObject obj) {
        return this.dateTime.toString();
    }

    public String inspect(Object obj) throws ControlFlow {
        return this.dateTime.toString();
    }

    public String notice(Object obj) throws ControlFlow {
        return this.dateTime.toString();
    }
}

