/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.Call;
import ioke.lang.Dict;
import ioke.lang.IokeList;
import ioke.lang.IokeObject;
import ioke.lang.Message;
import ioke.lang.Restart;
import ioke.lang.RunnableWithControlFlow;
import ioke.lang.Runtime;
import ioke.lang.Text;
import ioke.lang.Tuple;
import ioke.lang.exceptions.ControlFlow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArgumentsDefinition {
    private final int min;
    private final int max;
    private final List<Argument> arguments;
    private final Collection<String> keywords;
    private final String rest;
    private final String krest;
    private final boolean restUneval;
    private boolean hasUnevaluated = false;

    protected DefaultArgumentsDefinition(List<Argument> arguments, Collection<String> keywords, String rest, String krest, int min, int max, boolean restUneval) {
        this.arguments = arguments;
        this.keywords = keywords;
        this.rest = rest;
        this.krest = krest;
        this.min = min;
        this.max = max;
        this.restUneval = restUneval;
        this.hasUnevaluated = restUneval;
        for (Argument arg : arguments) {
            if (!(arg instanceof UnevaluatedArgument)) continue;
            this.hasUnevaluated = true;
            break;
        }
    }

    public Collection<String> getKeywords() {
        return this.keywords;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public String getRestName() {
        return this.rest;
    }

    public String getKrestName() {
        return this.krest;
    }

    public String getCode() {
        return this.getCode(true);
    }

    public String getCode(boolean lastComma) {
        boolean any = false;
        StringBuilder sb = new StringBuilder();
        for (Argument argument : this.arguments) {
            Object defValue;
            any = true;
            if (!(argument instanceof KeywordArgument)) {
                if (argument instanceof UnevaluatedArgument) {
                    sb.append("[").append(argument.getName()).append("]");
                    if (!((UnevaluatedArgument)argument).isRequired()) {
                        sb.append(" nil");
                    }
                } else {
                    sb.append(argument.getName());
                }
            } else {
                sb.append(argument.getName()).append(":");
            }
            if (argument instanceof OptionalArgument && ((OptionalArgument)argument).getDefaultValue() != null) {
                sb.append(" ");
                defValue = ((OptionalArgument)argument).getDefaultValue();
                if (defValue instanceof String) {
                    sb.append(defValue);
                } else {
                    sb.append(Message.code(IokeObject.as(defValue, null)));
                }
            } else if (argument instanceof KeywordArgument && ((KeywordArgument)argument).getDefaultValue() != null) {
                sb.append(" ");
                defValue = ((KeywordArgument)argument).getDefaultValue();
                if (defValue instanceof String) {
                    sb.append(defValue);
                } else {
                    sb.append(Message.code(IokeObject.as(defValue, null)));
                }
            }
            sb.append(", ");
        }
        if (this.rest != null) {
            any = true;
            if (this.restUneval) {
                sb.append("+[").append(this.rest).append("], ");
            } else {
                sb.append("+").append(this.rest).append(", ");
            }
        }
        if (this.krest != null) {
            any = true;
            sb.append("+:").append(this.krest).append(", ");
        }
        if (!lastComma && any) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    public int checkArgumentCount(IokeObject context, IokeObject message, Object on) throws ControlFlow {
        Runtime runtime = context.runtime;
        List<Object> arguments = message.getArguments();
        int argCount = arguments.size();
        int keySize = this.keywords.size();
        if (argCount < this.min || this.max != -1 && argCount > this.max + keySize) {
            int finalArgCount = argCount;
            if (argCount < this.min) {
                IokeObject condition = IokeObject.as(IokeObject.getCellChain(runtime.condition, message, context, "Error", "Invocation", "TooFewArguments"), context).mimic(message, context);
                condition.setCell("message", message);
                condition.setCell("context", context);
                condition.setCell("receiver", on);
                condition.setCell("missing", runtime.newNumber(this.min - argCount));
                runtime.errorCondition(condition);
            } else {
                runtime.withReturningRestart("ignoreExtraArguments", context, new RunnableWithControlFlow(){

                    public void run() throws ControlFlow {
                        IokeObject condition = IokeObject.as(IokeObject.getCellChain(runtime.condition, message, context, "Error", "Invocation", "TooManyArguments"), context).mimic(message, context);
                        condition.setCell("message", message);
                        condition.setCell("context", context);
                        condition.setCell("receiver", on);
                        condition.setCell("extra", runtime.newList(arguments.subList(DefaultArgumentsDefinition.this.max, finalArgCount)));
                        runtime.errorCondition(condition);
                    }
                });
                argCount = this.max;
            }
        }
        return argCount;
    }

    public int getEvaluatedArguments(IokeObject context, IokeObject message, Object on, List<Object> argumentsWithoutKeywords, Map<String, Object> givenKeywords) throws ControlFlow {
        Runtime runtime = context.runtime;
        List<Object> arguments = message.getArguments();
        int argCount = 0;
        for (Object o : arguments) {
            if (Message.isKeyword(o)) {
                givenKeywords.put(IokeObject.as(o, context).getName(), Message.getEvaluatedArgument(((Message)IokeObject.data((Object)o)).next, context));
                continue;
            }
            if (Message.hasName(o, "*") && IokeObject.as(o, context).getArguments().size() == 1) {
                Object result = Message.getEvaluatedArgument(IokeObject.as(o, context).getArguments().get(0), context);
                if (IokeObject.data(result) instanceof IokeList) {
                    List<Object> elements = IokeList.getList(result);
                    argumentsWithoutKeywords.addAll(elements);
                    argCount += elements.size();
                    continue;
                }
                if (IokeObject.data(result) instanceof Dict) {
                    Map<Object, Object> keys = Dict.getMap(result);
                    for (Map.Entry<Object, Object> me : keys.entrySet()) {
                        givenKeywords.put(Text.getText(IokeObject.convertToText(me.getKey(), message, context, true)) + ":", me.getValue());
                    }
                    continue;
                }
                if (IokeObject.findCell(result, message, context, "asTuple") != runtime.nul) {
                    Object tupledValue = ((Message)IokeObject.data(runtime.asTuple)).sendTo(runtime.asTuple, context, result);
                    Object[] values = Tuple.getElements(tupledValue);
                    argumentsWithoutKeywords.addAll(Arrays.asList(values));
                    argCount += values.length;
                    continue;
                }
                IokeObject condition = IokeObject.as(IokeObject.getCellChain(runtime.condition, message, context, "Error", "Invocation", "NotSpreadable"), context).mimic(message, context);
                condition.setCell("message", message);
                condition.setCell("context", context);
                condition.setCell("receiver", on);
                condition.setCell("given", result);
                List<Object> outp = IokeList.getList(runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

                    public void run() throws ControlFlow {
                        runtime.errorCondition(condition);
                    }
                }, context, new Restart.DefaultValuesGivingRestart("ignoreArgument", runtime.nil, 0), new Restart.DefaultValuesGivingRestart("takeArgumentAsIs", IokeObject.as(result, context), 1)));
                argumentsWithoutKeywords.addAll(outp);
                argCount += outp.size();
                continue;
            }
            argumentsWithoutKeywords.add(Message.getEvaluatedArgument(o, context));
            ++argCount;
        }
        while (argCount < this.min || this.max != -1 && argCount > this.max) {
            int finalArgCount = argCount;
            if (argCount < this.min) {
                IokeObject condition = IokeObject.as(IokeObject.getCellChain(runtime.condition, message, context, "Error", "Invocation", "TooFewArguments"), context).mimic(message, context);
                condition.setCell("message", message);
                condition.setCell("context", context);
                condition.setCell("receiver", on);
                condition.setCell("missing", runtime.newNumber(this.min - argCount));
                List<Object> newArguments = IokeList.getList(runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

                    public void run() throws ControlFlow {
                        runtime.errorCondition(condition);
                    }
                }, context, new Restart.ArgumentGivingRestart("provideExtraArguments"){

                    @Override
                    public List<String> getArgumentNames() {
                        return new ArrayList<String>(Arrays.asList("newArgument"));
                    }
                }, new Restart.DefaultValuesGivingRestart("substituteNilArguments", runtime.nil, this.min - argCount){

                    @Override
                    public List<String> getArgumentNames() {
                        return new ArrayList<String>();
                    }
                }));
                argCount += newArguments.size();
                argumentsWithoutKeywords.addAll(newArguments);
                continue;
            }
            runtime.withReturningRestart("ignoreExtraArguments", context, new RunnableWithControlFlow(){

                public void run() throws ControlFlow {
                    IokeObject condition = IokeObject.as(IokeObject.getCellChain(runtime.condition, message, context, "Error", "Invocation", "TooManyArguments"), context).mimic(message, context);
                    condition.setCell("message", message);
                    condition.setCell("context", context);
                    condition.setCell("receiver", on);
                    condition.setCell("extra", runtime.newList(argumentsWithoutKeywords.subList(DefaultArgumentsDefinition.this.max, finalArgCount)));
                    runtime.errorCondition(condition);
                }
            });
            argCount = this.max;
        }
        LinkedHashSet<String> intersection = new LinkedHashSet<String>(givenKeywords.keySet());
        intersection.removeAll(this.keywords);
        if (this.krest == null && !intersection.isEmpty()) {
            runtime.withReturningRestart("ignoreExtraKeywords", context, new RunnableWithControlFlow(){

                public void run() throws ControlFlow {
                    IokeObject condition = IokeObject.as(IokeObject.getCellChain(runtime.condition, message, context, "Error", "Invocation", "MismatchedKeywords"), context).mimic(message, context);
                    condition.setCell("message", message);
                    condition.setCell("context", context);
                    condition.setCell("receiver", on);
                    ArrayList<Object> expected = new ArrayList<Object>();
                    for (String s : DefaultArgumentsDefinition.this.keywords) {
                        expected.add(runtime.newText(s));
                    }
                    condition.setCell("expected", runtime.newList(expected));
                    ArrayList<Object> extra = new ArrayList<Object>();
                    for (String s : intersection) {
                        extra.add(runtime.newText(s));
                    }
                    condition.setCell("extra", runtime.newList(extra));
                    runtime.errorCondition(condition);
                }
            });
        }
        return argCount;
    }

    public void assignArgumentValues(IokeObject locals, IokeObject context, IokeObject message, Object on, Call call) throws ControlFlow {
        if (call.cachedPositional != null) {
            this.assignArgumentValues(locals, context, message, on, call.cachedPositional, call.cachedKeywords, call.cachedArgCount);
        } else {
            ArrayList<Object> argumentsWithoutKeywords = new ArrayList<Object>();
            LinkedHashMap<String, Object> givenKeywords = new LinkedHashMap<String, Object>();
            int argCount = this.getEvaluatedArguments(context, message, on, argumentsWithoutKeywords, givenKeywords);
            call.cachedPositional = argumentsWithoutKeywords;
            call.cachedKeywords = givenKeywords;
            call.cachedArgCount = argCount;
            this.assignArgumentValues(locals, context, message, on, argumentsWithoutKeywords, givenKeywords, argCount);
        }
    }

    public void assignArgumentValues(IokeObject locals, IokeObject context, IokeObject message, Object on) throws ControlFlow {
        ArrayList<Object> argumentsWithoutKeywords = new ArrayList<Object>();
        LinkedHashMap<String, Object> givenKeywords = new LinkedHashMap<String, Object>();
        int argCount = this.getEvaluatedArguments(context, message, on, argumentsWithoutKeywords, givenKeywords);
        this.assignArgumentValues(locals, context, message, on, argumentsWithoutKeywords, givenKeywords, argCount);
    }

    private void assignArgumentValues(IokeObject locals, IokeObject context, IokeObject message, Object on, List<Object> argumentsWithoutKeywords, Map<String, Object> givenKeywords, int argCount) throws ControlFlow {
        Object result;
        Object given;
        Runtime runtime = context.runtime;
        LinkedHashSet<String> intersection = new LinkedHashSet<String>(givenKeywords.keySet());
        intersection.removeAll(this.keywords);
        int ix = 0;
        int j = this.arguments.size();
        for (int i = 0; i < j; ++i) {
            Argument a = this.arguments.get(i);
            if (a instanceof KeywordArgument) {
                given = givenKeywords.get(a.getName() + ":");
                result = null;
                if (given == null) {
                    Object defVal = ((KeywordArgument)a).getDefaultValue();
                    if (defVal instanceof String) continue;
                    IokeObject msg = IokeObject.as(defVal, context);
                    result = ((Message)IokeObject.data(msg)).evaluateCompleteWithoutExplicitReceiver(msg, locals, locals.getRealContext());
                    locals.setCell(a.getName(), result);
                    continue;
                }
                result = given;
                locals.setCell(a.getName(), result);
                continue;
            }
            if (a instanceof OptionalArgument && ix >= argCount) {
                Object defVal = ((OptionalArgument)a).getDefaultValue();
                if (defVal instanceof String) continue;
                IokeObject msg = IokeObject.as(defVal, context);
                locals.setCell(a.getName(), ((Message)IokeObject.data(msg)).evaluateCompleteWithoutExplicitReceiver(msg, locals, locals.getRealContext()));
                continue;
            }
            locals.setCell(a.getName(), argumentsWithoutKeywords.get(ix++));
        }
        if (this.krest != null) {
            LinkedHashMap<Object, Object> krests = new LinkedHashMap<Object, Object>();
            for (String s : intersection) {
                result = given = givenKeywords.get(s);
                krests.put(runtime.getSymbol(s.substring(0, s.length() - 1)), result);
            }
            locals.setCell(this.krest, runtime.newDict(krests));
        }
        if (this.rest != null) {
            ArrayList<Object> rests = new ArrayList<Object>();
            j = argumentsWithoutKeywords.size();
            while (ix < j) {
                rests.add(argumentsWithoutKeywords.get(ix));
                ++ix;
            }
            locals.setCell(this.rest, runtime.newList(rests));
        }
    }

    public boolean isEmpty() {
        return this.min == 0 && this.max == 0 && this.arguments.isEmpty() && this.keywords.isEmpty() && this.rest == null && this.krest == null;
    }

    public static DefaultArgumentsDefinition empty() {
        return new DefaultArgumentsDefinition(new ArrayList<Argument>(), new ArrayList<String>(), null, null, 0, 0, false);
    }

    public static int indexOf(List<Object> objs, Object obj) {
        int i = 0;
        for (Object o : objs) {
            if (o == obj) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static DefaultArgumentsDefinition createFrom(List<Object> args, int start, int len, IokeObject message, Object on, IokeObject context) throws ControlFlow {
        Runtime runtime = context.runtime;
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        ArrayList<String> keywords = new ArrayList<String>();
        int min = 0;
        int max = 0;
        boolean hadOptional = false;
        String rest = null;
        String krest = null;
        for (Object obj : args.subList(start, len)) {
            Message m = (Message)IokeObject.data(obj);
            String mname = m.getName(null);
            if (!"+:".equals(mname) && m.isKeyword()) {
                String name = mname;
                IokeObject dValue = context.runtime.nilMessage;
                if (m.next != null) {
                    dValue = m.next;
                }
                arguments.add(new KeywordArgument(name.substring(0, name.length() - 1), dValue));
                keywords.add(name);
                continue;
            }
            if (mname.equals("+")) {
                String name = Message.name(m.getArguments(null).get(0));
                if (name.startsWith(":")) {
                    krest = name.substring(1);
                } else {
                    rest = name;
                    max = -1;
                }
                hadOptional = true;
                continue;
            }
            if (mname.equals("+:")) {
                String name;
                krest = name = m.next != null ? Message.name(m.next) : Message.name(m.getArguments(null).get(0));
                hadOptional = true;
                continue;
            }
            if (m.next != null) {
                String name = mname;
                hadOptional = true;
                if (max != -1) {
                    ++max;
                }
                arguments.add(new OptionalArgument(name, m.next));
                continue;
            }
            if (hadOptional) {
                int index = DefaultArgumentsDefinition.indexOf(args, obj) + start;
                IokeObject condition = IokeObject.as(IokeObject.getCellChain(runtime.condition, message, context, "Error", "Invocation", "ArgumentWithoutDefaultValue"), context).mimic(message, context);
                condition.setCell("message", message);
                condition.setCell("context", context);
                condition.setCell("receiver", on);
                condition.setCell("argumentName", runtime.getSymbol(m.getName(null)));
                condition.setCell("index", runtime.newNumber(index));
                List<Object> newValue = IokeList.getList(runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

                    public void run() throws ControlFlow {
                        runtime.errorCondition(condition);
                    }
                }, context, new Restart.ArgumentGivingRestart("provideDefaultValue"){

                    @Override
                    public List<String> getArgumentNames() {
                        return new ArrayList<String>(Arrays.asList("defaultValue"));
                    }
                }, new Restart.DefaultValuesGivingRestart("substituteNilDefault", runtime.nil, 1)));
                if (max != -1) {
                    ++max;
                }
                arguments.add(new OptionalArgument(m.getName(null), runtime.createMessage(Message.wrap(IokeObject.as(newValue.get(0), context)))));
                continue;
            }
            ++min;
            ++max;
            arguments.add(new Argument(IokeObject.as(obj, context).getName()));
        }
        return new DefaultArgumentsDefinition(arguments, keywords, rest, krest, min, max, false);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected int min = 0;
        protected int max = 0;
        protected List<Argument> arguments = new ArrayList<Argument>();
        protected Collection<String> keywords = new HashSet<String>();
        protected String rest = null;
        protected String krest = null;
        protected boolean restUneval = false;

        public Builder withRequiredPositionalUnevaluated(String name) {
            this.arguments.add(new UnevaluatedArgument(name, true));
            ++this.min;
            if (this.max != -1) {
                ++this.max;
            }
            return this;
        }

        public Builder withOptionalPositionalUnevaluated(String name) {
            this.arguments.add(new UnevaluatedArgument(name, false));
            if (this.max != -1) {
                ++this.max;
            }
            return this;
        }

        public Builder withRestUnevaluated(String name) {
            this.rest = name;
            this.restUneval = true;
            this.max = -1;
            return this;
        }

        public Builder withRest(String name) {
            this.rest = name;
            this.max = -1;
            return this;
        }

        public Builder withKeywordRest(String name) {
            this.krest = name;
            return this;
        }

        public Builder withKeywordRestUnevaluated(String name) {
            this.krest = name;
            this.restUneval = true;
            return this;
        }

        public Builder withRequiredPositional(String name) {
            this.arguments.add(new Argument(name));
            ++this.min;
            if (this.max != -1) {
                ++this.max;
            }
            return this;
        }

        public Builder withKeyword(String name) {
            this.arguments.add(new KeywordArgument(name, "nil"));
            this.keywords.add(name + ":");
            return this;
        }

        public Builder withOptionalPositional(String name, String defaultValue) {
            this.arguments.add(new OptionalArgument(name, defaultValue));
            if (this.max != -1) {
                ++this.max;
            }
            return this;
        }

        public DefaultArgumentsDefinition getArguments() {
            return new DefaultArgumentsDefinition(this.arguments, this.keywords, this.rest, this.krest, this.min, this.max, this.restUneval);
        }
    }

    public static class KeywordArgument
    extends Argument {
        private Object defaultValue;

        public KeywordArgument(String name, Object defaultValue) {
            super(name);
            this.defaultValue = defaultValue;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }

    public static class OptionalArgument
    extends Argument {
        private Object defaultValue;

        public OptionalArgument(String name, Object defaultValue) {
            super(name);
            this.defaultValue = defaultValue;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }

    public static class UnevaluatedArgument
    extends Argument {
        private boolean required;

        public UnevaluatedArgument(String name, boolean required) {
            super(name);
            this.required = required;
        }

        public boolean isRequired() {
            return this.required;
        }
    }

    public static class Argument {
        private String name;

        public Argument(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

