/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.AliasMethod;
import ioke.lang.AssociatedCode;
import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.Inspectable;
import ioke.lang.IokeData;
import ioke.lang.IokeObject;
import ioke.lang.Message;
import ioke.lang.Named;
import ioke.lang.NativeMethod;
import ioke.lang.TypeCheckingNativeMethod;
import ioke.lang.exceptions.ControlFlow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMacro
extends IokeData
implements Named,
Inspectable,
AssociatedCode {
    String name;
    private IokeObject code;

    public DefaultMacro(String name) {
        this.name = name;
    }

    public DefaultMacro(IokeObject context, IokeObject code) {
        this(null);
        this.code = code;
    }

    @Override
    public IokeObject getCode() {
        return this.code;
    }

    public String getCodeString() {
        return "macro(" + Message.code(this.code) + ")";
    }

    @Override
    public String getFormattedCode(Object self) throws ControlFlow {
        return "macro(\n  " + Message.formattedCode(this.code, 2, (IokeObject)self) + ")";
    }

    @Override
    public void init(IokeObject macro) throws ControlFlow {
        macro.setKind("DefaultMacro");
        macro.registerCell("activatable", macro.runtime._true);
        macro.registerMethod(macro.runtime.newNativeMethod("returns the name of the macro", new TypeCheckingNativeMethod.WithNoArguments("name", macro){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return context.runtime.newText(((DefaultMacro)IokeObject.data((Object)on)).name);
            }
        }));
        macro.registerMethod(macro.runtime.newNativeMethod("activates this macro with the arguments given to call", new NativeMethod("call"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRestUnevaluated("arguments").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                return IokeObject.as(on, context).activate(context, message, context.getRealContext());
            }
        }));
        macro.registerMethod(macro.runtime.newNativeMethod("returns the message chain for this macro", new TypeCheckingNativeMethod.WithNoArguments("message", macro){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return ((AssociatedCode)((Object)IokeObject.data(on))).getCode();
            }
        }));
        macro.registerMethod(macro.runtime.newNativeMethod("returns the code for the argument definition", new TypeCheckingNativeMethod.WithNoArguments("argumentsCode", macro){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return context.runtime.newText(((AssociatedCode)((Object)IokeObject.data(on))).getArgumentsCode());
            }
        }));
        macro.registerMethod(macro.runtime.newNativeMethod("Returns a text inspection of the object", new TypeCheckingNativeMethod.WithNoArguments("inspect", macro){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return context.runtime.newText(DefaultMacro.getInspect(on));
            }
        }));
        macro.registerMethod(macro.runtime.newNativeMethod("Returns a brief text inspection of the object", new TypeCheckingNativeMethod.WithNoArguments("notice", macro){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return context.runtime.newText(DefaultMacro.getNotice(on));
            }
        }));
        macro.registerMethod(macro.runtime.newNativeMethod("returns the full code of this macro, as a Text", new TypeCheckingNativeMethod.WithNoArguments("code", macro){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                IokeData data = IokeObject.data(on);
                if (data instanceof DefaultMacro) {
                    return context.runtime.newText(((DefaultMacro)data).getCodeString());
                }
                return context.runtime.newText(((AliasMethod)data).getCodeString());
            }
        }));
        macro.registerMethod(macro.runtime.newNativeMethod("returns idiomatically formatted code for this macro", new TypeCheckingNativeMethod.WithNoArguments("formattedCode", macro){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return context.runtime.newText(((AssociatedCode)((Object)IokeObject.data(on))).getFormattedCode(method));
            }
        }));
    }

    @Override
    public String getArgumentsCode() {
        return "...";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public static String getInspect(Object on) {
        return ((Inspectable)((Object)IokeObject.data(on))).inspect(on);
    }

    public static String getNotice(Object on) {
        return ((Inspectable)((Object)IokeObject.data(on))).notice(on);
    }

    @Override
    public String inspect(Object self) {
        if (this.name == null) {
            return "macro(" + Message.code(this.code) + ")";
        }
        return this.name + ":macro(" + Message.code(this.code) + ")";
    }

    @Override
    public String notice(Object self) {
        if (this.name == null) {
            return "macro(...)";
        }
        return this.name + ":macro(...)";
    }

    @Override
    public Object activateWithCallAndData(IokeObject self, IokeObject context, IokeObject message, Object on, Object call, Map<String, Object> data) throws ControlFlow {
        if (this.code == null) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, message, context, "Error", "Invocation", "NotActivatable"), context).mimic(message, context);
            condition.setCell("message", message);
            condition.setCell("context", context);
            condition.setCell("receiver", on);
            condition.setCell("method", self);
            condition.setCell("report", context.runtime.newText("You tried to activate a method without any code - did you by any chance activate the DefaultMacro kind by referring to it without wrapping it inside a call to cell?"));
            context.runtime.errorCondition(condition);
            return null;
        }
        IokeObject c = context.runtime.locals.mimic(message, context);
        c.setCell("self", on);
        c.setCell("@", on);
        c.registerMethod(c.runtime.newNativeMethod("will return the currently executing macro receiver", new NativeMethod.WithNoArguments("@@"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return self;
            }
        }));
        c.setCell("currentMessage", message);
        c.setCell("surroundingContext", context);
        c.setCell("call", call);
        for (Map.Entry<String, Object> d : data.entrySet()) {
            String s = d.getKey();
            c.setCell(s.substring(0, s.length() - 1), d.getValue());
        }
        try {
            return ((Message)IokeObject.data(this.code)).evaluateCompleteWith(this.code, c, on);
        }
        catch (ControlFlow.Return e) {
            if (e.context == c) {
                return e.getValue();
            }
            throw e;
        }
    }

    @Override
    public Object activateWithCall(IokeObject self, IokeObject context, IokeObject message, Object on, Object call) throws ControlFlow {
        if (this.code == null) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, message, context, "Error", "Invocation", "NotActivatable"), context).mimic(message, context);
            condition.setCell("message", message);
            condition.setCell("context", context);
            condition.setCell("receiver", on);
            condition.setCell("method", self);
            condition.setCell("report", context.runtime.newText("You tried to activate a method without any code - did you by any chance activate the DefaultMacro kind by referring to it without wrapping it inside a call to cell?"));
            context.runtime.errorCondition(condition);
            return null;
        }
        IokeObject c = context.runtime.locals.mimic(message, context);
        c.setCell("self", on);
        c.setCell("@", on);
        c.registerMethod(c.runtime.newNativeMethod("will return the currently executing macro receiver", new NativeMethod.WithNoArguments("@@"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return self;
            }
        }));
        c.setCell("currentMessage", message);
        c.setCell("surroundingContext", context);
        c.setCell("call", call);
        try {
            return ((Message)IokeObject.data(this.code)).evaluateCompleteWith(this.code, c, on);
        }
        catch (ControlFlow.Return e) {
            if (e.context == c) {
                return e.getValue();
            }
            throw e;
        }
    }

    @Override
    public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
        if (this.code == null) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, message, context, "Error", "Invocation", "NotActivatable"), context).mimic(message, context);
            condition.setCell("message", message);
            condition.setCell("context", context);
            condition.setCell("receiver", on);
            condition.setCell("method", self);
            condition.setCell("report", context.runtime.newText("You tried to activate a method without any code - did you by any chance activate the DefaultMacro kind by referring to it without wrapping it inside a call to cell?"));
            context.runtime.errorCondition(condition);
            return null;
        }
        IokeObject c = context.runtime.locals.mimic(message, context);
        c.setCell("self", on);
        c.setCell("@", on);
        c.registerMethod(c.runtime.newNativeMethod("will return the currently executing macro receiver", new NativeMethod.WithNoArguments("@@"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return self;
            }
        }));
        c.setCell("currentMessage", message);
        c.setCell("surroundingContext", context);
        c.setCell("call", context.runtime.newCallFrom(c, message, context, IokeObject.as(on, context)));
        try {
            return ((Message)IokeObject.data(this.code)).evaluateCompleteWith(this.code, c, on);
        }
        catch (ControlFlow.Return e) {
            if (e.context == c) {
                return e.getValue();
            }
            throw e;
        }
    }

    @Override
    public Object activateWithData(IokeObject self, IokeObject context, IokeObject message, Object on, Map<String, Object> data) throws ControlFlow {
        if (this.code == null) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, message, context, "Error", "Invocation", "NotActivatable"), context).mimic(message, context);
            condition.setCell("message", message);
            condition.setCell("context", context);
            condition.setCell("receiver", on);
            condition.setCell("method", self);
            condition.setCell("report", context.runtime.newText("You tried to activate a method without any code - did you by any chance activate the DefaultMacro kind by referring to it without wrapping it inside a call to cell?"));
            context.runtime.errorCondition(condition);
            return null;
        }
        IokeObject c = context.runtime.locals.mimic(message, context);
        c.setCell("self", on);
        c.setCell("@", on);
        c.registerMethod(c.runtime.newNativeMethod("will return the currently executing macro receiver", new NativeMethod.WithNoArguments("@@"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return self;
            }
        }));
        c.setCell("currentMessage", message);
        c.setCell("surroundingContext", context);
        c.setCell("call", context.runtime.newCallFrom(c, message, context, IokeObject.as(on, context)));
        for (Map.Entry<String, Object> d : data.entrySet()) {
            String s = d.getKey();
            c.setCell(s.substring(0, s.length() - 1), d.getValue());
        }
        try {
            return ((Message)IokeObject.data(this.code)).evaluateCompleteWith(this.code, c, on);
        }
        catch (ControlFlow.Return e) {
            if (e.context == c) {
                return e.getValue();
            }
            throw e;
        }
    }
}

