/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.AssociatedCode;
import ioke.lang.Call;
import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.IokeObject;
import ioke.lang.Message;
import ioke.lang.Method;
import ioke.lang.NativeMethod;
import ioke.lang.TypeCheckingNativeMethod;
import ioke.lang.exceptions.ControlFlow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMethod
extends Method
implements AssociatedCode {
    private DefaultArgumentsDefinition arguments;
    private IokeObject code;

    public DefaultMethod(String name) {
        super(name);
    }

    public DefaultMethod(IokeObject context, DefaultArgumentsDefinition arguments, IokeObject code) {
        super(context);
        this.arguments = arguments;
        this.code = code;
    }

    @Override
    public IokeObject getCode() {
        return this.code;
    }

    @Override
    public void init(IokeObject defaultMethod) throws ControlFlow {
        defaultMethod.setKind("DefaultMethod");
        defaultMethod.registerMethod(defaultMethod.runtime.newNativeMethod("returns a list of the keywords this method takes", new TypeCheckingNativeMethod.WithNoArguments("keywords", defaultMethod){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                ArrayList<Object> keywordList = new ArrayList<Object>();
                for (String keyword : ((DefaultMethod)IokeObject.data(on)).arguments.getKeywords()) {
                    keywordList.add(context.runtime.getSymbol(keyword.substring(0, keyword.length() - 1)));
                }
                return context.runtime.newList(keywordList);
            }
        }));
        defaultMethod.registerMethod(defaultMethod.runtime.newNativeMethod("returns the message chain for this method", new NativeMethod.WithNoArguments("message"){

            @Override
            public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return ((AssociatedCode)((Object)IokeObject.data(IokeObject.ensureTypeIs(AssociatedCode.class, self, on, context, message)))).getCode();
            }
        }));
        defaultMethod.registerMethod(defaultMethod.runtime.newNativeMethod("returns the code for the argument definition", new NativeMethod.WithNoArguments("argumentsCode"){

            @Override
            public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return context.runtime.newText(((AssociatedCode)((Object)IokeObject.data(IokeObject.ensureTypeIs(AssociatedCode.class, self, on, context, message)))).getArgumentsCode());
            }
        }));
        defaultMethod.registerMethod(defaultMethod.runtime.newNativeMethod("returns idiomatically formatted code for this method", new NativeMethod.WithNoArguments("formattedCode"){

            @Override
            public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return context.runtime.newText(((AssociatedCode)((Object)IokeObject.data(IokeObject.ensureTypeIs(AssociatedCode.class, self, on, context, message)))).getFormattedCode(self));
            }
        }));
    }

    @Override
    public String getArgumentsCode() {
        return this.arguments.getCode(false);
    }

    @Override
    public String getFormattedCode(Object self) throws ControlFlow {
        String args = this.arguments == null ? "" : this.arguments.getCode();
        return "method(" + args + "\n  " + Message.formattedCode(this.code, 2, (IokeObject)self) + ")";
    }

    @Override
    public String getCodeString() {
        String args = this.arguments == null ? "" : this.arguments.getCode();
        return "method(" + args + Message.code(this.code) + ")";
    }

    @Override
    public String inspect(Object self) {
        String args;
        String string = args = this.arguments == null ? "" : this.arguments.getCode();
        if (this.name == null) {
            return "method(" + args + Message.code(this.code) + ")";
        }
        return this.name + ":method(" + args + Message.code(this.code) + ")";
    }

    private IokeObject createSuperCallFor(IokeObject out_self, IokeObject out_context, IokeObject out_message, Object out_on, Object out_superCell) throws ControlFlow {
        return out_context.runtime.newNativeMethod("will call the super method of the current message on the same receiver", new NativeMethod("super"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRestUnevaluated("arguments").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                if (IokeObject.data(out_superCell) instanceof Method) {
                    return IokeObject.activate(out_superCell, context, message, out_on);
                }
                return out_superCell;
            }
        });
    }

    @Override
    public Object activateWithCall(IokeObject self, IokeObject context, IokeObject message, Object on, Object call) throws ControlFlow {
        if (this.code == null) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, message, context, "Error", "Invocation", "NotActivatable"), context).mimic(message, context);
            condition.setCell("message", message);
            condition.setCell("context", context);
            condition.setCell("receiver", on);
            condition.setCell("method", self);
            condition.setCell("report", context.runtime.newText("You tried to activate a method without any code - did you by any chance activate the DefaultMethod kind by referring to it without wrapping it inside a call to cell?"));
            context.runtime.errorCondition(condition);
            return null;
        }
        IokeObject c = context.runtime.locals.mimic(message, context);
        c.setCell("self", on);
        c.setCell("@", on);
        c.registerMethod(c.runtime.newNativeMethod("will return the currently executing method receiver", new NativeMethod.WithNoArguments("@@"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return self;
            }
        }));
        c.setCell("currentMessage", message);
        c.setCell("surroundingContext", context);
        Object superCell = IokeObject.findSuperCellOn(on, self, message, context, this.name);
        if (superCell == context.runtime.nul) {
            superCell = IokeObject.findSuperCellOn(on, self, message, context, Message.name(message));
        }
        if (superCell != context.runtime.nul) {
            c.setCell("super", this.createSuperCallFor(self, context, message, on, superCell));
        }
        this.arguments.assignArgumentValues(c, context, message, on, (Call)IokeObject.data(call));
        try {
            return ((Message)IokeObject.data(this.code)).evaluateCompleteWith(this.code, c, on);
        }
        catch (ControlFlow.Return e) {
            if (e.context == c) {
                return e.getValue();
            }
            throw e;
        }
    }

    @Override
    public Object activateWithCallAndData(IokeObject self, IokeObject context, IokeObject message, Object on, Object call, Map<String, Object> data) throws ControlFlow {
        if (this.code == null) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, message, context, "Error", "Invocation", "NotActivatable"), context).mimic(message, context);
            condition.setCell("message", message);
            condition.setCell("context", context);
            condition.setCell("receiver", on);
            condition.setCell("method", self);
            condition.setCell("report", context.runtime.newText("You tried to activate a method without any code - did you by any chance activate the DefaultMethod kind by referring to it without wrapping it inside a call to cell?"));
            context.runtime.errorCondition(condition);
            return null;
        }
        IokeObject c = context.runtime.locals.mimic(message, context);
        c.setCell("self", on);
        c.setCell("@", on);
        c.registerMethod(c.runtime.newNativeMethod("will return the currently executing method receiver", new NativeMethod.WithNoArguments("@@"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return self;
            }
        }));
        c.setCell("currentMessage", message);
        c.setCell("surroundingContext", context);
        for (Map.Entry<String, Object> d : data.entrySet()) {
            String s = d.getKey();
            c.setCell(s.substring(0, s.length() - 1), d.getValue());
        }
        Object superCell = IokeObject.findSuperCellOn(on, self, message, context, this.name);
        if (superCell == context.runtime.nul) {
            superCell = IokeObject.findSuperCellOn(on, self, message, context, Message.name(message));
        }
        if (superCell != context.runtime.nul) {
            c.setCell("super", this.createSuperCallFor(self, context, message, on, superCell));
        }
        this.arguments.assignArgumentValues(c, context, message, on, (Call)IokeObject.data(call));
        try {
            return ((Message)IokeObject.data(this.code)).evaluateCompleteWith(this.code, c, on);
        }
        catch (ControlFlow.Return e) {
            if (e.context == c) {
                return e.getValue();
            }
            throw e;
        }
    }

    @Override
    public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
        if (this.code == null) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, message, context, "Error", "Invocation", "NotActivatable"), context).mimic(message, context);
            condition.setCell("message", message);
            condition.setCell("context", context);
            condition.setCell("receiver", on);
            condition.setCell("method", self);
            condition.setCell("report", context.runtime.newText("You tried to activate a method without any code - did you by any chance activate the DefaultMethod kind by referring to it without wrapping it inside a call to cell?"));
            context.runtime.errorCondition(condition);
            return null;
        }
        IokeObject c = context.runtime.locals.mimic(message, context);
        c.setCell("self", on);
        c.setCell("@", on);
        c.registerMethod(c.runtime.newNativeMethod("will return the currently executing method receiver", new NativeMethod.WithNoArguments("@@"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return self;
            }
        }));
        c.setCell("currentMessage", message);
        c.setCell("surroundingContext", context);
        Object superCell = IokeObject.findSuperCellOn(on, self, message, context, this.name);
        if (superCell == context.runtime.nul) {
            superCell = IokeObject.findSuperCellOn(on, self, message, context, Message.name(message));
        }
        if (superCell != context.runtime.nul) {
            c.setCell("super", this.createSuperCallFor(self, context, message, on, superCell));
        }
        this.arguments.assignArgumentValues(c, context, message, on);
        try {
            return ((Message)IokeObject.data(this.code)).evaluateCompleteWith(this.code, c, on);
        }
        catch (ControlFlow.Return e) {
            if (e.context == c) {
                return e.getValue();
            }
            throw e;
        }
    }

    @Override
    public Object activateWithData(IokeObject self, IokeObject context, IokeObject message, Object on, Map<String, Object> data) throws ControlFlow {
        if (this.code == null) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, message, context, "Error", "Invocation", "NotActivatable"), context).mimic(message, context);
            condition.setCell("message", message);
            condition.setCell("context", context);
            condition.setCell("receiver", on);
            condition.setCell("method", self);
            condition.setCell("report", context.runtime.newText("You tried to activate a method without any code - did you by any chance activate the DefaultMethod kind by referring to it without wrapping it inside a call to cell?"));
            context.runtime.errorCondition(condition);
            return null;
        }
        IokeObject c = context.runtime.locals.mimic(message, context);
        c.setCell("self", on);
        c.setCell("@", on);
        c.registerMethod(c.runtime.newNativeMethod("will return the currently executing method receiver", new NativeMethod.WithNoArguments("@@"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return self;
            }
        }));
        c.setCell("currentMessage", message);
        c.setCell("surroundingContext", context);
        for (Map.Entry<String, Object> d : data.entrySet()) {
            String s = d.getKey();
            c.setCell(s.substring(0, s.length() - 1), d.getValue());
        }
        Object superCell = IokeObject.findSuperCellOn(on, self, message, context, this.name);
        if (superCell == context.runtime.nul) {
            superCell = IokeObject.findSuperCellOn(on, self, message, context, Message.name(message));
        }
        if (superCell != context.runtime.nul) {
            c.setCell("super", this.createSuperCallFor(self, context, message, on, superCell));
        }
        this.arguments.assignArgumentValues(c, context, message, on);
        try {
            return ((Message)IokeObject.data(this.code)).evaluateCompleteWith(this.code, c, on);
        }
        catch (ControlFlow.Return e) {
            if (e.context == c) {
                return e.getValue();
            }
            throw e;
        }
    }
}

