/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.AliasMethod;
import ioke.lang.AssociatedCode;
import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.Inspectable;
import ioke.lang.IokeData;
import ioke.lang.IokeObject;
import ioke.lang.Message;
import ioke.lang.Named;
import ioke.lang.NativeMethod;
import ioke.lang.TypeCheckingArgumentsDefinition;
import ioke.lang.TypeCheckingNativeMethod;
import ioke.lang.exceptions.ControlFlow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSyntax
extends IokeData
implements Named,
Inspectable,
AssociatedCode {
    String name;
    private IokeObject context;
    private IokeObject code;

    public DefaultSyntax(String name) {
        this.name = name;
    }

    public DefaultSyntax(IokeObject context, IokeObject code) {
        this(null);
        this.context = context;
        this.code = code;
    }

    @Override
    public IokeObject getCode() {
        return this.code;
    }

    public String getCodeString() {
        return "syntax(" + Message.code(this.code) + ")";
    }

    @Override
    public String getFormattedCode(Object self) throws ControlFlow {
        return "syntax(\n  " + Message.formattedCode(this.code, 2, (IokeObject)self) + ")";
    }

    @Override
    public void init(IokeObject syntax) throws ControlFlow {
        syntax.setKind("DefaultSyntax");
        syntax.registerCell("activatable", syntax.runtime._true);
        syntax.registerMethod(syntax.runtime.newNativeMethod("returns the name of the syntax", new TypeCheckingNativeMethod.WithNoArguments("name", syntax){

            @Override
            public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return context.runtime.newText(((DefaultSyntax)IokeObject.data((Object)on)).name);
            }
        }));
        syntax.registerMethod(syntax.runtime.newNativeMethod("activates this syntax with the arguments given to call", new NativeMethod("call"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRestUnevaluated("arguments").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                return IokeObject.as(on, context).activate(context, message, context.getRealContext());
            }
        }));
        syntax.registerMethod(syntax.runtime.newNativeMethod("returns the result of activating this syntax without actually doing the replacement or execution part.", new NativeMethod("expand"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().withRestUnevaluated("arguments").getArguments();
            }

            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                Object onAsSyntax = context.runtime.defaultSyntax.convertToThis(on, message, context);
                return ((DefaultSyntax)IokeObject.data(onAsSyntax)).expand(IokeObject.as(onAsSyntax, context), context, message, context.getRealContext(), null);
            }
        }));
        syntax.registerMethod(syntax.runtime.newNativeMethod("returns the message chain for this syntax", new NativeMethod.WithNoArguments("message"){

            @Override
            public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return ((AssociatedCode)((Object)IokeObject.data(IokeObject.ensureTypeIs(AssociatedCode.class, self, on, context, message)))).getCode();
            }
        }));
        syntax.registerMethod(syntax.runtime.newNativeMethod("returns the code for the argument definition", new NativeMethod.WithNoArguments("argumentsCode"){

            @Override
            public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return context.runtime.newText(((AssociatedCode)((Object)IokeObject.data(IokeObject.ensureTypeIs(AssociatedCode.class, self, on, context, message)))).getArgumentsCode());
            }
        }));
        syntax.registerMethod(syntax.runtime.newNativeMethod("Returns a text inspection of the object", new TypeCheckingNativeMethod.WithNoArguments("inspect", syntax){

            @Override
            public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return context.runtime.newText(DefaultSyntax.getInspect(on));
            }
        }));
        syntax.registerMethod(syntax.runtime.newNativeMethod("Returns a brief text inspection of the object", new TypeCheckingNativeMethod.WithNoArguments("notice", syntax){

            @Override
            public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return context.runtime.newText(DefaultSyntax.getNotice(on));
            }
        }));
        syntax.registerMethod(syntax.runtime.newNativeMethod("returns the full code of this syntax, as a Text", new TypeCheckingNativeMethod.WithNoArguments("code", syntax){

            @Override
            public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                IokeData data = IokeObject.data(on);
                if (data instanceof DefaultSyntax) {
                    return context.runtime.newText(((DefaultSyntax)data).getCodeString());
                }
                return context.runtime.newText(((AliasMethod)data).getCodeString());
            }
        }));
        syntax.registerMethod(syntax.runtime.newNativeMethod("returns idiomatically formatted code for this syntax", new NativeMethod.WithNoArguments("formattedCode"){

            @Override
            public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return context.runtime.newText(((AssociatedCode)((Object)IokeObject.data(IokeObject.ensureTypeIs(AssociatedCode.class, self, on, context, message)))).getFormattedCode(self));
            }
        }));
    }

    @Override
    public String getArgumentsCode() {
        return "...";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public static String getInspect(Object on) {
        return ((Inspectable)((Object)IokeObject.data(on))).inspect(on);
    }

    public static String getNotice(Object on) {
        return ((Inspectable)((Object)IokeObject.data(on))).notice(on);
    }

    @Override
    public String inspect(Object self) {
        if (this.name == null) {
            return "syntax(" + Message.code(this.code) + ")";
        }
        return this.name + ":syntax(" + Message.code(this.code) + ")";
    }

    @Override
    public String notice(Object self) {
        if (this.name == null) {
            return "syntax(...)";
        }
        return this.name + ":syntax(...)";
    }

    private Object expand(IokeObject self, IokeObject context, IokeObject message, Object on, Map<String, Object> data) throws ControlFlow {
        if (this.code == null) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, message, context, "Error", "Invocation", "NotActivatable"), context).mimic(message, context);
            condition.setCell("message", message);
            condition.setCell("context", context);
            condition.setCell("receiver", on);
            condition.setCell("method", self);
            condition.setCell("report", context.runtime.newText("You tried to activate a method without any code - did you by any chance activate the DefaultSyntax kind by referring to it without wrapping it inside a call to cell?"));
            context.runtime.errorCondition(condition);
            return null;
        }
        IokeObject c = context.runtime.locals.mimic(message, context);
        c.setCell("self", on);
        c.setCell("@", on);
        c.registerMethod(c.runtime.newNativeMethod("will return the currently executing syntax receiver", new NativeMethod.WithNoArguments("@@"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return self;
            }
        }));
        c.setCell("currentMessage", message);
        c.setCell("surroundingContext", context);
        c.setCell("call", context.runtime.newCallFrom(c, message, context, IokeObject.as(on, context)));
        if (data != null) {
            for (Map.Entry<String, Object> d : data.entrySet()) {
                String s = d.getKey();
                c.setCell(s.substring(0, s.length() - 1), d.getValue());
            }
        }
        Object result = null;
        try {
            result = ((Message)IokeObject.data(this.code)).evaluateCompleteWith(this.code, c, on);
        }
        catch (ControlFlow.Return e) {
            if (e.context == c) {
                result = e.getValue();
            }
            throw e;
        }
        return result;
    }

    private Object expandWithCall(IokeObject self, IokeObject context, IokeObject message, Object on, Object call, Map<String, Object> data) throws ControlFlow {
        if (this.code == null) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, message, context, "Error", "Invocation", "NotActivatable"), context).mimic(message, context);
            condition.setCell("message", message);
            condition.setCell("context", context);
            condition.setCell("receiver", on);
            condition.setCell("method", self);
            condition.setCell("report", context.runtime.newText("You tried to activate a method without any code - did you by any chance activate the DefaultSyntax kind by referring to it without wrapping it inside a call to cell?"));
            context.runtime.errorCondition(condition);
            return null;
        }
        IokeObject c = context.runtime.locals.mimic(message, context);
        c.setCell("self", on);
        c.setCell("@", on);
        c.registerMethod(c.runtime.newNativeMethod("will return the currently executing syntax receiver", new NativeMethod.WithNoArguments("@@"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return self;
            }
        }));
        c.setCell("currentMessage", message);
        c.setCell("surroundingContext", context);
        c.setCell("call", call);
        if (data != null) {
            for (Map.Entry<String, Object> d : data.entrySet()) {
                String s = d.getKey();
                c.setCell(s.substring(0, s.length() - 1), d.getValue());
            }
        }
        Object result = null;
        try {
            result = ((Message)IokeObject.data(this.code)).evaluateCompleteWith(this.code, c, on);
        }
        catch (ControlFlow.Return e) {
            if (e.context == c) {
                result = e.getValue();
            }
            throw e;
        }
        return result;
    }

    @Override
    public Object activateWithCallAndData(IokeObject self, IokeObject context, IokeObject message, Object on, Object call, Map<String, Object> data) throws ControlFlow {
        Object result = this.expandWithCall(self, context, message, on, call, data);
        if (result == context.runtime.nil) {
            IokeObject prev = Message.prev(message);
            IokeObject next = Message.next(message);
            if (prev != null) {
                Message.setNext(prev, next);
                if (next != null) {
                    Message.setPrev(next, prev);
                }
            } else {
                message.become(next, message, context);
                Message.setPrev(next, null);
            }
            return null;
        }
        IokeObject newObj = null;
        newObj = IokeObject.data(result) instanceof Message ? IokeObject.as(result, context) : context.runtime.createMessage(Message.wrap(IokeObject.as(result, context)));
        IokeObject prev = Message.prev(message);
        IokeObject next = Message.next(message);
        message.become(newObj, message, context);
        IokeObject last = newObj;
        while (Message.next(last) != null) {
            last = Message.next(last);
        }
        Message.setNext(last, next);
        if (next != null) {
            Message.setPrev(next, last);
        }
        Message.setPrev(newObj, prev);
        IokeObject receiver = prev == null || Message.isTerminator(prev) ? context : on;
        return ((Message)IokeObject.data(message)).sendTo(message, context, receiver);
    }

    @Override
    public Object activateWithCall(IokeObject self, IokeObject context, IokeObject message, Object on, Object call) throws ControlFlow {
        return this.activateWithCallAndData(self, context, message, on, call, null);
    }

    @Override
    public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
        return this.activateWithData(self, context, message, on, null);
    }

    @Override
    public Object activateWithData(IokeObject self, IokeObject context, IokeObject message, Object on, Map<String, Object> data) throws ControlFlow {
        Object result = this.expand(self, context, message, on, data);
        if (result == context.runtime.nil) {
            IokeObject prev = Message.prev(message);
            IokeObject next = Message.next(message);
            if (prev != null) {
                Message.setNext(prev, next);
                if (next != null) {
                    Message.setPrev(next, prev);
                }
            } else {
                message.become(next, message, context);
                Message.setPrev(next, null);
            }
            return null;
        }
        IokeObject newObj = null;
        newObj = IokeObject.data(result) instanceof Message ? IokeObject.as(result, context) : context.runtime.createMessage(Message.wrap(IokeObject.as(result, context)));
        IokeObject prev = Message.prev(message);
        IokeObject next = Message.next(message);
        message.become(newObj, message, context);
        IokeObject last = newObj;
        while (Message.next(last) != null) {
            last = Message.next(last);
        }
        Message.setNext(last, next);
        if (next != null) {
            Message.setPrev(next, last);
        }
        Message.setPrev(newObj, prev);
        IokeObject receiver = prev == null || Message.isTerminator(prev) ? context : on;
        return ((Message)IokeObject.data(message)).sendTo(message, context, receiver);
    }
}

