/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.DefaultMacro;
import ioke.lang.DefaultMethod;
import ioke.lang.DefaultSyntax;
import ioke.lang.IokeObject;
import ioke.lang.LexicalBlock;
import ioke.lang.LexicalMacro;
import ioke.lang.Message;
import ioke.lang.NativeMethod;
import ioke.lang.Runtime;
import ioke.lang.Text;
import ioke.lang.exceptions.ControlFlow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DefinitionsBehavior {
    public static void init(IokeObject obj) throws ControlFlow {
        Runtime runtime = obj.runtime;
        obj.setKind("DefaultBehavior Definitions");
        obj.registerMethod(runtime.newNativeMethod("expects any number of unevaluated arguments. if no arguments at all are given, will just return nil. creates a new method based on the arguments. this method will be evaluated using the context of the object it's called on, and thus the definition can not refer to the outside scope where the method is defined. (there are other ways of achieving this). all arguments except the last one is expected to be names of arguments that will be used in the method. there will possible be additions to the format of arguments later on - including named parameters and optional arguments. the actual code is the last argument given.", new NativeMethod("method"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withOptionalPositionalUnevaluated("documentation").withRestUnevaluated("argumentsAndBody").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                List<Object> args = message.getArguments();
                if (args.size() == 0) {
                    Message mx = new Message(context.runtime, "nil", null, false);
                    mx.setFile(Message.file(message));
                    mx.setLine(Message.line(message));
                    mx.setPosition(Message.position(message));
                    IokeObject mmx = context.runtime.createMessage(mx);
                    return runtime.newMethod(null, runtime.defaultMethod, new DefaultMethod(context, DefaultArgumentsDefinition.empty(), mmx));
                }
                String doc = null;
                ArrayList argNames = new ArrayList(args.size() - 1);
                int start = 0;
                if (args.size() > 1 && ((IokeObject)Message.getArg1(message)).getName().equals("internal:createText")) {
                    String s;
                    ++start;
                    doc = s = (String)((IokeObject)args.get(0)).getArguments().get(0);
                }
                DefaultArgumentsDefinition def = DefaultArgumentsDefinition.createFrom(args, start, args.size() - 1, message, on, context);
                return runtime.newMethod(doc, runtime.defaultMethod, new DefaultMethod(context, def, (IokeObject)args.get(args.size() - 1)));
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("expects one code argument, optionally preceeded by a documentation string. will create a new DefaultMacro based on the code and return it.", new NativeMethod("macro"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withOptionalPositionalUnevaluated("documentation").withOptionalPositionalUnevaluated("body").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                List<Object> args = message.getArguments();
                if (args.size() == 0) {
                    Message mx = new Message(context.runtime, "nil", null, false);
                    mx.setFile(Message.file(message));
                    mx.setLine(Message.line(message));
                    mx.setPosition(Message.position(message));
                    IokeObject mmx = context.runtime.createMessage(mx);
                    return runtime.newMacro(null, runtime.defaultMacro, new DefaultMacro(context, mmx));
                }
                String doc = null;
                int start = 0;
                if (args.size() > 1 && ((IokeObject)Message.getArg1(message)).getName().equals("internal:createText")) {
                    String s;
                    ++start;
                    doc = s = (String)((IokeObject)args.get(0)).getArguments().get(0);
                }
                return runtime.newMacro(doc, runtime.defaultMacro, new DefaultMacro(context, (IokeObject)args.get(start)));
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("expects one code argument, optionally preceeded by a documentation string. will create a new DefaultSyntax based on the code and return it.", new NativeMethod("syntax"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withOptionalPositionalUnevaluated("documentation").withOptionalPositionalUnevaluated("body").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                List<Object> args = message.getArguments();
                if (args.size() == 0) {
                    Message mx = new Message(context.runtime, "nil", null, false);
                    mx.setFile(Message.file(message));
                    mx.setLine(Message.line(message));
                    mx.setPosition(Message.position(message));
                    IokeObject mmx = context.runtime.createMessage(mx);
                    return runtime.newMacro(null, runtime.defaultSyntax, new DefaultSyntax(context, mmx));
                }
                String doc = null;
                int start = 0;
                if (args.size() > 1 && ((IokeObject)Message.getArg1(message)).getName().equals("internal:createText")) {
                    String s;
                    ++start;
                    doc = s = (String)((IokeObject)args.get(0)).getArguments().get(0);
                }
                return runtime.newMacro(doc, runtime.defaultSyntax, new DefaultSyntax(context, (IokeObject)args.get(start)));
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("expects one code argument, optionally preceeded by a documentation string. will create a new LexicalMacro based on the code and return it.", new NativeMethod("lecro"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withOptionalPositionalUnevaluated("documentation").withOptionalPositionalUnevaluated("body").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                List<Object> args = message.getArguments();
                if (args.size() == 0) {
                    Message mx = new Message(context.runtime, "nil", null, false);
                    mx.setFile(Message.file(message));
                    mx.setLine(Message.line(message));
                    mx.setPosition(Message.position(message));
                    IokeObject mmx = context.runtime.createMessage(mx);
                    return runtime.newMacro(null, runtime.lexicalMacro, new LexicalMacro(context, mmx));
                }
                String doc = null;
                int start = 0;
                if (args.size() > 1 && ((IokeObject)Message.getArg1(message)).getName().equals("internal:createText")) {
                    String s;
                    ++start;
                    doc = s = (String)((IokeObject)args.get(0)).getArguments().get(0);
                }
                return runtime.newMacro(doc, runtime.lexicalMacro, new LexicalMacro(context, (IokeObject)args.get(start)));
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("creates a new lexical block that can be executed at will, while retaining a reference to the lexical closure it was created in. it will always update variables if they exist. there is currently no way of introducing shadowing variables in the local context. new variables can be created though, just like in a method. a lexical block mimics LexicalBlock, and can take arguments. at the moment these are restricted to required arguments, but support for the same argument types as DefaultMethod will come.", new NativeMethod("fn"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withOptionalPositionalUnevaluated("documentation").withRestUnevaluated("argumentsAndBody").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                List<Object> args = message.getArguments();
                if (args.isEmpty()) {
                    return runtime.newLexicalBlock(null, runtime.lexicalBlock, new LexicalBlock(context, DefaultArgumentsDefinition.empty(), method.runtime.nilMessage));
                }
                String doc = null;
                ArrayList argNames = new ArrayList(args.size() - 1);
                int start = 0;
                if (args.size() > 1 && ((IokeObject)Message.getArg1(message)).getName().equals("internal:createText")) {
                    String s;
                    ++start;
                    doc = s = (String)((IokeObject)args.get(0)).getArguments().get(0);
                }
                IokeObject code = IokeObject.as(args.get(args.size() - 1), context);
                DefaultArgumentsDefinition def = DefaultArgumentsDefinition.createFrom(args, start, args.size() - 1, message, on, context);
                return runtime.newLexicalBlock(doc, runtime.lexicalBlock, new LexicalBlock(context, def, code));
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("Takes two evaluated text or symbol arguments that name the method to alias, and the new name to give it. returns the receiver.", new NativeMethod("aliasMethod"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositional("oldName").withRequiredPositional("newName").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                ArrayList<Object> args = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                String fromName = Text.getText(((Message)IokeObject.data(runtime.asText)).sendTo(runtime.asText, context, args.get(0)));
                String toName = Text.getText(((Message)IokeObject.data(runtime.asText)).sendTo(runtime.asText, context, args.get(1)));
                IokeObject.as(on, context).aliasMethod(fromName, toName, message, context);
                return on;
            }
        }));
    }
}

