/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.IokeData;
import ioke.lang.IokeObject;
import ioke.lang.LexicalContext;
import ioke.lang.Message;
import ioke.lang.NativeMethod;
import ioke.lang.Pair;
import ioke.lang.Runtime;
import ioke.lang.Sequence;
import ioke.lang.Symbol;
import ioke.lang.TypeCheckingArgumentsDefinition;
import ioke.lang.TypeCheckingNativeMethod;
import ioke.lang.exceptions.ControlFlow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dict
extends IokeData {
    private Map<Object, Object> dict;
    private IokeObject defaultValue;

    public Dict() {
        this(new HashMap<Object, Object>());
    }

    public Dict(Map<Object, Object> d) {
        this.dict = d;
    }

    public static IokeObject getDefaultValue(Object on, IokeObject context, IokeObject message) throws ControlFlow {
        Dict dict = (Dict)IokeObject.data(on);
        if (dict.defaultValue == null) {
            return context.runtime.nil;
        }
        return dict.defaultValue;
    }

    public static void setDefaultValue(Object on, IokeObject defaultValue) throws ControlFlow {
        Dict dict = (Dict)IokeObject.data(on);
        dict.defaultValue = defaultValue;
    }

    @Override
    public void init(IokeObject obj) throws ControlFlow {
        Runtime runtime = obj.runtime;
        obj.setKind("Dict");
        obj.mimics(IokeObject.as(runtime.mixins.getCell(null, null, "Sequenced"), null), runtime.nul, runtime.nul);
        obj.registerMethod(runtime.newNativeMethod("returns a hash for the dictionary", new NativeMethod.WithNoArguments("hash"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return context.runtime.newNumber(((Object)((Dict)IokeObject.data(on)).dict).hashCode());
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns true if the left hand side dictionary is equal to the right hand side dictionary.", new TypeCheckingNativeMethod("=="){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.dict).withRequiredPositional("other").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                Object other = args.get(0);
                return other instanceof IokeObject && IokeObject.data(other) instanceof Dict && ((Object)((Dict)IokeObject.data(on)).dict).equals(((Dict)IokeObject.data(other)).dict) ? context.runtime._true : context.runtime._false;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("takes one argument, that should be a default value, and returns a new mimic of the receiver, with the default value for that new dict set to the argument", new TypeCheckingNativeMethod("withDefault"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.dict).withRequiredPositional("defaultValue").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                IokeObject newDict = IokeObject.mimic(on, message, context);
                Dict.setDefaultValue(newDict, IokeObject.as(args.get(0), context));
                return newDict;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("creates a new Dict from the arguments provided, combined with the values in the receiver. the arguments provided will override those in the receiver. the rules for arguments are the same as for dict, except that dicts can also be provided. all positional arguments will be added before the keyword arguments.", new TypeCheckingNativeMethod("merge"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.dict).withRest("pairsAndDicts").withKeywordRest("keywordPairs").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                HashMap<Object, Object> newMap = new HashMap<Object, Object>();
                newMap.putAll(Dict.getMap(on));
                for (Object object : args) {
                    if (IokeObject.data(object) instanceof Dict) {
                        newMap.putAll(Dict.getMap(object));
                        continue;
                    }
                    if (IokeObject.data(object) instanceof Pair) {
                        newMap.put(Pair.getFirst(object), Pair.getSecond(object));
                        continue;
                    }
                    newMap.put(object, context.runtime.nil);
                }
                for (Map.Entry entry : keywords.entrySet()) {
                    String s = (String)entry.getKey();
                    IokeObject key = context.runtime.getSymbol(s.substring(0, s.length() - 1));
                    Object value = entry.getValue();
                    if (value == null) {
                        value = context.runtime.nil;
                    }
                    newMap.put(key, value);
                }
                return context.runtime.newDict(newMap);
            }
        }));
        obj.aliasMethod("merge", "+", null, null);
        obj.registerMethod(runtime.newNativeMethod("takes one argument, the key of the element to return. if the key doesn't map to anything in the dict, returns the default value", new TypeCheckingNativeMethod("at"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.dict).withRequiredPositional("key").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                Object result = Dict.getMap(on).get(args.get(0));
                if (result == null) {
                    return Dict.getDefaultValue(on, context, message);
                }
                return result;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns true if this dict is empty, false otherwise", new TypeCheckingNativeMethod.WithNoArguments("empty?", runtime.dict){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return Dict.getMap(on).isEmpty() ? context.runtime._true : context.runtime._false;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("takes one argument, the key to check if it is in the dict.", new TypeCheckingNativeMethod("key?"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.dict).withRequiredPositional("key").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return Dict.getMap(on).containsKey(args.get(0)) ? context.runtime._true : context.runtime._false;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("takes two arguments, the key of the element to set and the value to set it too. returns the value set", new TypeCheckingNativeMethod("[]="){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.dict).withRequiredPositional("key").withRequiredPositional("value").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                Dict.getMap(on).put(args.get(0), args.get(1));
                return args.get(1);
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("Returns the number of pairs contained in this dict.", new TypeCheckingNativeMethod.WithNoArguments("size", runtime.dict){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return runtime.newNumber(Dict.getMap(on).size());
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("Returns a text inspection of the object", new TypeCheckingNativeMethod.WithNoArguments("inspect", runtime.dict){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return method.runtime.newText(Dict.getInspect(on));
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("Returns a brief text inspection of the object", new TypeCheckingNativeMethod.WithNoArguments("notice", runtime.dict){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return method.runtime.newText(Dict.getNotice(on));
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("Returns all the keys of this dict", new TypeCheckingNativeMethod.WithNoArguments("keys", runtime.dict){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return method.runtime.newSet(Dict.getKeys(on));
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("returns a new sequence to iterate over this dictionary", new TypeCheckingNativeMethod.WithNoArguments("seq", runtime.dict){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                IokeObject obj = method.runtime.keyValueIteratorSequence.allocateCopy(null, null);
                obj.mimicsWithoutCheck(method.runtime.keyValueIteratorSequence);
                obj.setData(new Sequence.KeyValueIteratorSequence(Dict.getMap(on).entrySet().iterator()));
                return obj;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("takes either one or two or three arguments. if one argument is given, it should be a message chain that will be sent to each object in the dict. the result will be thrown away. if two arguments are given, the first is an unevaluated name that will be set to each of the entries in the dict in succession, and then the second argument will be evaluated in a scope with that argument in it. if three arguments is given, the first one is an unevaluated name that will be set to the index of each element, and the other two arguments are the name of the argument for the value, and the actual code. the code will evaluate in a lexical context, and if the argument name is available outside the context, it will be shadowed. the method will return the dict. the entries yielded will be mimics of Pair.", new NativeMethod("each"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withOptionalPositionalUnevaluated("indexOrArgOrCode").withOptionalPositionalUnevaluated("argOrCode").withOptionalPositionalUnevaluated("code").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                on = runtime.dict.convertToThis(on, message, context);
                Runtime runtime2 = context.runtime;
                Map<Object, Object> ls = Dict.getMap(on);
                switch (message.getArgumentCount()) {
                    case 0: {
                        return ((Message)IokeObject.data(runtime2.seqMessage)).sendTo(runtime2.seqMessage, context, on);
                    }
                    case 1: {
                        IokeObject code = IokeObject.as(message.getArguments().get(0), context);
                        for (Map.Entry<Object, Object> o : ls.entrySet()) {
                            ((Message)IokeObject.data(code)).evaluateCompleteWithReceiver(code, context, context.getRealContext(), runtime2.newPair(o.getKey(), o.getValue()));
                        }
                        break;
                    }
                    case 2: {
                        LexicalContext c = new LexicalContext(context.runtime, context, "Lexical activation context for List#each", message, context);
                        String name = IokeObject.as(message.getArguments().get(0), context).getName();
                        IokeObject code = IokeObject.as(message.getArguments().get(1), context);
                        for (Map.Entry<Object, Object> o : ls.entrySet()) {
                            c.setCell(name, runtime2.newPair(o.getKey(), o.getValue()));
                            ((Message)IokeObject.data(code)).evaluateCompleteWithoutExplicitReceiver(code, c, c.getRealContext());
                        }
                        break;
                    }
                    case 3: {
                        LexicalContext c = new LexicalContext(context.runtime, context, "Lexical activation context for List#each", message, context);
                        String iname = IokeObject.as(message.getArguments().get(0), context).getName();
                        String name = IokeObject.as(message.getArguments().get(1), context).getName();
                        IokeObject code = IokeObject.as(message.getArguments().get(2), context);
                        int index = 0;
                        for (Map.Entry<Object, Object> o : ls.entrySet()) {
                            c.setCell(name, runtime2.newPair(o.getKey(), o.getValue()));
                            c.setCell(iname, runtime2.newNumber(index++));
                            ((Message)IokeObject.data(code)).evaluateCompleteWithoutExplicitReceiver(code, c, c.getRealContext());
                        }
                        break;
                    }
                }
                return on;
            }
        }));
    }

    public static Map<Object, Object> getMap(Object dict) {
        return ((Dict)IokeObject.data(dict)).getMap();
    }

    public static Set<Object> getKeys(Object dict) {
        return ((Dict)IokeObject.data(dict)).getMap().keySet();
    }

    public Map<Object, Object> getMap() {
        return this.dict;
    }

    @Override
    public IokeData cloneData(IokeObject obj, IokeObject m, IokeObject context) {
        return new Dict(new HashMap<Object, Object>(this.dict));
    }

    public String toString() {
        return this.dict.toString();
    }

    @Override
    public String toString(IokeObject obj) {
        return this.dict.toString();
    }

    public static String getInspect(Object on) throws ControlFlow {
        return ((Dict)IokeObject.data(on)).inspect(on);
    }

    public static String getNotice(Object on) throws ControlFlow {
        return ((Dict)IokeObject.data(on)).notice(on);
    }

    public String inspect(Object obj) throws ControlFlow {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String sep = "";
        for (Map.Entry<Object, Object> o : this.dict.entrySet()) {
            sb.append(sep);
            Object key = o.getKey();
            if (IokeObject.data(key) instanceof Symbol && Symbol.onlyGoodChars(key)) {
                sb.append(Symbol.getText(key)).append(": ");
            } else {
                sb.append(IokeObject.inspect(key)).append(" => ");
            }
            sb.append(IokeObject.inspect(o.getValue()));
            sep = ", ";
        }
        sb.append("}");
        return sb.toString();
    }

    public String notice(Object obj) throws ControlFlow {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String sep = "";
        for (Map.Entry<Object, Object> o : this.dict.entrySet()) {
            sb.append(sep);
            Object key = o.getKey();
            if (IokeObject.data(key) instanceof Symbol && Symbol.onlyGoodChars(key)) {
                sb.append(Symbol.getText(key)).append(": ");
            } else {
                sb.append(IokeObject.notice(key)).append(" => ");
            }
            sb.append(IokeObject.notice(o.getValue()));
            sep = ", ";
        }
        sb.append("}");
        return sb.toString();
    }
}

