/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.IokeObject;
import ioke.lang.LexicalContext;
import ioke.lang.Message;
import ioke.lang.NativeMethod;
import ioke.lang.RunnableWithReturnAndControlFlow;
import ioke.lang.Runtime;
import ioke.lang.exceptions.ControlFlow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class FlowControlBehavior {
    public static void init(IokeObject obj) throws ControlFlow {
        Runtime runtime = obj.runtime;
        obj.setKind("DefaultBehavior FlowControl");
        obj.registerMethod(runtime.newNativeMethod("takes zero or more place and value pairs and one code argument, establishes a new lexical scope and binds the places to the values given. if the place is a simple name, it will just be created as a new binding in the lexical scope. if it is a place specification, that place will be temporarily changed - but guaranteed to be changed back after the lexical scope is finished. the let-form returns the final result of the code argument.", new NativeMethod("let"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRestUnevaluated("placesAndValues").withRequiredPositionalUnevaluated("code").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object activate(IokeObject method, final IokeObject context, IokeObject message, Object on) throws ControlFlow {
                Object object;
                this.getArguments().checkArgumentCount(context, message, on);
                List<Object> args = message.getArguments();
                LexicalContext lc = new LexicalContext(context.runtime, context.getRealContext(), "Let lexical activation context", message, context);
                int ix = 0;
                int end = args.size() - 1;
                LinkedList<Object[]> valuesToUnbind = new LinkedList<Object[]>();
                try {
                    while (ix < end) {
                        IokeObject place;
                        if (Message.next(place = IokeObject.as(args.get(ix++), context)) == null && place.getArguments().size() == 0) {
                            Object value = ((Message)IokeObject.data(message)).getEvaluatedArgument(message, ix++, context);
                            lc.setCell(Message.name(place), value);
                            continue;
                        }
                        IokeObject realPlace = place = Message.deepCopy(place);
                        while (Message.next(realPlace) != null) {
                            if (Message.next(Message.next(realPlace)) == null) {
                                IokeObject temp = Message.next(realPlace);
                                Message.setNext(realPlace, null);
                                realPlace = temp;
                                continue;
                            }
                            realPlace = Message.next(realPlace);
                        }
                        Object wherePlace = context.getRealContext();
                        if (place != realPlace) {
                            wherePlace = Message.getEvaluatedArgument(place, context);
                        }
                        final IokeObject _realPlace = realPlace;
                        final Object _wherePlace = wherePlace;
                        Object originalValue = runtime.withReturningRescue(context, null, new RunnableWithReturnAndControlFlow(){

                            public Object run() throws ControlFlow {
                                return ((Message)IokeObject.data(_realPlace)).sendTo(_realPlace, context, _wherePlace);
                            }
                        });
                        if (realPlace.getArguments().size() != 0) {
                            String newName = realPlace.getName() + "=";
                            ArrayList<Object> arguments = new ArrayList<Object>(realPlace.getArguments());
                            arguments.add(args.get(ix++));
                            IokeObject msg = context.runtime.newMessageFrom(realPlace, newName, arguments);
                            ((Message)IokeObject.data(msg)).sendTo(msg, context, wherePlace);
                            valuesToUnbind.add(0, new Object[]{wherePlace, originalValue, realPlace});
                            continue;
                        }
                        Object value = ((Message)IokeObject.data(message)).getEvaluatedArgument(message, ix++, context);
                        IokeObject.assign(wherePlace, realPlace.getName(), value, context, message);
                        valuesToUnbind.add(0, new Object[]{wherePlace, originalValue, realPlace});
                    }
                    object = ((Message)IokeObject.data(message)).getEvaluatedArgument(message, end, lc);
                    Object var20_19 = null;
                }
                catch (Throwable throwable) {
                    Object var20_20 = null;
                    while (!valuesToUnbind.isEmpty()) {
                        try {
                            Object[] vals = (Object[])valuesToUnbind.remove(0);
                            IokeObject wherePlace = IokeObject.as(vals[0], context);
                            Object value = vals[1];
                            IokeObject realPlace = IokeObject.as(vals[2], context);
                            if (realPlace.getArguments().size() != 0) {
                                IokeObject msg;
                                String newName = realPlace.getName() + "=";
                                ArrayList<Object> arguments = new ArrayList<Object>(realPlace.getArguments());
                                if (value == null) {
                                    if (newName.equals("cell=")) {
                                        ((Message)IokeObject.data(context.runtime.removeCellMessage)).sendTo(context.runtime.removeCellMessage, context, (Object)wherePlace, new ArrayList<Object>(realPlace.getArguments()));
                                        continue;
                                    }
                                    arguments.add(context.runtime.createMessage(Message.wrap(context.runtime.nil)));
                                    msg = context.runtime.newMessageFrom(realPlace, newName, arguments);
                                    ((Message)IokeObject.data(msg)).sendTo(msg, context, wherePlace);
                                    continue;
                                }
                                arguments.add(context.runtime.createMessage(Message.wrap(IokeObject.as(value, context))));
                                msg = context.runtime.newMessageFrom(realPlace, newName, arguments);
                                ((Message)IokeObject.data(msg)).sendTo(msg, context, wherePlace);
                                continue;
                            }
                            if (value == null) {
                                IokeObject.removeCell(wherePlace, context, message, realPlace.getName());
                                continue;
                            }
                            IokeObject.assign(wherePlace, realPlace.getName(), value, context, message);
                        }
                        catch (Throwable e) {}
                    }
                    throw throwable;
                }
                while (!valuesToUnbind.isEmpty()) {
                    try {
                        Object[] vals = (Object[])valuesToUnbind.remove(0);
                        IokeObject wherePlace = IokeObject.as(vals[0], context);
                        Object value = vals[1];
                        IokeObject realPlace = IokeObject.as(vals[2], context);
                        if (realPlace.getArguments().size() != 0) {
                            IokeObject msg;
                            String newName = realPlace.getName() + "=";
                            ArrayList<Object> arguments = new ArrayList<Object>(realPlace.getArguments());
                            if (value == null) {
                                if (newName.equals("cell=")) {
                                    ((Message)IokeObject.data(context.runtime.removeCellMessage)).sendTo(context.runtime.removeCellMessage, context, (Object)wherePlace, new ArrayList<Object>(realPlace.getArguments()));
                                    continue;
                                }
                                arguments.add(context.runtime.createMessage(Message.wrap(context.runtime.nil)));
                                msg = context.runtime.newMessageFrom(realPlace, newName, arguments);
                                ((Message)IokeObject.data(msg)).sendTo(msg, context, wherePlace);
                                continue;
                            }
                            arguments.add(context.runtime.createMessage(Message.wrap(IokeObject.as(value, context))));
                            msg = context.runtime.newMessageFrom(realPlace, newName, arguments);
                            ((Message)IokeObject.data(msg)).sendTo(msg, context, wherePlace);
                            continue;
                        }
                        if (value == null) {
                            IokeObject.removeCell(wherePlace, context, message, realPlace.getName());
                            continue;
                        }
                        IokeObject.assign(wherePlace, realPlace.getName(), value, context, message);
                    }
                    catch (Throwable e) {}
                }
                return object;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("breaks out of the enclosing context. if an argument is supplied, this will be returned as the result of the object breaking out of", new NativeMethod("break"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withOptionalPositional("value", "nil").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                ArrayList<Object> args = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                Object value = runtime.nil;
                if (message.getArgumentCount() > 0) {
                    value = ((Message)IokeObject.data(message)).getEvaluatedArgument(message, 0, context);
                }
                throw new ControlFlow.Break(value);
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns from the enclosing method/macro. if an argument is supplied, this will be returned as the result of the method/macro breaking out of.", new NativeMethod("return"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withOptionalPositional("value", "nil").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                IokeObject value = runtime.nil;
                ArrayList<Object> args = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                if (args.size() > 0) {
                    value = args.get(0);
                }
                IokeObject ctx = context;
                while (ctx instanceof LexicalContext) {
                    ctx = ((LexicalContext)ctx).surroundingContext;
                }
                throw new ControlFlow.Return((Object)value, ctx);
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("breaks out of the enclosing context and continues from that point again.", new NativeMethod.WithNoArguments("continue"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                throw new ControlFlow.Continue();
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("until the first argument evaluates to something true, loops and evaluates the next argument", new NativeMethod("until"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withOptionalPositionalUnevaluated("condition").withRestUnevaluated("body").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                if (message.getArgumentCount() == 0) {
                    return runtime.nil;
                }
                boolean body = message.getArgumentCount() > 1;
                Object ret = runtime.nil;
                boolean doAgain = false;
                do {
                    doAgain = false;
                    try {
                        while (!IokeObject.isTrue(((Message)IokeObject.data(message)).getEvaluatedArgument(message, 0, context))) {
                            if (!body) continue;
                            ret = ((Message)IokeObject.data(message)).getEvaluatedArgument(message, 1, context);
                        }
                    }
                    catch (ControlFlow.Break e) {
                        ret = e.getValue();
                    }
                    catch (ControlFlow.Continue e) {
                        doAgain = true;
                    }
                } while (doAgain);
                return ret;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("while the first argument evaluates to something true, loops and evaluates the next argument", new NativeMethod("while"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withOptionalPositionalUnevaluated("condition").withRestUnevaluated("body").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                if (message.getArgumentCount() == 0) {
                    return runtime.nil;
                }
                boolean body = message.getArgumentCount() > 1;
                Object ret = runtime.nil;
                boolean doAgain = false;
                do {
                    doAgain = false;
                    try {
                        while (IokeObject.isTrue(((Message)IokeObject.data(message)).getEvaluatedArgument(message, 0, context))) {
                            if (!body) continue;
                            ret = ((Message)IokeObject.data(message)).getEvaluatedArgument(message, 1, context);
                        }
                    }
                    catch (ControlFlow.Break e) {
                        ret = e.getValue();
                    }
                    catch (ControlFlow.Continue e) {
                        doAgain = true;
                    }
                } while (doAgain);
                return ret;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("loops forever - executing it's argument over and over until interrupted in some way.", new NativeMethod("loop"){
            private final DefaultArgumentsDefinition ARGUMENTS = DefaultArgumentsDefinition.builder().withRestUnevaluated("body").getArguments();

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                if (message.getArgumentCount() > 0) {
                    while (true) {
                        try {
                            while (true) {
                                ((Message)IokeObject.data(message)).getEvaluatedArgument(message, 0, context);
                            }
                        }
                        catch (ControlFlow.Break e) {
                            return e.getValue();
                        }
                        catch (ControlFlow.Continue e) {
                            continue;
                        }
                        break;
                    }
                }
                while (true) {
                    // Infinite loop
                }
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("evaluates the first arguments, and then evaluates the second argument if the result was true, otherwise the last argument. returns the result of the call, or the result if it's not true.", new NativeMethod("if"){
            private final DefaultArgumentsDefinition ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositional("condition").withOptionalPositionalUnevaluated("then").withOptionalPositionalUnevaluated("else").getArguments();

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                Object test = ((Message)IokeObject.data(message)).getEvaluatedArgument(message, 0, context);
                LexicalContext itContext = new LexicalContext(context.runtime, context.getRealContext(), "Lexical activation context", message, context);
                itContext.setCell("it", test);
                if (IokeObject.isTrue(test)) {
                    if (message.getArgumentCount() > 1) {
                        return ((Message)IokeObject.data(message)).getEvaluatedArgument(message, 1, itContext);
                    }
                    return test;
                }
                if (message.getArgumentCount() > 2) {
                    return ((Message)IokeObject.data(message)).getEvaluatedArgument(message, 2, itContext);
                }
                return test;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("evaluates the first arguments, and then evaluates the second argument if the result was false, otherwise the last argument. returns the result of the call, or the result if it's true.", new NativeMethod("unless"){
            private final DefaultArgumentsDefinition ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositional("condition").withOptionalPositionalUnevaluated("then").withOptionalPositionalUnevaluated("else").getArguments();

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                Object test = ((Message)IokeObject.data(message)).getEvaluatedArgument(message, 0, context);
                LexicalContext itContext = new LexicalContext(context.runtime, context.getRealContext(), "Lexical activation context", message, context);
                itContext.setCell("it", test);
                if (IokeObject.isTrue(test)) {
                    if (message.getArgumentCount() > 2) {
                        return ((Message)IokeObject.data(message)).getEvaluatedArgument(message, 2, itContext);
                    }
                    return test;
                }
                if (message.getArgumentCount() > 1) {
                    return ((Message)IokeObject.data(message)).getEvaluatedArgument(message, 1, itContext);
                }
                return test;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("will execute and return the value of the first argument. after the code has run, all the remaining blocks of code are guaranteed to run in order even if a non-local flow control happens inside the main code. if any code in the ensure blocks generate a new non-local flow control, the rest of the ensure blocks in that specific ensure invocation are not guaranteed to run.", new NativeMethod("ensure"){
            private final DefaultArgumentsDefinition ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositionalUnevaluated("code").withRestUnevaluated("ensureBlocks").getArguments();

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                Runtime runtime = context.runtime;
                List<Object> args = message.getArguments();
                int argCount = args.size();
                Object result = runtime.nil;
                try {
                    IokeObject msg = IokeObject.as(args.get(0), context);
                    result = ((Message)IokeObject.data(msg)).evaluateCompleteWithoutExplicitReceiver(msg, context, context.getRealContext());
                    Object var11_10 = null;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    for (Object o : args.subList(1, argCount)) {
                        IokeObject msg = IokeObject.as(o, context);
                        ((Message)IokeObject.data(msg)).evaluateCompleteWithoutExplicitReceiver(msg, context, context.getRealContext());
                    }
                    throw throwable;
                }
                for (Object o : args.subList(1, argCount)) {
                    IokeObject msg = IokeObject.as(o, context);
                    ((Message)IokeObject.data(msg)).evaluateCompleteWithoutExplicitReceiver(msg, context, context.getRealContext());
                }
                return result;
            }
        }));
    }
}

