/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.IokeData;
import ioke.lang.IokeObject;
import ioke.lang.Message;
import ioke.lang.NativeMethod;
import ioke.lang.Runtime;
import ioke.lang.TypeCheckingNativeMethod;
import ioke.lang.exceptions.ControlFlow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hook
extends IokeData {
    private List<IokeObject> connected;

    public Hook(List<IokeObject> connected) {
        this.connected = connected;
    }

    private void rewire(IokeObject self) {
        for (IokeObject io : this.connected) {
            if (io.hooks == null) {
                io.hooks = new LinkedList<IokeObject>();
            }
            if (io.hooks.contains(self)) continue;
            io.hooks.add(self);
        }
    }

    public static void fireCellAdded(IokeObject on, IokeObject message, IokeObject context, String name) throws ControlFlow {
        Collection<IokeObject> hooks = on.hooks;
        if (hooks != null) {
            IokeObject sym = context.runtime.getSymbol(name);
            IokeObject cellAddedMessage = context.runtime.cellAddedMessage;
            for (IokeObject h : hooks) {
                ((Message)IokeObject.data(cellAddedMessage)).sendTo(cellAddedMessage, context, h, on, sym);
            }
        }
    }

    public static void fireCellChanged(IokeObject on, IokeObject message, IokeObject context, String name, Object prevValue) throws ControlFlow {
        Collection<IokeObject> hooks = on.hooks;
        if (hooks != null) {
            IokeObject sym = context.runtime.getSymbol(name);
            IokeObject cellChangedMessage = context.runtime.cellChangedMessage;
            for (IokeObject h : hooks) {
                ((Message)IokeObject.data(cellChangedMessage)).sendTo(cellChangedMessage, context, h, on, sym, prevValue);
            }
        }
    }

    public static void fireCellRemoved(IokeObject on, IokeObject message, IokeObject context, String name, Object prevValue) throws ControlFlow {
        Collection<IokeObject> hooks = on.hooks;
        if (hooks != null) {
            IokeObject sym = context.runtime.getSymbol(name);
            IokeObject cellRemovedMessage = context.runtime.cellRemovedMessage;
            for (IokeObject h : hooks) {
                ((Message)IokeObject.data(cellRemovedMessage)).sendTo(cellRemovedMessage, context, h, on, sym, prevValue);
            }
        }
    }

    public static void fireCellUndefined(IokeObject on, IokeObject message, IokeObject context, String name, Object prevValue) throws ControlFlow {
        Collection<IokeObject> hooks = on.hooks;
        if (hooks != null) {
            IokeObject sym = context.runtime.getSymbol(name);
            IokeObject cellUndefinedMessage = context.runtime.cellUndefinedMessage;
            for (IokeObject h : hooks) {
                ((Message)IokeObject.data(cellUndefinedMessage)).sendTo(cellUndefinedMessage, context, h, on, sym, prevValue);
            }
        }
    }

    public static void fireMimicAdded(IokeObject on, IokeObject message, IokeObject context, IokeObject newMimic) throws ControlFlow {
        Collection<IokeObject> hooks = on.hooks;
        if (hooks != null) {
            IokeObject mimicAddedMessage = context.runtime.mimicAddedMessage;
            for (IokeObject h : hooks) {
                ((Message)IokeObject.data(mimicAddedMessage)).sendTo(mimicAddedMessage, context, h, on, newMimic);
            }
        }
    }

    public static void fireMimicRemoved(IokeObject on, IokeObject message, IokeObject context, Object removedMimic) throws ControlFlow {
        Collection<IokeObject> hooks = on.hooks;
        if (hooks != null) {
            IokeObject mimicRemovedMessage = context.runtime.mimicRemovedMessage;
            for (IokeObject h : hooks) {
                ((Message)IokeObject.data(mimicRemovedMessage)).sendTo(mimicRemovedMessage, context, h, on, removedMimic);
            }
        }
    }

    public static void fireMimicsChanged(IokeObject on, IokeObject message, IokeObject context, Object changedMimic) throws ControlFlow {
        Collection<IokeObject> hooks = on.hooks;
        if (hooks != null) {
            IokeObject mimicsChangedMessage = context.runtime.mimicsChangedMessage;
            for (IokeObject h : hooks) {
                ((Message)IokeObject.data(mimicsChangedMessage)).sendTo(mimicsChangedMessage, context, h, on, changedMimic);
            }
        }
    }

    public static void fireMimicked(IokeObject on, IokeObject message, IokeObject context, IokeObject mimickingObject) throws ControlFlow {
        Collection<IokeObject> hooks = on.hooks;
        if (hooks != null) {
            IokeObject mimickedMessage = context.runtime.mimickedMessage;
            for (IokeObject h : hooks) {
                ((Message)IokeObject.data(mimickedMessage)).sendTo(mimickedMessage, context, h, on, mimickingObject);
            }
        }
    }

    public static void init(Runtime runtime) throws ControlFlow {
        IokeObject obj = new IokeObject(runtime, "A hook allow you to observe what happens to a specific object. All hooks have Hook in their mimic chain.", new Hook(new ArrayList<IokeObject>()));
        obj.setKind("Hook");
        obj.mimicsWithoutCheck(runtime.origin);
        runtime.iokeGround.registerCell("Hook", obj);
        obj.registerMethod(runtime.newNativeMethod("Takes one or more arguments to hook into and returns a new Hook connected to them.", new NativeMethod("into"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositional("firstConnected").withRest("restConnected").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                ArrayList<Object> args = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                IokeObject hook = obj.allocateCopy(context, message);
                hook.mimicsWithoutCheck(obj);
                ArrayList<IokeObject> objs = new ArrayList<IokeObject>(args.size());
                for (Object e : args) {
                    objs.add(IokeObject.as(e, context));
                }
                Hook h = new Hook(objs);
                hook.setData(h);
                h.rewire(hook);
                return hook;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns the objects this hook is connected to", new TypeCheckingNativeMethod.WithNoArguments("connectedObjects", obj){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                Hook h = (Hook)IokeObject.data(on);
                ArrayList<Object> l = new ArrayList<Object>(h.connected);
                return method.runtime.newList(l);
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("Takes one argument and will add that to the list of connected objects", new NativeMethod("hook!"){
            private final DefaultArgumentsDefinition ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositional("objectToHookInto").getArguments();

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                ArrayList<Object> args = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                Hook h = (Hook)IokeObject.data(on);
                h.connected.add(IokeObject.as(args.get(0), context));
                h.rewire(IokeObject.as(on, context));
                return on;
            }
        }));
    }

    @Override
    public IokeData cloneData(IokeObject obj, IokeObject m, IokeObject context) {
        return new Hook(new ArrayList<IokeObject>(this.connected));
    }
}

