/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.IokeObject;
import ioke.lang.Message;
import ioke.lang.NativeMethod;
import ioke.lang.Regexp;
import ioke.lang.Runtime;
import ioke.lang.Text;
import ioke.lang.exceptions.ControlFlow;
import ioke.lang.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class InternalBehavior {
    public static void init(IokeObject obj) throws ControlFlow {
        Runtime runtime = obj.runtime;
        obj.setKind("DefaultBehavior Internal");
        obj.registerMethod(runtime.newNativeMethod("takes zero or more arguments, calls asText on non-text arguments, and then concatenates them and returns the result.", new NativeMethod("internal:concatenateText"){
            private final DefaultArgumentsDefinition ARGUMENTS = DefaultArgumentsDefinition.builder().withRest("textSegments").getArguments();

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                ArrayList<Object> args = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                StringBuilder sb = new StringBuilder();
                for (Object e : args) {
                    if (e instanceof IokeObject) {
                        if (IokeObject.data(e) instanceof Text) {
                            sb.append(Text.getText(e));
                            continue;
                        }
                        sb.append(Text.getText(((Message)IokeObject.data(context.runtime.asText)).sendTo(context.runtime.asText, context, e)));
                        continue;
                    }
                    sb.append(e);
                }
                return context.runtime.newText(sb.toString());
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("takes one or more arguments. it expects the last argument to be a text of flags, while the rest of the arguments are either texts or regexps or nil. if text, it will be inserted verbatim into the result regexp. if regexp it will be inserted into a group that make sure the flags of the regexp is preserved. if nil, nothing will be inserted.", new NativeMethod("internal:compositeRegexp"){
            private final DefaultArgumentsDefinition ARGUMENTS = DefaultArgumentsDefinition.builder().withRest("regexpSegments").getArguments();

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            private void addRegexp(Object o, StringBuilder sb) throws ControlFlow {
                String f = Regexp.getFlags(o);
                String nflags = "";
                if (f.indexOf("i") == -1) {
                    nflags = nflags + "i";
                }
                if (f.indexOf("x") == -1) {
                    nflags = nflags + "x";
                }
                if (f.indexOf("m") == -1) {
                    nflags = nflags + "m";
                }
                if (f.indexOf("u") == -1) {
                    nflags = nflags + "u";
                }
                if (f.indexOf("s") == -1) {
                    nflags = nflags + "s";
                }
                if (nflags.length() > 0) {
                    nflags = "-" + nflags;
                }
                sb.append("(?").append(f).append(nflags).append(":").append(Regexp.getPattern(o)).append(")");
            }

            private void addText(Object o, StringBuilder sb) throws ControlFlow {
                sb.append(Text.getText(o));
            }

            public void addObject(Object o, StringBuilder sb, IokeObject context) throws ControlFlow {
                if (o != null) {
                    if (o instanceof String) {
                        sb.append(o);
                    } else if (IokeObject.data(o) instanceof Text) {
                        this.addText(o, sb);
                    } else if (IokeObject.data(o) instanceof Regexp) {
                        this.addRegexp(o, sb);
                    } else {
                        this.addText(((Message)IokeObject.data(context.runtime.asText)).sendTo(context.runtime.asText, context, o), sb);
                    }
                }
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                ArrayList<Object> args = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                StringBuilder sb = new StringBuilder();
                if (IokeObject.data(on) instanceof Text || IokeObject.data(on) instanceof Regexp) {
                    this.addObject(on, sb, context);
                }
                int size = args.size();
                for (Object o : args.subList(0, size - 1)) {
                    this.addObject(o, sb, context);
                }
                Object f = args.get(size - 1);
                String flags = null;
                if (f instanceof String) {
                    flags = (String)f;
                } else if (IokeObject.data(f) instanceof Text) {
                    flags = Text.getText(f);
                } else if (IokeObject.data(f) instanceof Regexp) {
                    sb.append(Regexp.getPattern(f));
                    flags = Regexp.getFlags(f);
                }
                return context.runtime.newRegexp(sb.toString(), flags, context, message);
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("expects one 'strange' argument. creates a new instance of Text with the given Java String backing it.", new NativeMethod("internal:createText"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositionalUnevaluated("text").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                Object o = Message.getArg1(message);
                boolean cache = true;
                if (o instanceof IokeObject) {
                    cache = false;
                    o = Message.getEvaluatedArgument(o, context);
                }
                if (o instanceof String) {
                    String s = (String)o;
                    IokeObject value = runtime.newText(new StringUtils().replaceEscapes(s));
                    if (cache) {
                        Message.cacheValue(message, value);
                    }
                    return value;
                }
                return IokeObject.convertToText(o, message, context, true);
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("expects two 'strange' arguments. creates a new mimic of Regexp with the given Java String backing it.", new NativeMethod("internal:createRegexp"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositionalUnevaluated("regexp").withRequiredPositionalUnevaluated("flags").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                Object o = Message.getArg1(message);
                Object o2 = Message.getArg2(message);
                if (o instanceof IokeObject) {
                    o = Message.getEvaluatedArgument(o, context);
                }
                if (o2 instanceof IokeObject) {
                    o2 = Message.getEvaluatedArgument(o2, context);
                }
                if (o instanceof String) {
                    String s = (String)o;
                    return runtime.newRegexp(new StringUtils().replaceRegexpEscapes(s), (String)o2, context, message);
                }
                return IokeObject.convertToRegexp(o, message, context);
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("expects one 'strange' argument. creates a new instance of Number that represents the number found in the strange argument.", new NativeMethod("internal:createNumber"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositionalUnevaluated("number").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                Object o = Message.getArg1(message);
                boolean cache = true;
                if (o instanceof IokeObject) {
                    cache = false;
                    o = Message.getEvaluatedArgument(o, context);
                }
                IokeObject value = null;
                if (o instanceof String) {
                    value = runtime.newNumber((String)o);
                } else if (o instanceof Integer) {
                    value = runtime.newNumber(((Integer)o).intValue());
                }
                if (cache) {
                    Message.cacheValue(message, value);
                }
                return value;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("expects one 'strange' argument. creates a new instance of Decimal that represents the number found in the strange argument.", new NativeMethod("internal:createDecimal"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositionalUnevaluated("decimal").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                Object o = Message.getArg1(message);
                boolean cache = true;
                if (o instanceof IokeObject) {
                    cache = false;
                    o = Message.getEvaluatedArgument(o, context);
                }
                IokeObject value = runtime.newDecimal((String)o);
                if (cache) {
                    Message.cacheValue(message, value);
                }
                return value;
            }
        }));
    }
}

