/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.IokeObject;
import ioke.lang.Message;
import ioke.lang.NullObject;
import ioke.lang.Number;
import ioke.lang.Restart;
import ioke.lang.RunnableWithControlFlow;
import ioke.lang.Text;
import ioke.lang.exceptions.ControlFlow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IokeData {
    public static final IokeData None = new IokeData(){};
    public static final IokeData Nil = new IokeData(){

        public void init(IokeObject obj) {
            obj.setKind("nil");
        }

        public void checkMimic(IokeObject obj, IokeObject m, IokeObject context) throws ControlFlow {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, m, context, "Error", "CantMimicOddball"), context).mimic(m, context);
            condition.setCell("message", m);
            condition.setCell("context", context);
            condition.setCell("receiver", obj);
            context.runtime.errorCondition(condition);
        }

        public boolean isNil() {
            return true;
        }

        public boolean isTrue() {
            return false;
        }

        public String toString(IokeObject self) {
            return "nil";
        }
    };
    public static final IokeData False = new IokeData(){

        public void init(IokeObject obj) {
            obj.setKind("false");
        }

        public void checkMimic(IokeObject obj, IokeObject m, IokeObject context) throws ControlFlow {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, m, context, "Error", "CantMimicOddball"), context).mimic(m, context);
            condition.setCell("message", m);
            condition.setCell("context", context);
            condition.setCell("receiver", obj);
            context.runtime.errorCondition(condition);
        }

        public boolean isTrue() {
            return false;
        }

        public String toString(IokeObject self) {
            return "false";
        }
    };
    public static final IokeData True = new IokeData(){

        public void init(IokeObject obj) {
            obj.setKind("true");
        }

        public void checkMimic(IokeObject obj, IokeObject m, IokeObject context) throws ControlFlow {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, m, context, "Error", "CantMimicOddball"), context).mimic(m, context);
            condition.setCell("message", m);
            condition.setCell("context", context);
            condition.setCell("receiver", obj);
            context.runtime.errorCondition(condition);
        }

        public String toString(IokeObject self) {
            return "true";
        }
    };

    public void init(IokeObject obj) throws ControlFlow {
    }

    public void checkMimic(IokeObject obj, IokeObject m, IokeObject context) throws ControlFlow {
    }

    public boolean isNil() {
        return false;
    }

    public boolean isTrue() {
        return true;
    }

    public boolean isMessage() {
        return false;
    }

    public boolean isSymbol() {
        return false;
    }

    public IokeObject negate(IokeObject obj) {
        return obj;
    }

    public final boolean isEqualTo(IokeObject self, Object other) throws ControlFlow {
        Object cell = self.findCell(self.runtime.eqMessage, self.runtime.ground, "==");
        if (cell == self.runtime.nul) {
            boolean result = other instanceof IokeObject && self.getCells() == IokeObject.as(other, self).getCells();
            return result;
        }
        boolean result = IokeObject.isTrue(((Message)IokeObject.data(self.runtime.eqMessage)).sendTo(self.runtime.eqMessage, self.runtime.ground, (Object)self, self.runtime.createMessage(Message.wrap(IokeObject.as(other, self)))));
        return result;
    }

    public final int hashCode(IokeObject self) throws ControlFlow {
        Object cell = self.findCell(self.runtime.hashMessage, self.runtime.ground, "hash");
        if (cell == self.runtime.nul) {
            return System.identityHashCode(self.getCells());
        }
        return Number.extractInt(((Message)IokeObject.data(self.runtime.hashMessage)).sendTo(self.runtime.hashMessage, self.runtime.ground, self), self.runtime.hashMessage, self.runtime.ground);
    }

    public IokeData cloneData(IokeObject obj, IokeObject m, IokeObject context) {
        return this;
    }

    public Object convertTo(IokeObject self, String kind, boolean signalCondition, String conversionMethod, IokeObject message, IokeObject context) throws ControlFlow {
        if (IokeObject.isKind(self, kind, context)) {
            return self;
        }
        if (signalCondition) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, message, context, "Error", "Type", "IncorrectType"), context).mimic(message, context);
            condition.setCell("message", message);
            condition.setCell("context", context);
            condition.setCell("receiver", self);
            condition.setCell("expectedType", context.runtime.getSymbol(kind));
            Object[] newCell = new Object[]{self};
            context.runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

                public void run() throws ControlFlow {
                    context.runtime.errorCondition(condition);
                }
            }, context, new Restart.ArgumentGivingRestart("useValue"){

                @Override
                public List<String> getArgumentNames() {
                    return new ArrayList<String>(Arrays.asList("newValue"));
                }

                @Override
                public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                    newCell[0] = arguments.get(0);
                    return context.runtime.nil;
                }
            });
            return IokeObject.convertTo(newCell[0], (Object)kind, signalCondition, conversionMethod, message, context);
        }
        return null;
    }

    public Object convertTo(IokeObject self, Object mimic, boolean signalCondition, String conversionMethod, IokeObject message, IokeObject context) throws ControlFlow {
        if (IokeObject.isMimic(self, IokeObject.as(mimic, context), context)) {
            return self;
        }
        if (signalCondition) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, message, context, "Error", "Type", "IncorrectType"), context).mimic(message, context);
            condition.setCell("message", message);
            condition.setCell("context", context);
            condition.setCell("receiver", self);
            condition.setCell("expectedType", mimic);
            Object[] newCell = new Object[]{self};
            context.runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

                public void run() throws ControlFlow {
                    context.runtime.errorCondition(condition);
                }
            }, context, new Restart.ArgumentGivingRestart("useValue"){

                @Override
                public List<String> getArgumentNames() {
                    return new ArrayList<String>(Arrays.asList("newValue"));
                }

                @Override
                public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                    newCell[0] = arguments.get(0);
                    return context.runtime.nil;
                }
            });
            return IokeObject.convertTo(mimic, newCell[0], signalCondition, conversionMethod, message, context);
        }
        return null;
    }

    public IokeObject convertToRational(IokeObject self, IokeObject m, IokeObject context, boolean signalCondition) throws ControlFlow {
        if (signalCondition) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, m, context, "Error", "Type", "IncorrectType"), context).mimic(m, context);
            condition.setCell("message", m);
            condition.setCell("context", context);
            condition.setCell("receiver", self);
            condition.setCell("expectedType", context.runtime.getSymbol("Rational"));
            Object[] newCell = new Object[]{self};
            context.runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

                public void run() throws ControlFlow {
                    context.runtime.errorCondition(condition);
                }
            }, context, new Restart.ArgumentGivingRestart("useValue"){

                @Override
                public List<String> getArgumentNames() {
                    return new ArrayList<String>(Arrays.asList("newValue"));
                }

                @Override
                public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                    newCell[0] = arguments.get(0);
                    return context.runtime.nil;
                }
            });
            return IokeObject.convertToRational(newCell[0], m, context, signalCondition);
        }
        return null;
    }

    public IokeObject convertToDecimal(IokeObject self, IokeObject m, IokeObject context, boolean signalCondition) throws ControlFlow {
        if (signalCondition) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, m, context, "Error", "Type", "IncorrectType"), context).mimic(m, context);
            condition.setCell("message", m);
            condition.setCell("context", context);
            condition.setCell("receiver", self);
            condition.setCell("expectedType", context.runtime.getSymbol("Decimal"));
            Object[] newCell = new Object[]{self};
            context.runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

                public void run() throws ControlFlow {
                    context.runtime.errorCondition(condition);
                }
            }, context, new Restart.ArgumentGivingRestart("useValue"){

                @Override
                public List<String> getArgumentNames() {
                    return new ArrayList<String>(Arrays.asList("newValue"));
                }

                @Override
                public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                    newCell[0] = arguments.get(0);
                    return context.runtime.nil;
                }
            });
            return IokeObject.convertToDecimal(newCell[0], m, context, signalCondition);
        }
        return null;
    }

    public IokeObject convertToNumber(IokeObject self, IokeObject m, IokeObject context) throws ControlFlow {
        IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, m, context, "Error", "Type", "IncorrectType"), context).mimic(m, context);
        condition.setCell("message", m);
        condition.setCell("context", context);
        condition.setCell("receiver", self);
        condition.setCell("expectedType", context.runtime.getSymbol("Number"));
        Object[] newCell = new Object[]{self};
        context.runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

            public void run() throws ControlFlow {
                context.runtime.errorCondition(condition);
            }
        }, context, new Restart.ArgumentGivingRestart("useValue"){

            @Override
            public List<String> getArgumentNames() {
                return new ArrayList<String>(Arrays.asList("newValue"));
            }

            @Override
            public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                newCell[0] = arguments.get(0);
                return context.runtime.nil;
            }
        });
        return IokeObject.convertToNumber(newCell[0], m, context);
    }

    public IokeObject tryConvertToText(IokeObject self, IokeObject m, IokeObject context) throws ControlFlow {
        return null;
    }

    public IokeObject convertToText(IokeObject self, IokeObject m, IokeObject context, boolean signalCondition) throws ControlFlow {
        if (signalCondition) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, m, context, "Error", "Type", "IncorrectType"), context).mimic(m, context);
            condition.setCell("message", m);
            condition.setCell("context", context);
            condition.setCell("receiver", self);
            condition.setCell("expectedType", context.runtime.getSymbol("Text"));
            Object[] newCell = new Object[]{self};
            context.runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

                public void run() throws ControlFlow {
                    context.runtime.errorCondition(condition);
                }
            }, context, new Restart.ArgumentGivingRestart("useValue"){

                @Override
                public List<String> getArgumentNames() {
                    return new ArrayList<String>(Arrays.asList("newValue"));
                }

                @Override
                public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                    newCell[0] = arguments.get(0);
                    return context.runtime.nil;
                }
            });
            return IokeObject.convertToText(newCell[0], m, context, signalCondition);
        }
        return null;
    }

    public IokeObject convertToSymbol(IokeObject self, IokeObject m, IokeObject context, boolean signalCondition) throws ControlFlow {
        if (signalCondition) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, m, context, "Error", "Type", "IncorrectType"), context).mimic(m, context);
            condition.setCell("message", m);
            condition.setCell("context", context);
            condition.setCell("receiver", self);
            condition.setCell("expectedType", context.runtime.getSymbol("Symbol"));
            Object[] newCell = new Object[]{self};
            context.runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

                public void run() throws ControlFlow {
                    context.runtime.errorCondition(condition);
                }
            }, context, new Restart.ArgumentGivingRestart("useValue"){

                @Override
                public List<String> getArgumentNames() {
                    return new ArrayList<String>(Arrays.asList("newValue"));
                }

                @Override
                public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                    newCell[0] = arguments.get(0);
                    return context.runtime.nil;
                }
            });
            return IokeObject.convertToSymbol(newCell[0], m, context, signalCondition);
        }
        return null;
    }

    public IokeObject convertToRegexp(IokeObject self, IokeObject m, IokeObject context) throws ControlFlow {
        IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, m, context, "Error", "Type", "IncorrectType"), context).mimic(m, context);
        condition.setCell("message", m);
        condition.setCell("context", context);
        condition.setCell("receiver", self);
        condition.setCell("expectedType", context.runtime.getSymbol("Regexp"));
        Object[] newCell = new Object[]{self};
        context.runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

            public void run() throws ControlFlow {
                context.runtime.errorCondition(condition);
            }
        }, context, new Restart.ArgumentGivingRestart("useValue"){

            @Override
            public List<String> getArgumentNames() {
                return new ArrayList<String>(Arrays.asList("newValue"));
            }

            @Override
            public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                newCell[0] = arguments.get(0);
                return context.runtime.nil;
            }
        });
        return IokeObject.convertToRegexp(newCell[0], m, context);
    }

    private void report(Object self, IokeObject context, IokeObject message, String name) throws ControlFlow {
        IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, message, context, "Error", "Invocation", "NotActivatable"), context).mimic(message, context);
        condition.setCell("message", message);
        condition.setCell("context", context);
        condition.setCell("receiver", self);
        condition.setCell("methodName", context.runtime.getSymbol(name));
        context.runtime.errorCondition(condition);
    }

    public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
        Object cell = self.findCell(message, context, "activate");
        if (cell == context.runtime.nul) {
            this.report(self, context, message, "activate");
            return context.runtime.nil;
        }
        IokeObject newMessage = Message.deepCopy(message);
        newMessage.getArguments().clear();
        newMessage.getArguments().add(context.runtime.createMessage(Message.wrap(context)));
        newMessage.getArguments().add(context.runtime.createMessage(Message.wrap(message)));
        newMessage.getArguments().add(context.runtime.createMessage(Message.wrap(IokeObject.as(on, context))));
        return IokeObject.getOrActivate(cell, context, newMessage, self);
    }

    public Object activateWithData(IokeObject self, IokeObject context, IokeObject message, Object on, Map<String, Object> c) throws ControlFlow {
        return this.activate(self, context, message, on);
    }

    public Object activateWithCall(IokeObject self, IokeObject context, IokeObject message, Object on, Object c) throws ControlFlow {
        return this.activate(self, context, message, on);
    }

    public Object activateWithCallAndData(IokeObject self, IokeObject context, IokeObject message, Object on, Object c, Map<String, Object> data) throws ControlFlow {
        return this.activate(self, context, message, on);
    }

    public List<Object> getArguments(IokeObject self) throws ControlFlow {
        this.report(self, self, self, "getArguments");
        return null;
    }

    public int getArgumentCount(IokeObject self) throws ControlFlow {
        this.report(self, self, self, "getArgumentCount");
        return -1;
    }

    public String getName(IokeObject self) throws ControlFlow {
        this.report(self, self, self, "getName");
        return null;
    }

    public String getFile(IokeObject self) throws ControlFlow {
        this.report(self, self, self, "getFile");
        return null;
    }

    public int getLine(IokeObject self) throws ControlFlow {
        this.report(self, self, self, "getLine");
        return -1;
    }

    public int getPosition(IokeObject self) throws ControlFlow {
        this.report(self, self, self, "getPosition");
        return -1;
    }

    public String toString(IokeObject self) {
        try {
            int h = this.hashCode(self);
            String hash = Integer.toHexString(h).toUpperCase();
            if (self instanceof NullObject) {
                return "#<nul:" + hash + ">";
            }
            Object obj = self.findCell(null, null, "kind");
            String kind = ((Text)IokeObject.data(obj)).getText();
            return "#<" + kind + ":" + hash + ">";
        }
        catch (ControlFlow controlFlow) {
            return "an error happened somewhere";
        }
    }

    public String getConvertMethod() {
        return null;
    }
}

