/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.IokeData;
import ioke.lang.IokeObject;
import ioke.lang.Message;
import ioke.lang.RunnableWithControlFlow;
import ioke.lang.Runtime;
import ioke.lang.TypeCheckingArgumentsDefinition;
import ioke.lang.TypeCheckingNativeMethod;
import ioke.lang.exceptions.ControlFlow;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class IokeIO
extends IokeData {
    protected Writer writer;
    protected BufferedReader reader;

    public IokeIO() {
        this(null, null);
    }

    public IokeIO(Writer writer) {
        this(null, writer);
    }

    public IokeIO(Reader reader) {
        this(reader, null);
    }

    public IokeIO(Reader reader, Writer writer) {
        if (null != reader) {
            this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        }
        this.writer = writer;
    }

    public static Writer getWriter(Object arg) {
        return ((IokeIO)IokeObject.data((Object)arg)).writer;
    }

    public static BufferedReader getReader(Object arg) {
        return ((IokeIO)IokeObject.data((Object)arg)).reader;
    }

    public void init(IokeObject obj) throws ControlFlow {
        Runtime runtime = obj.runtime;
        obj.setKind("IO");
        obj.registerMethod(runtime.newNativeMethod("Prints a text representation of the argument and a newline to the current IO object", new TypeCheckingNativeMethod("println"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.io).withOptionalPositional("object", "nil").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                try {
                    if (args.size() > 0) {
                        Object arg = args.get(0);
                        IokeIO.getWriter(on).write(((Message)IokeObject.data(context.runtime.asText)).sendTo(context.runtime.asText, context, arg).toString());
                    }
                    IokeIO.getWriter(on).write("\n");
                    IokeIO.getWriter(on).flush();
                }
                catch (IOException e) {
                    final Runtime runtime2 = context.runtime;
                    final IokeObject condition = IokeObject.as(IokeObject.getCellChain(runtime2.condition, message, context, "Error", "IO"), context).mimic(message, context);
                    condition.setCell("message", message);
                    condition.setCell("context", context);
                    condition.setCell("receiver", on);
                    condition.setCell("exceptionMessage", runtime2.newText(e.getMessage()));
                    ArrayList<Object> ob = new ArrayList<Object>();
                    for (StackTraceElement ste : e.getStackTrace()) {
                        ob.add(runtime2.newText(ste.toString()));
                    }
                    condition.setCell("exceptionStackTrace", runtime2.newList(ob));
                    runtime2.withReturningRestart("ignore", context, new RunnableWithControlFlow(){

                        public void run() throws ControlFlow {
                            runtime2.errorCondition(condition);
                        }
                    });
                }
                return context.runtime.getNil();
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("Prints a text representation of the argument to the current IO object", new TypeCheckingNativeMethod("print"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.io).withRequiredPositional("object").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                Object arg = args.get(0);
                try {
                    IokeIO.getWriter(on).write(((Message)IokeObject.data(context.runtime.asText)).sendTo(context.runtime.asText, context, arg).toString());
                    IokeIO.getWriter(on).flush();
                }
                catch (IOException e) {
                    final Runtime runtime2 = context.runtime;
                    final IokeObject condition = IokeObject.as(IokeObject.getCellChain(runtime2.condition, message, context, "Error", "IO"), context).mimic(message, context);
                    condition.setCell("message", message);
                    condition.setCell("context", context);
                    condition.setCell("receiver", on);
                    condition.setCell("exceptionMessage", runtime2.newText(e.getMessage()));
                    ArrayList<Object> ob = new ArrayList<Object>();
                    for (StackTraceElement ste : e.getStackTrace()) {
                        ob.add(runtime2.newText(ste.toString()));
                    }
                    condition.setCell("exceptionStackTrace", runtime2.newList(ob));
                    runtime2.withReturningRestart("ignore", context, new RunnableWithControlFlow(){

                        public void run() throws ControlFlow {
                            runtime2.errorCondition(condition);
                        }
                    });
                }
                return context.runtime.getNil();
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("tries to read as much as possible and return a message chain representing what's been read", new TypeCheckingNativeMethod.WithNoArguments("read", runtime.io){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                try {
                    String line = IokeIO.getReader(on).readLine();
                    return Message.newFromStream(context.runtime, new StringReader(line), message, context);
                }
                catch (IOException e) {
                    final Runtime runtime = context.runtime;
                    final IokeObject condition = IokeObject.as(IokeObject.getCellChain(runtime.condition, message, context, "Error", "IO"), context).mimic(message, context);
                    condition.setCell("message", message);
                    condition.setCell("context", context);
                    condition.setCell("receiver", on);
                    condition.setCell("exceptionMessage", runtime.newText(e.getMessage()));
                    ArrayList<Object> ob = new ArrayList<Object>();
                    for (StackTraceElement ste : e.getStackTrace()) {
                        ob.add(runtime.newText(ste.toString()));
                    }
                    condition.setCell("exceptionStackTrace", runtime.newList(ob));
                    runtime.withReturningRestart("ignore", context, new RunnableWithControlFlow(){

                        public void run() throws ControlFlow {
                            runtime.errorCondition(condition);
                        }
                    });
                    return context.runtime.getNil();
                }
            }
        }));
    }

    public IokeData cloneData(IokeObject obj, IokeObject m, IokeObject context) {
        return new IokeIO(this.reader, this.writer);
    }
}

