/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.IokeData;
import ioke.lang.IokeObject;
import ioke.lang.LexicalContext;
import ioke.lang.Message;
import ioke.lang.NativeMethod;
import ioke.lang.Number;
import ioke.lang.Range;
import ioke.lang.Restart;
import ioke.lang.RunnableWithControlFlow;
import ioke.lang.Runtime;
import ioke.lang.Sequence;
import ioke.lang.SpaceshipComparator;
import ioke.lang.Text;
import ioke.lang.TypeCheckingArgumentsDefinition;
import ioke.lang.TypeCheckingNativeMethod;
import ioke.lang.exceptions.ControlFlow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IokeList
extends IokeData {
    private List<Object> list;

    public IokeList() {
        this(new ArrayList<Object>());
    }

    public IokeList(List<Object> l) {
        this.list = l;
    }

    public static void add(Object list, Object obj) {
        ((IokeList)IokeObject.data((Object)list)).list.add(obj);
    }

    public static void add(Object list, int index, Object obj) {
        ((IokeList)IokeObject.data((Object)list)).list.add(index, obj);
    }

    @Override
    public void init(IokeObject obj) throws ControlFlow {
        Runtime runtime = obj.runtime;
        obj.setKind("List");
        obj.mimics(IokeObject.as(runtime.mixins.getCell(null, null, "Sequenced"), null), runtime.nul, runtime.nul);
        obj.registerMethod(runtime.newNativeMethod("returns a hash for the list", new NativeMethod.WithNoArguments("hash"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return context.runtime.newNumber(((Object)((IokeList)IokeObject.data(on)).list).hashCode());
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns true if the left hand side list is equal to the right hand side list.", new TypeCheckingNativeMethod("=="){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.list).withRequiredPositional("other").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                Object other = args.get(0);
                return other instanceof IokeObject && IokeObject.data(other) instanceof IokeList && ((Object)((IokeList)IokeObject.data(on)).list).equals(((IokeList)IokeObject.data(other)).list) ? context.runtime._true : context.runtime._false;
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("Returns a text inspection of the object", new TypeCheckingNativeMethod.WithNoArguments("inspect", runtime.list){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return method.runtime.newText(IokeList.getInspect(on));
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("Returns a brief text inspection of the object", new TypeCheckingNativeMethod.WithNoArguments("notice", runtime.list){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return method.runtime.newText(IokeList.getNotice(on));
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("returns a new sequence to iterate over this list", new TypeCheckingNativeMethod.WithNoArguments("seq", runtime.list){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                IokeObject obj = method.runtime.iteratorSequence.allocateCopy(null, null);
                obj.mimicsWithoutCheck(method.runtime.iteratorSequence);
                obj.setData(new Sequence.IteratorSequence(IokeList.getList(on).iterator()));
                return obj;
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("Compares this object against the argument. The comparison is only based on the elements inside the lists, which are in turn compared using <=>.", new TypeCheckingNativeMethod("<=>"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.list).withRequiredPositional("other").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                List<Object> one = IokeList.getList(on);
                Object arg = args.get(0);
                if (!(IokeObject.data(arg) instanceof IokeList)) {
                    return context.runtime.nil;
                }
                List<Object> two = IokeList.getList(arg);
                int len = Math.min(one.size(), two.size());
                SpaceshipComparator sc = new SpaceshipComparator(context, message);
                for (int i = 0; i < len; ++i) {
                    int v = sc.compare(one.get(i), two.get(i));
                    if (v == 0) continue;
                    return context.runtime.newNumber(v);
                }
                len = one.size() - two.size();
                if (len == 0) {
                    return context.runtime.newNumber(0L);
                }
                if (len > 0) {
                    return context.runtime.newNumber(1L);
                }
                return context.runtime.newNumber(-1L);
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("takes either one or two or three arguments. if one argument is given, it should be a message chain that will be sent to each object in the list. the result will be thrown away. if two arguments are given, the first is an unevaluated name that will be set to each of the values in the list in succession, and then the second argument will be evaluated in a scope with that argument in it. if three arguments is given, the first one is an unevaluated name that will be set to the index of each element, and the other two arguments are the name of the argument for the value, and the actual code. the code will evaluate in a lexical context, and if the argument name is available outside the context, it will be shadowed. the method will return the list.", new NativeMethod("each"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withOptionalPositionalUnevaluated("indexOrArgOrCode").withOptionalPositionalUnevaluated("argOrCode").withOptionalPositionalUnevaluated("code").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                Runtime runtime = context.runtime;
                Object onAsList = context.runtime.list.convertToThis(on, message, context);
                List ls = ((IokeList)IokeObject.data(onAsList)).list;
                switch (message.getArgumentCount()) {
                    case 0: {
                        return ((Message)IokeObject.data(runtime.seqMessage)).sendTo(runtime.seqMessage, context, on);
                    }
                    case 1: {
                        IokeObject code = IokeObject.as(message.getArguments().get(0), context);
                        for (Object o : ls) {
                            ((Message)IokeObject.data(code)).evaluateCompleteWithReceiver(code, context, context.getRealContext(), o);
                        }
                        break;
                    }
                    case 2: {
                        LexicalContext c = new LexicalContext(context.runtime, context, "Lexical activation context for List#each", message, context);
                        String name = IokeObject.as(message.getArguments().get(0), context).getName();
                        IokeObject code = IokeObject.as(message.getArguments().get(1), context);
                        for (Object o : ls) {
                            c.setCell(name, o);
                            ((Message)IokeObject.data(code)).evaluateCompleteWithoutExplicitReceiver(code, c, c.getRealContext());
                        }
                        break;
                    }
                    case 3: {
                        LexicalContext c = new LexicalContext(context.runtime, context, "Lexical activation context for List#each", message, context);
                        String iname = IokeObject.as(message.getArguments().get(0), context).getName();
                        String name = IokeObject.as(message.getArguments().get(1), context).getName();
                        IokeObject code = IokeObject.as(message.getArguments().get(2), context);
                        int index = 0;
                        for (Object o : ls) {
                            c.setCell(name, o);
                            c.setCell(iname, runtime.newNumber(index++));
                            ((Message)IokeObject.data(code)).evaluateCompleteWithoutExplicitReceiver(code, c, c.getRealContext());
                        }
                        break;
                    }
                }
                return onAsList;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("takes one argument and adds it at the end of the list, and then returns the list", new TypeCheckingNativeMethod("<<"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.list).withRequiredPositional("value").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                IokeList.add(on, args.get(0));
                return on;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("takes one argument and adds it at the end of the list, and then returns the list", new TypeCheckingNativeMethod("append!"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.list).withRequiredPositional("value").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                Object value = args.get(0);
                IokeList.add(on, value);
                return on;
            }
        }));
        obj.aliasMethod("append!", "push!", null, null);
        obj.registerMethod(runtime.newNativeMethod("takes one argument and adds it at the beginning of the list, and then returns the list", new TypeCheckingNativeMethod("prepend!"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.list).withRequiredPositional("value").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                Object value = args.get(0);
                IokeList.add(on, 0, value);
                return on;
            }
        }));
        obj.aliasMethod("prepend!", "unshift!", null, null);
        obj.registerMethod(runtime.newNativeMethod("removes the last element from the list and returns it. returns nil if the list is empty.", new TypeCheckingNativeMethod.WithNoArguments("pop!", runtime.list){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                List<Object> l = ((IokeList)IokeObject.data(on)).getList();
                if (l.size() == 0) {
                    return context.runtime.nil;
                }
                return l.remove(l.size() - 1);
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("removes the first element from the list and returns it. returns nil if the list is empty.", new TypeCheckingNativeMethod.WithNoArguments("shift!", runtime.list){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                List<Object> l = ((IokeList)IokeObject.data(on)).getList();
                if (l.size() == 0) {
                    return context.runtime.nil;
                }
                return l.remove(0);
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("will remove all the entries from the list, and then returns the list", new TypeCheckingNativeMethod.WithNoArguments("clear!", runtime.list){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                ((IokeList)IokeObject.data(on)).getList().clear();
                return on;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns true if this list is empty, false otherwise", new TypeCheckingNativeMethod.WithNoArguments("empty?", runtime.list){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return ((IokeList)IokeObject.data(on)).getList().isEmpty() ? context.runtime._true : context.runtime._false;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns true if the receiver includes the evaluated argument, otherwise false", new TypeCheckingNativeMethod("include?"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.list).withRequiredPositional("object").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return ((IokeList)IokeObject.data(on)).getList().contains(args.get(0)) ? context.runtime._true : context.runtime._false;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("adds the elements in the argument list to the current list, and then returns that list", new TypeCheckingNativeMethod("concat!"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.list).withRequiredPositional("otherList").whichMustMimic(runtime.list).getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                ((IokeList)IokeObject.data(on)).getList().addAll(((IokeList)IokeObject.data(args.get(0))).getList());
                return on;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns a new list that contains the receivers elements and the elements of the list sent in as the argument.", new TypeCheckingNativeMethod("+"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.list).withRequiredPositional("otherList").whichMustMimic(runtime.list).getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                ArrayList<Object> newList = new ArrayList<Object>();
                newList.addAll(((IokeList)IokeObject.data(on)).getList());
                newList.addAll(((IokeList)IokeObject.data(args.get(0))).getList());
                return context.runtime.newList(newList, IokeObject.as(on, context));
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns a new list that contains all the elements from the receivers list, except for those that are in the argument list", new TypeCheckingNativeMethod("-"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.list).withRequiredPositional("otherList").whichMustMimic(runtime.list).getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                ArrayList<Object> newList = new ArrayList<Object>();
                newList.addAll(((IokeList)IokeObject.data(on)).getList());
                newList.removeAll(((IokeList)IokeObject.data(args.get(0))).getList());
                return context.runtime.newList(newList, IokeObject.as(on, context));
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns a new sorted version of this list", new TypeCheckingNativeMethod.WithNoArguments("sort", runtime.list){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                IokeObject newList = IokeObject.mimic(on, message, context);
                try {
                    Collections.sort(((IokeList)IokeObject.data(newList)).getList(), new SpaceshipComparator(context, message));
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof ControlFlow) {
                        throw (ControlFlow)e.getCause();
                    }
                    throw e;
                }
                return newList;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("sorts this list in place and then returns it", new TypeCheckingNativeMethod.WithNoArguments("sort!", runtime.list){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                try {
                    Collections.sort(((IokeList)IokeObject.data(on)).getList(), new SpaceshipComparator(context, message));
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof ControlFlow) {
                        throw (ControlFlow)e.getCause();
                    }
                    throw e;
                }
                return on;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns the size of this list", new TypeCheckingNativeMethod.WithNoArguments("size", runtime.list){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return context.runtime.newNumber(((IokeList)IokeObject.data(on)).getList().size());
            }
        }));
        obj.aliasMethod("size", "length", null, null);
        obj.registerMethod(runtime.newNativeMethod("takes one argument, the index of the element to be returned. can be negative, and will in that case return indexed from the back of the list. if the index is outside the bounds of the list, will return nil. the argument can also be a range, and will in that case interpret the first index as where to start, and the second the end. the end can be negative and will in that case be from the end. if the first argument is negative, or after the second, an empty list will be returned. if the end point is larger than the list, the size of the list will be used as the end point.", new TypeCheckingNativeMethod("at"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.list).withRequiredPositional("index").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                Object arg = args.get(0);
                if (IokeObject.data(arg) instanceof Range) {
                    int first = Number.extractInt(Range.getFrom(arg), message, context);
                    if (first < 0) {
                        return context.runtime.newList(new ArrayList<Object>());
                    }
                    int last = Number.extractInt(Range.getTo(arg), message, context);
                    boolean inclusive = Range.isInclusive(arg);
                    List<Object> o = ((IokeList)IokeObject.data(on)).getList();
                    int size = o.size();
                    if (last < 0) {
                        last = size + last;
                    }
                    if (last < 0) {
                        return context.runtime.newList(new ArrayList<Object>());
                    }
                    if (last >= size) {
                        int n = last = inclusive ? size - 1 : size;
                    }
                    if (first > last || !inclusive && first == last) {
                        return context.runtime.newList(new ArrayList<Object>());
                    }
                    if (!inclusive) {
                        --last;
                    }
                    return context.runtime.newList(new ArrayList<Object>(o.subList(first, last + 1)));
                }
                if (!(IokeObject.data(arg) instanceof Number)) {
                    arg = IokeObject.convertToNumber(arg, message, context);
                }
                int index = ((Number)IokeObject.data(arg)).asJavaInteger();
                List<Object> o = ((IokeList)IokeObject.data(on)).getList();
                if (index < 0) {
                    index = o.size() + index;
                }
                if (index >= 0 && index < o.size()) {
                    return o.get(index);
                }
                return context.runtime.nil;
            }
        }));
        obj.aliasMethod("at", "[]", null, null);
        obj.registerMethod(runtime.newNativeMethod("takes an index and zero or more objects to insert at that point. the index can be negative to index from the end of the list. if the index is positive and larger than the size of the list, the list will be filled with nils inbetween.", new TypeCheckingNativeMethod("insert!"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.list).withRequiredPositional("index").whichMustMimic(runtime.number).withRest("objects").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, final IokeObject context, final IokeObject message) throws ControlFlow {
                int index = ((Number)IokeObject.data(args.get(0))).asJavaInteger();
                List<Object> l = ((IokeList)IokeObject.data(on)).getList();
                int size = l.size();
                if (index < 0) {
                    index = size + index + 1;
                }
                if (args.size() > 1) {
                    while (index < 0) {
                        final IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, message, context, "Error", "Index"), context).mimic(message, context);
                        condition.setCell("message", message);
                        condition.setCell("context", context);
                        condition.setCell("receiver", on);
                        condition.setCell("index", context.runtime.newNumber(index));
                        final int[] newCell = new int[]{index};
                        context.runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

                            public void run() throws ControlFlow {
                                context.runtime.errorCondition(condition);
                            }
                        }, context, new Restart.ArgumentGivingRestart("useValue"){

                            @Override
                            public List<String> getArgumentNames() {
                                return new ArrayList<String>(Arrays.asList("newValue"));
                            }

                            @Override
                            public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                                newCell[0] = Number.extractInt(arguments.get(0), message, context);
                                return context.runtime.nil;
                            }
                        });
                        index = newCell[0];
                        if (index >= 0) continue;
                        index = size + index;
                    }
                    for (int x = index - size; x > 0; --x) {
                        l.add(context.runtime.nil);
                    }
                    l.addAll(index, args.subList(1, args.size()));
                }
                return on;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("takes two arguments, the index of the element to set, and the value to set. the index can be negative and will in that case set indexed from the end of the list. if the index is larger than the current size, the list will be expanded with nils. an exception will be raised if a abs(negative index) is larger than the size.", new TypeCheckingNativeMethod("at="){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.list).withRequiredPositional("index").withRequiredPositional("value").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, final IokeObject context, final IokeObject message) throws ControlFlow {
                Object arg = args.get(0);
                Object value = args.get(1);
                if (!(IokeObject.data(arg) instanceof Number)) {
                    arg = IokeObject.convertToNumber(arg, message, context);
                }
                int index = ((Number)IokeObject.data(arg)).asJavaInteger();
                List<Object> o = ((IokeList)IokeObject.data(on)).getList();
                if (index < 0) {
                    index = o.size() + index;
                }
                while (index < 0) {
                    final IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, message, context, "Error", "Index"), context).mimic(message, context);
                    condition.setCell("message", message);
                    condition.setCell("context", context);
                    condition.setCell("receiver", on);
                    condition.setCell("index", context.runtime.newNumber(index));
                    final int[] newCell = new int[]{index};
                    context.runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

                        public void run() throws ControlFlow {
                            context.runtime.errorCondition(condition);
                        }
                    }, context, new Restart.ArgumentGivingRestart("useValue"){

                        @Override
                        public List<String> getArgumentNames() {
                            return new ArrayList<String>(Arrays.asList("newValue"));
                        }

                        @Override
                        public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                            newCell[0] = Number.extractInt(arguments.get(0), message, context);
                            return context.runtime.nil;
                        }
                    });
                    index = newCell[0];
                    if (index >= 0) continue;
                    index = o.size() + index;
                }
                if (index >= o.size()) {
                    int toAdd = index - o.size() + 1;
                    for (int i = 0; i < toAdd; ++i) {
                        o.add(context.runtime.nil);
                    }
                }
                o.set(index, value);
                return value;
            }
        }));
        obj.aliasMethod("at=", "[]=", null, null);
        obj.registerMethod(runtime.newNativeMethod("takes as argument the index of the element to be removed and returns it. can be negative and will in that case index from the back of the list. if the index is outside the bounds of the list, will return nil. the argument can also be a range, and will in that case remove the sublist beginning at the first index and extending to the position in the list specified by the second index (inclusive or exclusive depending on the range). the end of the range can be negative and will in that case index from the back of the list. if the start of the range is negative, or greater than the end, an empty list will be returned. if the end index exceeds the bounds of the list, its size will be used instead.", new TypeCheckingNativeMethod("removeAt!"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.list).withRequiredPositional("indexOrRange").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                Object arg = args.get(0);
                if (IokeObject.data(arg) instanceof Range) {
                    int first = Number.extractInt(Range.getFrom(arg), message, context);
                    if (first < 0) {
                        return IokeList.emptyList(context);
                    }
                    int last = Number.extractInt(Range.getTo(arg), message, context);
                    List<Object> receiver = IokeList.getList(on);
                    int size = receiver.size();
                    if (last < 0) {
                        last = size + last;
                    }
                    if (last < 0) {
                        return IokeList.emptyList(context);
                    }
                    boolean inclusive = Range.isInclusive(arg);
                    if (last >= size) {
                        int n = last = inclusive ? size - 1 : size;
                    }
                    if (first > last || !inclusive && first == last) {
                        return IokeList.emptyList(context);
                    }
                    if (!inclusive) {
                        --last;
                    }
                    ArrayList<Object> result = new ArrayList<Object>();
                    for (int i = 0; i <= last - first; ++i) {
                        result.add(receiver.remove(first));
                    }
                    return IokeList.copyList(context, result);
                }
                if (!(IokeObject.data(arg) instanceof Number)) {
                    arg = IokeObject.convertToNumber(arg, message, context);
                }
                int index = ((Number)IokeObject.data(arg)).asJavaInteger();
                List<Object> receiver = IokeList.getList(on);
                int size = receiver.size();
                if (index < 0) {
                    index = size + index;
                }
                if (index >= 0 && index < size) {
                    return receiver.remove(index);
                }
                return context.runtime.nil;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("takes one or more arguments. removes all occurrences of the provided arguments from the list and returns the updated list. if an argument is not contained, the list remains unchanged. sending this method to an empty list has no effect.", new TypeCheckingNativeMethod("remove!"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.list).withRequiredPositional("element").withRest("elements").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                List<Object> receiver = IokeList.getList(on);
                if (receiver.isEmpty()) {
                    return IokeList.emptyList(context);
                }
                receiver.removeAll(args);
                return IokeList.copyList(context, receiver);
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("takes one or more arguments. removes the first occurrence of the provided arguments from the list and returns the updated list. if an argument is not contained, the list remains unchanged. arguments that are provided multiple times are treated as distinct elements. sending this message to an empty list has no effect.", new TypeCheckingNativeMethod("removeFirst!"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.list).withRequiredPositional("element").withRest("elements").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                List<Object> receiver = IokeList.getList(on);
                if (receiver.isEmpty()) {
                    return IokeList.emptyList(context);
                }
                for (Object o : args) {
                    receiver.remove(o);
                }
                return IokeList.copyList(context, receiver);
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("removes all nils in this list, and then returns the list", new TypeCheckingNativeMethod.WithNoArguments("compact!", runtime.list){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                List<Object> list = IokeList.getList(on);
                ArrayList<Object> newList = new ArrayList<Object>();
                IokeObject nil = context.runtime.nil;
                for (Object o : list) {
                    if (o == nil) continue;
                    newList.add(o);
                }
                IokeList.setList(on, newList);
                return on;
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("reverses the elements in this list, then returns it", new TypeCheckingNativeMethod.WithNoArguments("reverse!", runtime.list){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                List<Object> list = IokeList.getList(on);
                Collections.reverse(list);
                return on;
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("flattens all lists in this list recursively, then returns it", new TypeCheckingNativeMethod.WithNoArguments("flatten!", runtime.list){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                IokeList.setList(on, IokeList.flatten(IokeList.getList(on)));
                return on;
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("returns a text composed of the asText representation of all elements in the list, separated by the separator. the separator defaults to an empty text.", new TypeCheckingNativeMethod("join"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.list).withOptionalPositional("separator", "").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                String result;
                List<Object> list = IokeList.getList(on);
                if (list.size() == 0) {
                    result = "";
                } else {
                    String sep = args.size() > 0 ? Text.getText(args.get(0)) : "";
                    StringBuilder sb = new StringBuilder();
                    IokeList.join(list, sb, sep, context.runtime.asText, context);
                    result = sb.toString();
                }
                return context.runtime.newText(result);
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("takes one or two arguments, and will then use these arguments as code to transform each element in this list. the transform happens in place. finally the method will return the receiver.", new NativeMethod("map!"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositionalUnevaluated("argOrCode").withOptionalPositionalUnevaluated("code").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                Runtime runtime = context.runtime;
                Object onAsList = context.runtime.list.convertToThis(on, message, context);
                List ls = ((IokeList)IokeObject.data(onAsList)).list;
                int size = ls.size();
                switch (message.getArgumentCount()) {
                    case 1: {
                        IokeObject code = IokeObject.as(message.getArguments().get(0), context);
                        for (int i = 0; i < size; ++i) {
                            ls.set(i, ((Message)IokeObject.data(code)).evaluateCompleteWithReceiver(code, context, context.getRealContext(), ls.get(i)));
                        }
                        break;
                    }
                    case 2: {
                        LexicalContext c = new LexicalContext(context.runtime, context, "Lexical activation context for List#map!", message, context);
                        String name = IokeObject.as(message.getArguments().get(0), context).getName();
                        IokeObject code = IokeObject.as(message.getArguments().get(1), context);
                        for (int i = 0; i < size; ++i) {
                            c.setCell(name, ls.get(i));
                            ls.set(i, ((Message)IokeObject.data(code)).evaluateCompleteWithoutExplicitReceiver(code, c, c.getRealContext()));
                        }
                        break;
                    }
                }
                return on;
            }
        }));
        obj.aliasMethod("map!", "collect!", null, null);
        obj.registerMethod(runtime.newNativeMethod("takes one or two arguments, and will then use these arguments as code to decide what elements should be removed from the list. the method will return the receiver.", new NativeMethod("removeIf!"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositionalUnevaluated("argOrCode").withOptionalPositionalUnevaluated("code").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                Runtime runtime = context.runtime;
                Object onAsList = context.runtime.list.convertToThis(on, message, context);
                List ls = ((IokeList)IokeObject.data(onAsList)).list;
                switch (message.getArgumentCount()) {
                    case 1: {
                        IokeObject code = IokeObject.as(message.getArguments().get(0), context);
                        Iterator iter = ls.iterator();
                        while (iter.hasNext()) {
                            Object obj = iter.next();
                            if (!IokeObject.isTrue(((Message)IokeObject.data(code)).evaluateCompleteWithReceiver(code, context, context.getRealContext(), obj))) continue;
                            iter.remove();
                        }
                        break;
                    }
                    case 2: {
                        LexicalContext c = new LexicalContext(context.runtime, context, "Lexical activation context for List#map!", message, context);
                        String name = IokeObject.as(message.getArguments().get(0), context).getName();
                        IokeObject code = IokeObject.as(message.getArguments().get(1), context);
                        Iterator iter = ls.iterator();
                        while (iter.hasNext()) {
                            Object obj = iter.next();
                            c.setCell(name, obj);
                            if (!IokeObject.isTrue(((Message)IokeObject.data(code)).evaluateCompleteWithoutExplicitReceiver(code, c, c.getRealContext()))) continue;
                            iter.remove();
                        }
                        break;
                    }
                }
                return on;
            }
        }));
    }

    private static List<Object> flatten(List<Object> list) {
        ArrayList<Object> result = new ArrayList<Object>(list.size() * 2);
        IokeList.flatten(list, result);
        return result;
    }

    private static void flatten(List<Object> list, List<Object> result) {
        for (Object l : list) {
            if (l instanceof IokeObject && IokeObject.data(l) instanceof IokeList) {
                IokeList.flatten(IokeList.getList(l), result);
                continue;
            }
            result.add(l);
        }
    }

    private static void join(List<Object> list, StringBuilder sb, String sep, IokeObject asText, IokeObject context) throws ControlFlow {
        String realSep = "";
        for (Object o : list) {
            sb.append(realSep);
            if (o instanceof IokeObject && IokeObject.data(o) instanceof IokeList) {
                IokeList.join(IokeList.getList(o), sb, sep, asText, context);
            } else {
                sb.append(Text.getText(((Message)IokeObject.data(asText)).sendTo(asText, context, o)));
            }
            realSep = sep;
        }
    }

    public void add(Object obj) {
        this.list.add(obj);
    }

    public List<Object> getList() {
        return this.list;
    }

    public void setList(List<Object> list) {
        this.list = list;
    }

    public static List<Object> getList(Object on) {
        return ((IokeList)IokeObject.data(on)).getList();
    }

    public static void setList(Object on, List<Object> list) {
        ((IokeList)IokeObject.data(on)).setList(list);
    }

    public static String getInspect(Object on) throws ControlFlow {
        return ((IokeList)IokeObject.data(on)).inspect(on);
    }

    public static String getNotice(Object on) throws ControlFlow {
        return ((IokeList)IokeObject.data(on)).notice(on);
    }

    public static IokeObject emptyList(IokeObject context) {
        return context.runtime.newList(new ArrayList<Object>());
    }

    public static IokeObject copyList(IokeObject context, List<Object> orig) {
        return context.runtime.newList(new ArrayList<Object>(orig));
    }

    @Override
    public IokeData cloneData(IokeObject obj, IokeObject m, IokeObject context) {
        return new IokeList(new ArrayList<Object>(this.list));
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public String toString(IokeObject obj) {
        return this.list.toString();
    }

    public String inspect(Object obj) throws ControlFlow {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        String sep = "";
        for (Object o : this.list) {
            sb.append(sep).append(IokeObject.inspect(o));
            sep = ", ";
        }
        sb.append("]");
        return sb.toString();
    }

    public String notice(Object obj) throws ControlFlow {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        String sep = "";
        for (Object o : this.list) {
            sb.append(sep).append(IokeObject.notice(o));
            sep = ", ";
        }
        sb.append("]");
        return sb.toString();
    }
}

