/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.AliasMethod;
import ioke.lang.CanRun;
import ioke.lang.Hook;
import ioke.lang.IokeData;
import ioke.lang.IokeRegistry;
import ioke.lang.Message;
import ioke.lang.Method;
import ioke.lang.NullObject;
import ioke.lang.Restart;
import ioke.lang.RunnableWithControlFlow;
import ioke.lang.Runtime;
import ioke.lang.Text;
import ioke.lang.TypeChecker;
import ioke.lang.exceptions.ControlFlow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IokeObject
implements TypeChecker {
    public Runtime runtime;
    private String documentation;
    private Map<String, Object> cells = new LinkedHashMap<String, Object>();
    private List<IokeObject> mimics = new ArrayList<IokeObject>();
    Collection<IokeObject> hooks = null;
    private IokeData data;
    private boolean frozen = false;
    private boolean marked = false;
    public static final Pattern SLIGHTLY_BAD_CHARS = Pattern.compile("[!=\\.\\-\\+&|\\{\\[]");

    public IokeObject(Runtime runtime, String documentation) {
        this(runtime, documentation, IokeData.None);
    }

    public IokeObject(Runtime runtime, String documentation, IokeData data) {
        this.runtime = runtime;
        this.documentation = documentation;
        this.data = data;
    }

    public static boolean same(Object one, Object two) throws ControlFlow {
        if (one instanceof IokeObject && two instanceof IokeObject) {
            return IokeObject.as((Object)one, null).cells == IokeObject.as((Object)two, null).cells;
        }
        return one == two;
    }

    private void checkFrozen(String modification, IokeObject message, IokeObject context) throws ControlFlow {
        if (this.frozen) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, message, context, "Error", "ModifyOnFrozen"), context).mimic(message, context);
            condition.setCell("message", message);
            condition.setCell("context", context);
            condition.setCell("receiver", this);
            condition.setCell("modification", context.runtime.getSymbol(modification));
            context.runtime.errorCondition(condition);
        }
    }

    public void become(IokeObject other, IokeObject message, IokeObject context) throws ControlFlow {
        this.checkFrozen("become!", message, context);
        this.runtime = other.runtime;
        this.documentation = other.documentation;
        this.cells = other.cells;
        this.mimics = other.mimics;
        this.data = other.data;
        this.frozen = other.frozen;
        this.hooks = other.hooks;
    }

    public void init() throws ControlFlow {
        this.data.init(this);
    }

    public static boolean isFrozen(Object on) {
        return on instanceof IokeObject && IokeObject.as((Object)on, null).frozen;
    }

    public static void freeze(Object on) {
        if (on instanceof IokeObject) {
            IokeObject.as((Object)on, null).frozen = true;
        }
    }

    public static void thaw(Object on) {
        if (on instanceof IokeObject) {
            IokeObject.as((Object)on, null).frozen = false;
        }
    }

    public void setDocumentation(String docs, IokeObject message, IokeObject context) throws ControlFlow {
        this.checkFrozen("documentation=", message, context);
        this.documentation = docs;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setData(IokeData data) {
        this.data = data;
    }

    public void setKind(String kind) {
        this.cells.put("kind", this.runtime.newText(kind));
    }

    public static List<IokeObject> getMimics(Object on, IokeObject context) {
        return IokeObject.as((Object)on, (IokeObject)context).mimics;
    }

    public static void removeMimic(Object on, Object other, IokeObject message, IokeObject context) throws ControlFlow {
        IokeObject me = IokeObject.as(on, context);
        me.checkFrozen("removeMimic!", message, context);
        me.mimics.remove(other);
        if (me.hooks != null) {
            Hook.fireMimicsChanged(me, message, context, other);
            Hook.fireMimicRemoved(me, message, context, other);
        }
    }

    public static void removeAllMimics(Object on, IokeObject message, IokeObject context) throws ControlFlow {
        IokeObject me = IokeObject.as(on, context);
        me.checkFrozen("removeAllMimics!", message, context);
        Iterator<IokeObject> it = me.mimics.iterator();
        while (it.hasNext()) {
            IokeObject mm = it.next();
            it.remove();
            Hook.fireMimicsChanged(me, message, context, mm);
            Hook.fireMimicRemoved(me, message, context, mm);
        }
    }

    public static Object getRealContext(Object o) {
        if (o instanceof IokeObject) {
            return IokeObject.as(o, null).getRealContext();
        }
        return o;
    }

    public Object getRealContext() {
        return this;
    }

    public IokeObject allocateCopy(IokeObject m, IokeObject context) {
        return new IokeObject(this.runtime, null, this.data.cloneData(this, m, context));
    }

    public static Object findSuperCellOn(Object obj, IokeObject early, IokeObject message, IokeObject context, String name) {
        return IokeObject.as(obj, context).markingFindSuperCell(early, message, context, name, new boolean[]{false});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object markingFindSuperCell(IokeObject early, IokeObject message, IokeObject context, String name, boolean[] found) {
        if (this.marked) {
            return this.runtime.nul;
        }
        if (this.cells.containsKey(name)) {
            if (found[0]) {
                return this.cells.get(name);
            }
            if (early == this.cells.get(name)) {
                found[0] = true;
            }
        }
        this.marked = true;
        try {
            for (IokeObject mimic : this.mimics) {
                Object cell = mimic.markingFindSuperCell(early, message, context, name, found);
                if (cell == this.runtime.nul) continue;
                Object object = cell;
                return object;
            }
            NullObject nullObject = this.runtime.nul;
            return nullObject;
        }
        finally {
            this.marked = false;
        }
    }

    public static Object findCell(Object obj, IokeObject m, IokeObject context, String name) {
        return IokeObject.as(obj, context).markingFindCell(m, context, name);
    }

    public static Object findPlace(Object obj, String name) {
        return IokeObject.as(obj, null).markingFindPlace(name);
    }

    public static Object findPlace(Object obj, IokeObject m, IokeObject context, String name) throws ControlFlow {
        Object result = IokeObject.findPlace(obj, name);
        if (result == m.runtime.nul) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(m.runtime.condition, m, context, "Error", "NoSuchCell"), context).mimic(m, context);
            condition.setCell("message", m);
            condition.setCell("context", context);
            condition.setCell("receiver", obj);
            condition.setCell("cellName", m.runtime.getSymbol(name));
            m.runtime.withReturningRestart("ignore", context, new RunnableWithControlFlow(){

                public void run() throws ControlFlow {
                    condition.runtime.errorCondition(condition);
                }
            });
        }
        return result;
    }

    public Object findPlace(String name) {
        return this.markingFindPlace(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object markingFindPlace(String name) {
        if (this.marked) {
            return this.runtime.nul;
        }
        if (this.cells.containsKey(name)) {
            if (this.cells.get(name) == this.runtime.nul) {
                return this.runtime.nul;
            }
            return this;
        }
        this.marked = true;
        try {
            for (IokeObject mimic : this.mimics) {
                Object place = mimic.markingFindPlace(name);
                if (place == this.runtime.nul) continue;
                Object object = place;
                return object;
            }
            NullObject nullObject = this.runtime.nul;
            return nullObject;
        }
        finally {
            this.marked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object markingFindCell(IokeObject m, IokeObject context, String name) {
        if (this.marked) {
            return this.runtime.nul;
        }
        if (this.cells.containsKey(name)) {
            return this.cells.get(name);
        }
        this.marked = true;
        try {
            for (IokeObject mimic : this.mimics) {
                Object cell = mimic.markingFindCell(m, context, name);
                if (cell == this.runtime.nul) continue;
                Object object = cell;
                return object;
            }
            NullObject nullObject = this.runtime.nul;
            return nullObject;
        }
        finally {
            this.marked = false;
        }
    }

    public static IokeObject mimic(Object on, IokeObject message, IokeObject context) throws ControlFlow {
        return IokeObject.as(on, context).mimic(message, context);
    }

    public IokeObject mimic(IokeObject message, IokeObject context) throws ControlFlow {
        this.checkFrozen("mimic!", message, context);
        IokeObject clone = this.allocateCopy(message, context);
        clone.mimics(this, message, context);
        return clone;
    }

    public Object findCell(IokeObject m, IokeObject context, String name) {
        return this.markingFindCell(m, context, name);
    }

    public static boolean isKind(Object on, String kind, IokeObject context) {
        return IokeObject.as(on, context).isKind(kind);
    }

    public static boolean isMimic(Object on, IokeObject potentialMimic, IokeObject context) {
        return IokeObject.as(on, context).isMimic(potentialMimic);
    }

    public static boolean isKind(IokeObject on, String kind) {
        return IokeObject.as(on, on).isKind(kind);
    }

    public static boolean isMimic(IokeObject on, IokeObject potentialMimic) {
        return IokeObject.as(on, on).isMimic(potentialMimic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isKind(String kind) {
        if (this.marked) {
            return false;
        }
        if (this.cells.containsKey("kind") && kind.equals(Text.getText(this.cells.get("kind")))) {
            return true;
        }
        this.marked = true;
        try {
            for (IokeObject mimic : this.mimics) {
                if (!mimic.isKind(kind)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.marked = false;
        }
    }

    private static final boolean contains(List<IokeObject> l, IokeObject obj) {
        for (IokeObject p : l) {
            if (p != obj) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMimic(IokeObject pot) {
        if (this.marked) {
            return false;
        }
        if (this.cells == pot.cells || IokeObject.contains(this.mimics, pot)) {
            return true;
        }
        this.marked = true;
        try {
            for (IokeObject mimic : this.mimics) {
                if (!mimic.isMimic(pot)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.marked = false;
        }
    }

    public static Object getCellChain(Object on, IokeObject m, IokeObject c, String ... names) throws ControlFlow {
        Object current = on;
        for (String name : names) {
            current = IokeObject.getCell(current, m, c, name);
        }
        return current;
    }

    public static Object getCell(Object on, IokeObject m, IokeObject context, String name) throws ControlFlow {
        return ((IokeObject)on).getCell(m, context, name);
    }

    public static Object setCell(Object on, IokeObject m, IokeObject context, String name, Object value) {
        ((IokeObject)on).setCell(name, value);
        return value;
    }

    public static void removeCell(Object on, IokeObject m, IokeObject context, String name) throws ControlFlow {
        ((IokeObject)on).removeCell(m, context, name);
    }

    public static void undefineCell(Object on, IokeObject m, IokeObject context, String name) throws ControlFlow {
        ((IokeObject)on).undefineCell(m, context, name);
    }

    public Object getCell(IokeObject m, IokeObject context, String name) throws ControlFlow {
        String outerName = name;
        Object cell = this.findCell(m, context, name);
        while (cell == this.runtime.nul) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(this.runtime.condition, m, context, "Error", "NoSuchCell"), context).mimic(m, context);
            condition.setCell("message", m);
            condition.setCell("context", context);
            condition.setCell("receiver", this);
            condition.setCell("cellName", this.runtime.getSymbol(name));
            Object[] newCell = new Object[]{cell};
            this.runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

                public void run() throws ControlFlow {
                    IokeObject.this.runtime.errorCondition(condition);
                }
            }, context, new Restart.ArgumentGivingRestart("useValue"){

                @Override
                public String report() {
                    return "Use value for: " + outerName;
                }

                @Override
                public List<String> getArgumentNames() {
                    return new ArrayList<String>(Arrays.asList("newValue"));
                }

                @Override
                public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                    newCell[0] = arguments.get(0);
                    return context.runtime.nil;
                }
            }, new Restart.ArgumentGivingRestart("storeValue"){

                @Override
                public String report() {
                    return "Store value for: " + outerName;
                }

                @Override
                public List<String> getArgumentNames() {
                    return new ArrayList<String>(Arrays.asList("newValue"));
                }

                @Override
                public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                    newCell[0] = arguments.get(0);
                    IokeObject.this.setCell(outerName, newCell[0]);
                    return context.runtime.nil;
                }
            });
            cell = newCell[0];
        }
        return cell;
    }

    public void removeCell(IokeObject m, IokeObject context, String name) throws ControlFlow {
        this.checkFrozen("removeCell!", m, context);
        if (this.cells.containsKey(name)) {
            Object prev = this.cells.remove(name);
            if (this.hooks != null) {
                Hook.fireCellChanged(this, m, context, name, prev);
                Hook.fireCellRemoved(this, m, context, name, prev);
            }
        } else {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(this.runtime.condition, m, context, "Error", "NoSuchCell"), context).mimic(m, context);
            condition.setCell("message", m);
            condition.setCell("context", context);
            condition.setCell("receiver", this);
            condition.setCell("cellName", this.runtime.getSymbol(name));
            this.runtime.withReturningRestart("ignore", context, new RunnableWithControlFlow(){

                public void run() throws ControlFlow {
                    IokeObject.this.runtime.errorCondition(condition);
                }
            });
        }
    }

    public void undefineCell(IokeObject m, IokeObject context, String name) throws ControlFlow {
        this.checkFrozen("undefineCell!", m, context);
        Object prev = this.cells.get(name);
        this.cells.put(name, this.runtime.nul);
        if (this.hooks != null) {
            if (prev == null) {
                prev = this.runtime.nil;
            }
            Hook.fireCellChanged(this, m, context, name, prev);
            Hook.fireCellUndefined(this, m, context, name, prev);
        }
    }

    public String getKind(IokeObject message, IokeObject context) throws ControlFlow {
        Object obj = this.findCell(null, null, "kind");
        if (IokeObject.data(obj) instanceof Text) {
            return ((Text)IokeObject.data(obj)).getText();
        }
        return ((Text)IokeObject.data(IokeObject.getOrActivate(obj, context, message, this))).getText();
    }

    public String getKind() {
        Object obj = this.findCell(null, null, "kind");
        if (obj != null && IokeObject.data(obj) instanceof Text) {
            return ((Text)IokeObject.data(obj)).getText();
        }
        return null;
    }

    public boolean hasKind() {
        return this.cells.containsKey("kind");
    }

    public static Object getOrActivate(Object obj, IokeObject context, IokeObject message, Object on) throws ControlFlow {
        if (obj instanceof IokeObject) {
            return IokeObject.as(obj, context).getOrActivate(context, message, on);
        }
        return obj;
    }

    public static Object perform(Object obj, IokeObject ctx, IokeObject message) throws ControlFlow {
        if (obj instanceof IokeObject || IokeRegistry.isWrapped(obj, ctx)) {
            return IokeObject.as(obj, ctx).perform(ctx, message);
        }
        return IokeObject.performJava(obj, ctx, message);
    }

    private static Object performJava(Object obj, IokeObject ctx, IokeObject message) throws ControlFlow {
        String name;
        IokeObject clz = IokeRegistry.wrap(obj.getClass(), ctx);
        Runtime runtime = ctx.runtime;
        String outerName = name = message.getName();
        Object cell = clz.findCell(message, ctx, name);
        Object passed = null;
        while (cell == runtime.nul) {
            cell = passed = clz.findCell(message, ctx, "pass");
            if (passed != runtime.nul && clz.isApplicable(passed, message, ctx)) break;
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(runtime.condition, message, ctx, "Error", "NoSuchCell"), ctx).mimic(message, ctx);
            condition.setCell("message", message);
            condition.setCell("context", ctx);
            condition.setCell("receiver", obj);
            condition.setCell("cellName", runtime.getSymbol(name));
            Object[] newCell = new Object[]{cell};
            runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

                public void run() throws ControlFlow {
                    runtime.errorCondition(condition);
                }
            }, ctx, new Restart.ArgumentGivingRestart("useValue"){

                @Override
                public String report() {
                    return "Use value for: " + outerName;
                }

                @Override
                public List<String> getArgumentNames() {
                    return new ArrayList<String>(Arrays.asList("newValue"));
                }

                @Override
                public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                    newCell[0] = arguments.get(0);
                    return context.runtime.nil;
                }
            }, new Restart.ArgumentGivingRestart("storeValue"){

                @Override
                public String report() {
                    return "Store value for: " + outerName;
                }

                @Override
                public List<String> getArgumentNames() {
                    return new ArrayList<String>(Arrays.asList("newValue"));
                }

                @Override
                public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                    newCell[0] = arguments.get(0);
                    clz.setCell(outerName, newCell[0]);
                    return context.runtime.nil;
                }
            });
            cell = newCell[0];
        }
        return IokeObject.getOrActivate(cell, ctx, message, obj);
    }

    public Object perform(IokeObject ctx, IokeObject message) throws ControlFlow {
        return this.perform(ctx, message, message.getName());
    }

    private boolean isApplicable(Object pass, IokeObject message, IokeObject ctx) throws ControlFlow {
        if (pass != null && pass != this.runtime.nul && IokeObject.as(pass, ctx).findCell(message, ctx, "applicable?") != this.runtime.nul) {
            return IokeObject.isTrue(((Message)IokeObject.data(this.runtime.isApplicableMessage)).sendTo(this.runtime.isApplicableMessage, ctx, pass, this.runtime.createMessage(Message.wrap(message))));
        }
        return true;
    }

    public Object perform(IokeObject ctx, IokeObject message, String name) throws ControlFlow {
        String outerName = name;
        Object cell = this.findCell(message, ctx, name);
        Object passed = null;
        while (cell == this.runtime.nul) {
            cell = passed = this.findCell(message, ctx, "pass");
            if (passed != this.runtime.nul && this.isApplicable(passed, message, ctx)) break;
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(this.runtime.condition, message, ctx, "Error", "NoSuchCell"), ctx).mimic(message, ctx);
            condition.setCell("message", message);
            condition.setCell("context", ctx);
            condition.setCell("receiver", this);
            condition.setCell("cellName", this.runtime.getSymbol(name));
            Object[] newCell = new Object[]{cell};
            this.runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

                public void run() throws ControlFlow {
                    IokeObject.this.runtime.errorCondition(condition);
                }
            }, ctx, new Restart.ArgumentGivingRestart("useValue"){

                @Override
                public String report() {
                    return "Use value for: " + outerName;
                }

                @Override
                public List<String> getArgumentNames() {
                    return new ArrayList<String>(Arrays.asList("newValue"));
                }

                @Override
                public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                    newCell[0] = arguments.get(0);
                    return context.runtime.nil;
                }
            }, new Restart.ArgumentGivingRestart("storeValue"){

                @Override
                public String report() {
                    return "Store value for: " + outerName;
                }

                @Override
                public List<String> getArgumentNames() {
                    return new ArrayList<String>(Arrays.asList("newValue"));
                }

                @Override
                public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                    newCell[0] = arguments.get(0);
                    IokeObject.this.setCell(outerName, newCell[0]);
                    return context.runtime.nil;
                }
            });
            cell = newCell[0];
        }
        return IokeObject.getOrActivate(cell, ctx, message, this);
    }

    public static void setCell(Object on, String name, Object value, IokeObject context) {
        IokeObject.as(on, context).setCell(name, value);
    }

    public static void setCell(IokeObject on, String name, Object value) {
        IokeObject.as(on, on).setCell(name, value);
    }

    public void setCell(String name, Object value) {
        this.cells.put(name, value);
    }

    public static void assign(Object on, String name, Object value, IokeObject context, IokeObject message) throws ControlFlow {
        IokeObject.as(on, context).assign(name, value, context, message);
    }

    public void assign(String name, Object value, IokeObject context, IokeObject message) throws ControlFlow {
        this.checkFrozen("=", message, context);
        if (!SLIGHTLY_BAD_CHARS.matcher(name).find() && this.findCell(message, context, name + "=") != this.runtime.nul) {
            IokeObject msg = this.runtime.createMessage(new Message(this.runtime, name + "=", this.runtime.createMessage(Message.wrap(IokeObject.as(value, context)))));
            ((Message)IokeObject.data(msg)).sendTo(msg, context, this);
        } else if (this.hooks != null) {
            boolean contains = this.cells.containsKey(name);
            Object prev = context.runtime.nil;
            if (contains) {
                prev = this.cells.get(name);
            }
            this.cells.put(name, value);
            if (!contains) {
                Hook.fireCellAdded(this, message, context, name);
            }
            Hook.fireCellChanged(this, message, context, name, prev);
        } else {
            this.cells.put(name, value);
        }
    }

    public boolean isSymbol() {
        return this.data.isSymbol();
    }

    public boolean isNil() {
        return this.data.isNil();
    }

    public static boolean isTrue(Object on) {
        return !(on instanceof IokeObject) || IokeObject.as(on, null).isTrue();
    }

    public boolean isTrue() {
        return this.data.isTrue();
    }

    public static boolean isMessage(Object obj) {
        return obj instanceof IokeObject && IokeObject.as(obj, null).isMessage();
    }

    public boolean isMessage() {
        return this.data.isMessage();
    }

    public List<IokeObject> getMimics() {
        return this.mimics;
    }

    public void mimicsWithoutCheck(IokeObject mimic) {
        if (!IokeObject.contains(this.mimics, mimic)) {
            this.mimics.add(mimic);
        }
    }

    public void mimicsWithoutCheck(int index, IokeObject mimic) {
        if (!IokeObject.contains(this.mimics, mimic)) {
            this.mimics.add(index, mimic);
        }
    }

    public void mimics(IokeObject mimic, IokeObject message, IokeObject context) throws ControlFlow {
        this.checkFrozen("mimic!", message, context);
        mimic.data.checkMimic(mimic, message, context);
        if (!IokeObject.contains(this.mimics, mimic)) {
            this.mimics.add(mimic);
            if (mimic.hooks != null) {
                Hook.fireMimicked(mimic, message, context, this);
            }
            if (this.hooks != null) {
                Hook.fireMimicsChanged(this, message, context, mimic);
                Hook.fireMimicAdded(this, message, context, mimic);
            }
        }
    }

    public void mimics(int index, IokeObject mimic, IokeObject message, IokeObject context) throws ControlFlow {
        this.checkFrozen("prependMimic!", message, context);
        mimic.data.checkMimic(mimic, message, context);
        if (!IokeObject.contains(this.mimics, mimic)) {
            this.mimics.add(index, mimic);
            if (mimic.hooks != null) {
                Hook.fireMimicked(mimic, message, context, this);
            }
            if (this.hooks != null) {
                Hook.fireMimicsChanged(this, message, context, mimic);
                Hook.fireMimicAdded(this, message, context, mimic);
            }
        }
    }

    public void registerMethod(IokeObject m) {
        this.cells.put(((Method)m.data).getName(), m);
    }

    public void aliasMethod(String originalName, String newName, IokeObject message, IokeObject context) throws ControlFlow {
        this.checkFrozen("aliasMethod", message, context);
        IokeObject io = IokeObject.as(this.findCell(null, null, originalName), context);
        IokeObject newObj = io.mimic(null, null);
        newObj.data = new AliasMethod(newName, io.data, io);
        this.cells.put(newName, newObj);
    }

    public void registerMethod(String name, IokeObject m) {
        this.cells.put(name, m);
    }

    public void registerCell(String name, Object o) {
        this.cells.put(name, o);
    }

    public boolean isActivatable() {
        return IokeObject.isTrue(this.findCell(null, null, "activatable"));
    }

    public IokeObject negate() {
        return this.data.negate(this);
    }

    public static Map<String, Object> getCells(Object on, IokeObject context) {
        return IokeObject.as(on, context).getCells();
    }

    public Map<String, Object> getCells() {
        return this.cells;
    }

    public static IokeData data(Object on) {
        return ((IokeObject)on).data;
    }

    public static IokeObject as(Object on, IokeObject context) {
        if (on instanceof IokeObject) {
            return (IokeObject)on;
        }
        return IokeRegistry.wrap(on, context);
    }

    public Object getSelf() {
        return this.cells.get("self");
    }

    public static IokeObject convertToNumber(Object on, IokeObject m, IokeObject context) throws ControlFlow {
        return ((IokeObject)on).convertToNumber(m, context);
    }

    public IokeObject convertToNumber(IokeObject m, IokeObject context) throws ControlFlow {
        return this.data.convertToNumber(this, m, context);
    }

    public static Object convertTo(String kind, Object on, boolean signalCondition, String conversionMethod, IokeObject message, IokeObject context) throws ControlFlow {
        return ((IokeObject)on).convertTo(kind, signalCondition, conversionMethod, message, context);
    }

    public static Object convertTo(Object mimic, Object on, boolean signalCondition, String conversionMethod, IokeObject message, IokeObject context) throws ControlFlow {
        return ((IokeObject)on).convertTo(mimic, signalCondition, conversionMethod, message, context);
    }

    public static IokeObject convertToRational(Object on, IokeObject m, IokeObject context, boolean signalCondition) throws ControlFlow {
        return ((IokeObject)on).convertToRational(m, context, signalCondition);
    }

    public static IokeObject convertToDecimal(Object on, IokeObject m, IokeObject context, boolean signalCondition) throws ControlFlow {
        return ((IokeObject)on).convertToDecimal(m, context, signalCondition);
    }

    public Object convertTo(String kind, boolean signalCondition, String conversionMethod, IokeObject message, IokeObject context) throws ControlFlow {
        Object result = this.data.convertTo(this, kind, false, conversionMethod, message, context);
        if (result == null) {
            if (conversionMethod != null && this.findCell(message, context, conversionMethod) != context.runtime.nul) {
                IokeObject msg = context.runtime.newMessage(conversionMethod);
                return ((Message)IokeObject.data(msg)).sendTo(msg, context, this);
            }
            if (signalCondition) {
                return this.data.convertTo(this, kind, true, conversionMethod, message, context);
            }
            return context.runtime.nul;
        }
        return result;
    }

    public Object convertTo(Object mimic, boolean signalCondition, String conversionMethod, IokeObject message, IokeObject context) throws ControlFlow {
        Object result = this.data.convertTo(this, mimic, false, conversionMethod, message, context);
        if (result == null) {
            if (conversionMethod != null && this.findCell(message, context, conversionMethod) != context.runtime.nul) {
                IokeObject msg = context.runtime.newMessage(conversionMethod);
                return ((Message)IokeObject.data(msg)).sendTo(msg, context, this);
            }
            if (signalCondition) {
                return this.data.convertTo(this, mimic, true, conversionMethod, message, context);
            }
            return context.runtime.nul;
        }
        return result;
    }

    public Object convertToThis(Object on, IokeObject message, IokeObject context) throws ControlFlow {
        return this.convertToThis(on, true, message, context);
    }

    public Object convertToThis(Object on, boolean signalCondition, IokeObject message, IokeObject context) throws ControlFlow {
        if (on instanceof IokeObject) {
            if (IokeObject.data(on).getClass().equals(this.data.getClass())) {
                return on;
            }
            return IokeObject.convertTo(this, on, signalCondition, IokeObject.data(on).getConvertMethod(), message, context);
        }
        if (signalCondition) {
            throw new RuntimeException("oh no. -(: " + message.getName());
        }
        return context.runtime.nul;
    }

    public static Object ensureTypeIs(Class<?> clazz, IokeObject self, Object on, IokeObject context, IokeObject message) throws ControlFlow {
        Object[] receiver = new Object[]{on};
        while (!clazz.isInstance(IokeObject.data(receiver[0]))) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, message, context, "Error", "Type", "IncorrectType"), context).mimic(message, context);
            condition.setCell("message", message);
            condition.setCell("context", context);
            condition.setCell("receiver", self);
            condition.setCell("expectedType", context.runtime.nil);
            context.runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

                public void run() throws ControlFlow {
                    context.runtime.errorCondition(condition);
                }
            }, context, new Restart.ArgumentGivingRestart("useValue"){

                @Override
                public List<String> getArgumentNames() {
                    return new ArrayList<String>(Arrays.asList("newValue"));
                }

                @Override
                public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                    receiver[0] = arguments.get(0);
                    return context.runtime.nil;
                }
            });
        }
        return receiver[0];
    }

    public IokeObject convertToRational(IokeObject m, IokeObject context, boolean signalCondition) throws ControlFlow {
        IokeObject result = this.data.convertToRational(this, m, context, false);
        if (result == null) {
            if (this.findCell(m, context, "asRational") != context.runtime.nul) {
                return IokeObject.as(((Message)IokeObject.data(context.runtime.asRational)).sendTo(context.runtime.asRational, context, this), context);
            }
            if (signalCondition) {
                return this.data.convertToRational(this, m, context, true);
            }
            return context.runtime.nil;
        }
        return result;
    }

    public IokeObject convertToDecimal(IokeObject m, IokeObject context, boolean signalCondition) throws ControlFlow {
        IokeObject result = this.data.convertToDecimal(this, m, context, false);
        if (result == null) {
            if (this.findCell(m, context, "asDecimal") != context.runtime.nul) {
                return IokeObject.as(((Message)IokeObject.data(context.runtime.asDecimal)).sendTo(context.runtime.asDecimal, context, this), context);
            }
            if (signalCondition) {
                return this.data.convertToDecimal(this, m, context, true);
            }
            return context.runtime.nil;
        }
        return result;
    }

    public static IokeObject convertToText(Object on, IokeObject m, IokeObject context, boolean signalCondition) throws ControlFlow {
        return ((IokeObject)on).convertToText(m, context, signalCondition);
    }

    public static IokeObject tryConvertToText(Object on, IokeObject m, IokeObject context) throws ControlFlow {
        return ((IokeObject)on).tryConvertToText(m, context);
    }

    public static IokeObject convertToSymbol(Object on, IokeObject m, IokeObject context, boolean signalCondition) throws ControlFlow {
        return ((IokeObject)on).convertToSymbol(m, context, signalCondition);
    }

    public static IokeObject convertToRegexp(Object on, IokeObject m, IokeObject context) throws ControlFlow {
        return ((IokeObject)on).convertToRegexp(m, context);
    }

    public static String inspect(Object on) throws ControlFlow {
        if (on instanceof IokeObject) {
            IokeObject ion = (IokeObject)on;
            Runtime runtime = ion.runtime;
            return Text.getText(((Message)IokeObject.data(runtime.inspectMessage)).sendTo(runtime.inspectMessage, ion, ion));
        }
        return on.toString();
    }

    public static String notice(Object on) throws ControlFlow {
        if (on instanceof IokeObject) {
            IokeObject ion = (IokeObject)on;
            Runtime runtime = ion.runtime;
            return Text.getText(((Message)IokeObject.data(runtime.noticeMessage)).sendTo(runtime.noticeMessage, ion, ion));
        }
        return on.toString();
    }

    public IokeObject convertToText(IokeObject m, IokeObject context, boolean signalCondition) throws ControlFlow {
        IokeObject result = this.data.convertToText(this, m, context, false);
        if (result == null) {
            if (this.findCell(m, context, "asText") != context.runtime.nul) {
                return IokeObject.as(((Message)IokeObject.data(context.runtime.asText)).sendTo(context.runtime.asText, context, this), context);
            }
            if (signalCondition) {
                return this.data.convertToText(this, m, context, true);
            }
            return context.runtime.nil;
        }
        return result;
    }

    public IokeObject tryConvertToText(IokeObject m, IokeObject context) throws ControlFlow {
        return this.data.tryConvertToText(this, m, context);
    }

    public IokeObject convertToSymbol(IokeObject m, IokeObject context, boolean signalCondition) throws ControlFlow {
        IokeObject result = this.data.convertToSymbol(this, m, context, false);
        if (result == null) {
            if (this.findCell(m, context, "asSymbol") != context.runtime.nul) {
                return IokeObject.as(((Message)IokeObject.data(context.runtime.asSymbol)).sendTo(context.runtime.asSymbol, context, this), context);
            }
            if (signalCondition) {
                return this.data.convertToSymbol(this, m, context, true);
            }
            return context.runtime.nil;
        }
        return result;
    }

    public IokeObject convertToRegexp(IokeObject m, IokeObject context) throws ControlFlow {
        return this.data.convertToRegexp(this, m, context);
    }

    public Object getOrActivate(IokeObject context, IokeObject message, Object on) throws ControlFlow {
        if (this.isActivatable() || this.data instanceof CanRun && message.getArguments().size() > 0) {
            return this.activate(context, message, on);
        }
        return this;
    }

    public String toString() {
        return this.data.toString(this);
    }

    public static Object activate(Object self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
        return IokeObject.as(self, context).activate(context, message, on);
    }

    public Object activate(IokeObject context, IokeObject message, Object on) throws ControlFlow {
        return this.data.activate(this, context, message, on);
    }

    public Object activateWithData(IokeObject context, IokeObject message, Object on, Map<String, Object> d1) throws ControlFlow {
        return this.data.activateWithData(this, context, message, on, d1);
    }

    public Object activateWithCall(IokeObject context, IokeObject message, Object on, Object c) throws ControlFlow {
        return this.data.activateWithCall(this, context, message, on, c);
    }

    public Object activateWithCallAndData(IokeObject context, IokeObject message, Object on, Object c, Map<String, Object> d1) throws ControlFlow {
        return this.data.activateWithCallAndData(this, context, message, on, c, d1);
    }

    public boolean equals(Object other) {
        try {
            return this.isEqualTo(other);
        }
        catch (Exception e) {
            return false;
        }
        catch (ControlFlow e) {
            return false;
        }
    }

    public int hashCode() {
        return this.iokeHashCode();
    }

    public static boolean equals(Object lhs, Object rhs) throws ControlFlow {
        return ((IokeObject)lhs).isEqualTo(rhs);
    }

    public boolean isEqualTo(Object other) throws ControlFlow {
        return this.data.isEqualTo(this, other);
    }

    public int iokeHashCode() {
        try {
            return this.data.hashCode(this);
        }
        catch (Exception e) {
            return -1;
        }
        catch (ControlFlow e) {
            return 0;
        }
    }

    public List<Object> getArguments() throws ControlFlow {
        return this.data.getArguments(this);
    }

    public int getArgumentCount() throws ControlFlow {
        return this.data.getArgumentCount(this);
    }

    public String getName() throws ControlFlow {
        return this.data.getName(this);
    }

    public String getFile() throws ControlFlow {
        return this.data.getFile(this);
    }

    public int getLine() throws ControlFlow {
        return this.data.getLine(this);
    }

    public int getPosition() throws ControlFlow {
        return this.data.getPosition(this);
    }

    @Override
    public Object convertToMimic(Object on, IokeObject message, IokeObject context, boolean signal) throws ControlFlow {
        return this.convertToThis(on, signal, message, context);
    }
}

