/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import com.google.common.collect.MapMaker;
import ioke.lang.IokeObject;
import ioke.lang.Runtime;
import java.util.Map;

public class IokeRegistry {
    public Runtime runtime;
    private final Map<Object, IokeObject> wrappedObjects = new MapMaker().weakKeys().weakValues().makeMap();

    public IokeRegistry(Runtime runtime) {
        this.runtime = runtime;
    }

    public static void makeWrapped(Object on, IokeObject wrapped, IokeObject context) {
        context.runtime.registry.makeWrapped(on, wrapped);
    }

    private void makeWrapped(Object on, IokeObject wrapped) {
        if (on != null && !(on instanceof Boolean)) {
            this.wrappedObjects.put(on, wrapped);
        }
    }

    public IokeObject wrap(Object on) {
        if (on == null) {
            return this.runtime.nil;
        }
        if (on instanceof Boolean) {
            return (Boolean)on != false ? this.runtime._true : this.runtime._false;
        }
        if (!this.wrappedObjects.containsKey(on)) {
            IokeObject val = this.runtime.createJavaWrapper(on);
            this.wrappedObjects.put(on, val);
            return val;
        }
        return this.wrappedObjects.get(on);
    }

    public IokeObject integratedWrap(Class on) {
        if (on == null) {
            return this.runtime.nil;
        }
        if (!this.wrappedObjects.containsKey(on)) {
            IokeObject val = this.runtime.createIntegratedJavaWrapper(on);
            this.wrappedObjects.put(on, val);
            return val;
        }
        return this.wrappedObjects.get(on);
    }

    public boolean isWrapped(Object on) {
        return this.wrappedObjects.containsKey(on);
    }

    public static boolean isWrapped(Object on, IokeObject context) {
        return context.runtime.registry.isWrapped(on);
    }

    public static IokeObject wrap(Object on, IokeObject context) {
        return context.runtime.registry.wrap(on);
    }

    public static IokeObject integratedWrap(Class on, IokeObject context) {
        return context.runtime.registry.integratedWrap(on);
    }

    private static interface Creator {
        public IokeObject create(Object var1);
    }
}

