/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.Builtin;
import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.IokeData;
import ioke.lang.IokeIO;
import ioke.lang.IokeList;
import ioke.lang.IokeObject;
import ioke.lang.Message;
import ioke.lang.NativeMethod;
import ioke.lang.Number;
import ioke.lang.Restart;
import ioke.lang.RunnableWithControlFlow;
import ioke.lang.Runtime;
import ioke.lang.Text;
import ioke.lang.exceptions.ControlFlow;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IokeSystem
extends IokeData {
    public static final Collection<String> FEATURES = new HashSet<String>(Arrays.asList("java"));
    private List<String> currentFile = new ArrayList<String>(Arrays.asList("<init>"));
    private String currentProgram;
    private String currentWorkingDirectory;
    private Set<String> loaded = new HashSet<String>();
    private List<AtExitInfo> atExit = new ArrayList<AtExitInfo>();
    private IokeObject loadPath;
    private IokeObject programArguments;
    private Random random = new Random();
    private static final String userHome = System.getProperty("user.home");
    private static final String[] SUFFIXES = new String[]{".ik", ".jar"};
    private static final String[] SUFFIXES_WITH_BLANK = new String[]{"", ".ik", ".jar"};
    public static final boolean DOSISH = System.getProperty("os.name").indexOf("Windows") != -1;
    public static final boolean WINDOWS_SEVEN = System.getProperty("os.name").equals("Windows 7");

    public static String withReplacedHomeDirectory(String input) {
        return DOSISH && input.contains("~/") ? userHome + "\\" + input.replaceAll("~/", "") : input.replaceAll("^~", userHome);
    }

    public void pushCurrentFile(String filename) {
        this.currentFile.add(0, filename);
    }

    public static List<AtExitInfo> getAtExits(Object on) {
        return ((IokeSystem)IokeObject.data((Object)on)).atExit;
    }

    public String popCurrentFile() {
        return this.currentFile.remove(0);
    }

    public String currentFile() {
        return this.currentFile.get(0);
    }

    public String currentProgram() {
        return this.currentProgram;
    }

    public void setCurrentProgram(String currentProgram) {
        this.currentProgram = currentProgram;
    }

    public void setCurrentWorkingDirectory(String cwd) {
        this.currentWorkingDirectory = cwd;
    }

    public String getCurrentWorkingDirectory() {
        return this.currentWorkingDirectory;
    }

    public void addLoadPath(String newPath) {
        IokeList.getList(this.loadPath).add(this.loadPath.runtime.newText(newPath));
    }

    public void addArgument(String newArgument) {
        IokeList.getList(this.programArguments).add(this.programArguments.runtime.newText(newArgument));
    }

    public static boolean isAbsoluteFileName(String name) {
        if (DOSISH) {
            return name.length() > 2 && name.charAt(1) == ':' && name.charAt(2) == '\\';
        }
        return name.length() > 0 && name.charAt(0) == '/';
    }

    public boolean use(IokeObject self, IokeObject context, IokeObject message, String name, boolean forceReload) throws ControlFlow {
        String[] suffixes;
        Runtime runtime;
        block33: {
            runtime = context.runtime;
            Builtin b = context.runtime.getBuiltin(name);
            if (b != null) {
                if (!forceReload && this.loaded.contains(name)) {
                    return false;
                }
                try {
                    b.load(context.runtime, context, message);
                    if (!forceReload) {
                        this.loaded.add(name);
                    }
                    return true;
                }
                catch (Throwable e) {
                    IokeObject condition = IokeObject.as(IokeObject.getCellChain(runtime.condition, message, context, "Error", "Load"), context).mimic(message, context);
                    condition.setCell("message", message);
                    condition.setCell("context", context);
                    condition.setCell("receiver", self);
                    condition.setCell("moduleName", runtime.newText(name));
                    condition.setCell("exceptionMessage", runtime.newText(e.getMessage()));
                    ArrayList<Object> ob = new ArrayList<Object>();
                    for (StackTraceElement ste : e.getStackTrace()) {
                        ob.add(runtime.newText(ste.toString()));
                    }
                    condition.setCell("exceptionStackTrace", runtime.newList(ob));
                    boolean[] continueLoadChain = new boolean[]{false};
                    runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

                        public void run() throws ControlFlow {
                            runtime.errorCondition(condition);
                        }
                    }, context, new Restart.ArgumentGivingRestart("continueLoadChain"){

                        @Override
                        public List<String> getArgumentNames() {
                            return new ArrayList<String>();
                        }

                        @Override
                        public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                            continueLoadChain[0] = true;
                            return runtime.nil;
                        }
                    }, new Restart.ArgumentGivingRestart("ignoreLoadError"){

                        @Override
                        public List<String> getArgumentNames() {
                            return new ArrayList<String>();
                        }

                        @Override
                        public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                            continueLoadChain[0] = false;
                            return runtime.nil;
                        }
                    });
                    if (continueLoadChain[0]) break block33;
                    return false;
                }
            }
        }
        List<Object> paths = ((IokeList)IokeObject.data(this.loadPath)).getList();
        for (String suffix : suffixes = name.endsWith(".ik") || name.endsWith(".jar") ? SUFFIXES_WITH_BLANK : SUFFIXES) {
            String before = "/";
            if (name.startsWith("/")) {
                before = "";
            }
            InputStream is = IokeSystem.class.getResourceAsStream(before + name + suffix);
            try {
                File f = new File(name + suffix);
                if (f.exists() && f.isFile()) {
                    if (!forceReload && this.loaded.contains(f.getCanonicalPath())) {
                        return false;
                    }
                    if (f.getCanonicalPath().endsWith(".jar")) {
                        context.runtime.classRegistry.getClassLoader().addURL(f.toURI().toURL());
                    } else {
                        context.runtime.evaluateFile(f, message, context);
                    }
                    if (!forceReload) {
                        this.loaded.add(f.getCanonicalPath());
                    }
                    return true;
                }
                if (null == is) continue;
                if (!forceReload && this.loaded.contains(name + suffix)) {
                    return false;
                }
                if (!(name + suffix).endsWith(".jar")) {
                    context.runtime.evaluateStream(name + suffix, new InputStreamReader(is, "UTF-8"), message, context);
                }
                if (!forceReload) {
                    this.loaded.add(name + suffix);
                }
                return true;
            }
            catch (Throwable e) {
                IokeObject condition = IokeObject.as(IokeObject.getCellChain(runtime.condition, message, context, "Error", "Load"), context).mimic(message, context);
                condition.setCell("message", message);
                condition.setCell("context", context);
                condition.setCell("receiver", self);
                condition.setCell("moduleName", runtime.newText(name));
                condition.setCell("exceptionMessage", runtime.newText(e.getMessage()));
                ArrayList<Object> ob = new ArrayList<Object>();
                for (StackTraceElement ste : e.getStackTrace()) {
                    ob.add(runtime.newText(ste.toString()));
                }
                condition.setCell("exceptionStackTrace", runtime.newList(ob));
                boolean[] continueLoadChain = new boolean[]{false};
                runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

                    public void run() throws ControlFlow {
                        runtime.errorCondition(condition);
                    }
                }, context, new Restart.ArgumentGivingRestart("continueLoadChain"){

                    @Override
                    public List<String> getArgumentNames() {
                        return new ArrayList<String>();
                    }

                    @Override
                    public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                        continueLoadChain[0] = true;
                        return runtime.nil;
                    }
                }, new Restart.ArgumentGivingRestart("ignoreLoadError"){

                    @Override
                    public List<String> getArgumentNames() {
                        return new ArrayList<String>();
                    }

                    @Override
                    public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                        continueLoadChain[0] = false;
                        return runtime.nil;
                    }
                });
                if (continueLoadChain[0]) continue;
                return false;
            }
        }
        for (Object o : paths) {
            String currentS = Text.getText(o);
            for (String suffix : suffixes) {
                String before = "/";
                if (name.startsWith("/")) {
                    before = "";
                }
                InputStream is = IokeSystem.class.getResourceAsStream(before + name + suffix);
                try {
                    File f = IokeSystem.isAbsoluteFileName(currentS) ? new File(currentS, name + suffix) : new File(new File(this.currentWorkingDirectory, currentS), name + suffix);
                    if (f.exists() && f.isFile()) {
                        if (!forceReload && this.loaded.contains(f.getCanonicalPath())) {
                            return false;
                        }
                        if (f.getCanonicalPath().endsWith(".jar")) {
                            context.runtime.classRegistry.getClassLoader().addURL(f.toURI().toURL());
                        } else {
                            context.runtime.evaluateFile(f, message, context);
                        }
                        if (!forceReload) {
                            this.loaded.add(f.getCanonicalPath());
                        }
                        return true;
                    }
                    if (null == is) continue;
                    if (!forceReload && this.loaded.contains(name + suffix)) {
                        return false;
                    }
                    if (!(name + suffix).endsWith(".jar")) {
                        context.runtime.evaluateStream(name + suffix, new InputStreamReader(is, "UTF-8"), message, context);
                    }
                    if (!forceReload) {
                        this.loaded.add(name + suffix);
                    }
                    return true;
                }
                catch (Throwable e) {
                    IokeObject condition = IokeObject.as(IokeObject.getCellChain(runtime.condition, message, context, "Error", "Load"), context).mimic(message, context);
                    condition.setCell("message", message);
                    condition.setCell("context", context);
                    condition.setCell("receiver", self);
                    condition.setCell("moduleName", runtime.newText(name));
                    condition.setCell("exceptionMessage", runtime.newText(e.getMessage()));
                    ArrayList<Object> ob = new ArrayList<Object>();
                    for (StackTraceElement ste : e.getStackTrace()) {
                        ob.add(runtime.newText(ste.toString()));
                    }
                    condition.setCell("exceptionStackTrace", runtime.newList(ob));
                    boolean[] continueLoadChain = new boolean[]{false};
                    runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

                        public void run() throws ControlFlow {
                            runtime.errorCondition(condition);
                        }
                    }, context, new Restart.ArgumentGivingRestart("continueLoadChain"){

                        @Override
                        public List<String> getArgumentNames() {
                            return new ArrayList<String>();
                        }

                        @Override
                        public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                            continueLoadChain[0] = true;
                            return runtime.nil;
                        }
                    }, new Restart.ArgumentGivingRestart("ignoreLoadError"){

                        @Override
                        public List<String> getArgumentNames() {
                            return new ArrayList<String>();
                        }

                        @Override
                        public IokeObject invoke(IokeObject context, List<Object> arguments) throws ControlFlow {
                            continueLoadChain[0] = false;
                            return runtime.nil;
                        }
                    });
                    if (continueLoadChain[0]) continue;
                    return false;
                }
            }
        }
        IokeObject condition = IokeObject.as(IokeObject.getCellChain(runtime.condition, message, context, "Error", "Load"), context).mimic(message, context);
        condition.setCell("message", message);
        condition.setCell("context", context);
        condition.setCell("receiver", self);
        condition.setCell("moduleName", runtime.newText(name));
        runtime.withReturningRestart("ignoreLoadError", context, new RunnableWithControlFlow(){

            public void run() throws ControlFlow {
                runtime.errorCondition(condition);
            }
        });
        return false;
    }

    @Override
    public IokeData cloneData(IokeObject obj, IokeObject m, IokeObject context) {
        return new IokeSystem();
    }

    @Override
    public void init(IokeObject obj) throws ControlFlow {
        Runtime runtime = obj.runtime;
        obj.setKind("System");
        if (this.currentWorkingDirectory == null) {
            try {
                this.currentWorkingDirectory = new File(".").getCanonicalPath();
            }
            catch (Exception e) {
                this.currentWorkingDirectory = ".";
            }
        }
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(runtime.newText("."));
        this.loadPath = runtime.newList(l);
        this.programArguments = runtime.newList(new ArrayList<Object>());
        IokeObject outx = runtime.io.mimic(null, null);
        outx.setData(new IokeIO(runtime.out));
        obj.registerCell("out", outx);
        IokeObject errx = runtime.io.mimic(null, null);
        errx.setData(new IokeIO(runtime.err));
        obj.registerCell("err", errx);
        IokeObject inx = runtime.io.mimic(null, null);
        inx.setData(new IokeIO(runtime.in));
        obj.registerCell("in", inx);
        obj.registerCell("currentDebugger", runtime.nil);
        obj.registerMethod(runtime.newNativeMethod("takes one text or symbol argument and returns a boolean indicating whether the named feature is available on this runtime.", new NativeMethod("feature?"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositional("feature").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                ArrayList<Object> args = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                String name = Text.getText(((Message)IokeObject.data(runtime.asText)).sendTo(runtime.asText, context, args.get(0)));
                if (FEATURES.contains(name)) {
                    return runtime._true;
                }
                return runtime._false;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns the current file executing", new NativeMethod.WithNoArguments("currentFile"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return runtime.newText((String)((IokeSystem)IokeObject.data(on)).currentFile.get(0));
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns true if running on windows, otherwise false", new NativeMethod.WithNoArguments("windows?"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return DOSISH ? runtime._true : runtime._false;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns the current load path", new NativeMethod.WithNoArguments("loadPath"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return ((IokeSystem)IokeObject.data(on)).loadPath;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns a random number", new NativeMethod.WithNoArguments("randomNumber"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return context.runtime.newNumber(((IokeSystem)IokeObject.data(on)).random.nextInt());
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns the current directory that the code is executing in", new NativeMethod.WithNoArguments("currentDirectory"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                String name = Message.file(message);
                File f = null;
                f = IokeSystem.isAbsoluteFileName(name) ? new File(name) : new File(context.runtime.getCurrentWorkingDirectory(), name);
                if (f.exists() && f.isFile()) {
                    return context.runtime.newText(f.getParent());
                }
                return context.runtime.nil;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns the current working directory", new NativeMethod.WithNoArguments("currentWorkingDirectory"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return context.runtime.newText(context.runtime.getCurrentWorkingDirectory());
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns the host name of the local machine", new NativeMethod.WithNoArguments("hostName"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                String tt;
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                try {
                    tt = InetAddress.getLocalHost().getHostName();
                }
                catch (Exception e) {
                    tt = "localhost";
                }
                return runtime.newText(tt);
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("forcibly exits the currently running interpreter. takes one optional argument that defaults to 1 - which is the value to return from the process, if the process is exited.", new NativeMethod("exit"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withOptionalPositional("other", "1").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                ArrayList<Object> args = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                int val = 1;
                if (args.size() > 0) {
                    Object arg = args.get(0);
                    val = arg == context.runtime._true ? 0 : (arg == context.runtime._false ? 1 : Number.extractInt(arg, message, context));
                }
                throw new ControlFlow.Exit(val);
            }
        }));
        obj.registerCell("programArguments", this.programArguments);
        obj.registerMethod(runtime.newNativeMethod("returns result of evaluating first argument", new NativeMethod("ifMain"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositionalUnevaluated("code").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                if (((IokeSystem)IokeObject.data(on)).currentProgram().equals(message.getFile())) {
                    IokeObject msg = (IokeObject)message.getArguments().get(0);
                    return ((Message)IokeObject.data(msg)).evaluateCompleteWith(msg, context, context.getRealContext());
                }
                return runtime.nil;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("adds a new piece of code that should be executed on exit", new NativeMethod("atExit"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositionalUnevaluated("code").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                IokeSystem.getAtExits(on).add(new AtExitInfo(context, IokeObject.as(message.getArguments().get(0), context)));
                return context.runtime.nil;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("takes one evaluated string argument and a boolean of whether loading should be forced or not. will import the file corresponding to the string based on the Ioke loading behavior", new NativeMethod("lowLevelLoad!"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositional("module").withRequiredPositional("forceReload").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                ArrayList<Object> args = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                boolean forceReload = IokeObject.isTrue(args.get(1));
                String name = Text.getText(((Message)IokeObject.data(runtime.asText)).sendTo(runtime.asText, context, args.get(0)));
                if (((IokeSystem)IokeObject.data(runtime.system)).use(IokeObject.as(on, context), context, message, name, forceReload)) {
                    return runtime._true;
                }
                return runtime._false;
            }
        }));
    }

    public String toString() {
        return "System";
    }

    public static class AtExitInfo {
        public final IokeObject context;
        public final IokeObject message;

        public AtExitInfo(IokeObject context, IokeObject message) {
            this.context = context;
            this.message = message;
        }
    }
}

