/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.AssociatedCode;
import ioke.lang.Decimal;
import ioke.lang.Dict;
import ioke.lang.IokeList;
import ioke.lang.IokeObject;
import ioke.lang.JavaWrapper;
import ioke.lang.Message;
import ioke.lang.Number;
import ioke.lang.Restart;
import ioke.lang.RunnableWithControlFlow;
import ioke.lang.Symbol;
import ioke.lang.Text;
import ioke.lang.exceptions.ControlFlow;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaArgumentsDefinition {
    private Class[][] parameterTypes;
    private Member[] members;
    private int min;
    private int max;
    private boolean special;

    public JavaArgumentsDefinition(Member[] members, Class[][] parameterTypes, int min, int max) {
        this(members, parameterTypes, min, max, false);
    }

    public JavaArgumentsDefinition(Member[] members, Class[][] parameterTypes, int min, int max, boolean special) {
        this.members = members;
        this.parameterTypes = parameterTypes;
        this.min = min;
        this.max = max;
        this.special = special;
    }

    private static void sortByParameterOrdering(Method[] m) {
        Arrays.sort(m, new MethodComparator());
    }

    private static void sortByParameterOrdering(Constructor[] m) {
        Arrays.sort(m, new ConstructorComparator());
    }

    public static JavaArgumentsDefinition createFrom(Method[] m) {
        JavaArgumentsDefinition.sortByParameterOrdering(m);
        Class[][] params = new Class[m.length][];
        int ix = 0;
        int min = -1;
        int max = -1;
        for (Method ms : m) {
            params[ix++] = ms.getParameterTypes();
            int num = params[ix - 1].length;
            if (min == -1 || num < min) {
                min = num;
            }
            if (max != -1 && num <= max) continue;
            max = num;
        }
        return new JavaArgumentsDefinition(m, params, min, max);
    }

    public static JavaArgumentsDefinition createFrom(Constructor[] m, boolean special) {
        JavaArgumentsDefinition.sortByParameterOrdering(m);
        Class[][] params = new Class[m.length][];
        int ix = 0;
        int min = -1;
        int max = -1;
        for (Constructor ms : m) {
            params[ix++] = ms.getParameterTypes();
            int num = params[ix - 1].length;
            if (min == -1 || num < min) {
                min = num;
            }
            if (max != -1 && num <= max) continue;
            max = num;
        }
        return new JavaArgumentsDefinition(m, params, min, max, special);
    }

    public static JavaArgumentsDefinition createFrom(Field f) {
        Class[][] params = new Class[1][0];
        params[0] = new Class[]{f.getType()};
        return new JavaArgumentsDefinition(new Field[]{f}, params, 1, 1);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Member getJavaArguments(IokeObject context, IokeObject message, Object on, List<Object> args) throws ControlFlow {
        runtime = context.runtime;
        arguments = message.getArguments();
        resultArguments = new ArrayList<JavaArgumentDefinition>(arguments.size());
        argCount = 0;
        for (Object o : arguments) {
            if (Message.isKeyword(o)) continue;
            if (Message.hasName(o, "*") && IokeObject.as(o, context).getArguments().size() == 1) {
                result = Message.getEvaluatedArgument(IokeObject.as(o, context).getArguments().get(0), context);
                if (IokeObject.data(result) instanceof IokeList) {
                    elements = IokeList.getList(result);
                    for (Object oe : elements) {
                        resultArguments.add(new JavaArgumentDefinition(null, null, oe));
                    }
                    argCount += elements.size();
                    continue;
                }
                if (IokeObject.data(result) instanceof Dict) continue;
                condition = IokeObject.as(IokeObject.getCellChain(runtime.condition, message, context, new String[]{"Error", "Invocation", "NotSpreadable"}), context).mimic(message, context);
                condition.setCell("message", message);
                condition.setCell("context", context);
                condition.setCell("receiver", on);
                condition.setCell("given", result);
                outp = IokeList.getList(runtime.withRestartReturningArguments(new RunnableWithControlFlow(){

                    public void run() throws ControlFlow {
                        runtime.errorCondition(condition);
                    }
                }, context, new Restart.JavaRestart[]{new Restart.DefaultValuesGivingRestart("ignoreArgument", runtime.nil, 0), new Restart.DefaultValuesGivingRestart("takeArgumentAsIs", IokeObject.as(result, context), 1)}));
                for (Object oe : outp) {
                    resultArguments.add(new JavaArgumentDefinition(null, null, oe));
                }
                argCount += outp.size();
                continue;
            }
            if (Message.hasName(o, "") && IokeObject.as(o, context).getArguments().size() == 1) {
                m = IokeObject.as(o, context).getArguments().get(0);
                name = Message.name(m).intern();
                result = Message.getEvaluatedArgument(Message.next(o), context);
                into /* !! */  = null;
                alt /* !! */  = null;
                if (name == "Object") {
                    into /* !! */  = Object.class;
                } else if (name == "String") {
                    into /* !! */  = String.class;
                } else if (name == "Class") {
                    into /* !! */  = Class.class;
                } else if (name == "int" || name == "integer") {
                    into /* !! */  = Integer.TYPE;
                    alt /* !! */  = Integer.class;
                } else if (name == "short") {
                    into /* !! */  = Short.TYPE;
                    alt /* !! */  = Short.class;
                } else if (name == "byte") {
                    into /* !! */  = Byte.TYPE;
                    alt /* !! */  = Byte.class;
                } else if (name == "boolean") {
                    into /* !! */  = Boolean.TYPE;
                    alt /* !! */  = Boolean.class;
                } else if (name == "char" || name == "character") {
                    into /* !! */  = Character.TYPE;
                    alt /* !! */  = Character.class;
                } else if (name == "long") {
                    into /* !! */  = Long.TYPE;
                    alt /* !! */  = Long.class;
                } else if (name == "float") {
                    into /* !! */  = Float.TYPE;
                    alt /* !! */  = Float.class;
                } else if (name == "double") {
                    into /* !! */  = Double.TYPE;
                    alt /* !! */  = Double.class;
                } else {
                    s = name.replaceAll(":", ".");
                    try {
                        into /* !! */  = Class.forName(s, true, context.runtime.classRegistry.getClassLoader());
                    }
                    catch (Exception e) {
                        into /* !! */  = null;
                    }
                }
                if (into /* !! */  != null) {
                    dimensions = 0;
                    next = Message.next(m);
                    while (next != null && next.getName().equals("[]")) {
                        ++dimensions;
                        next = Message.next(next);
                    }
                    if (dimensions > 0) {
                        ds = new int[dimensions];
                        into /* !! */  = Array.newInstance(into /* !! */ , ds).getClass();
                        alt /* !! */  = null;
                    }
                }
                resultArguments.add(new JavaArgumentDefinition(into /* !! */ , alt /* !! */ , result));
                ++argCount;
                continue;
            }
            jarg = new JavaArgumentDefinition(null, null, val, (val = Message.getEvaluatedArgument(o, context)) instanceof IokeObject != false && IokeObject.data(val) instanceof AssociatedCode != false);
            resultArguments.add(jarg);
            ++argCount;
        }
        i = 0;
        if (this.special) {
            ++argCount;
        }
        j = this.parameterTypes.length;
        block8: while (i < j) {
            if (this.parameterTypes[i].length != argCount) ** GOTO lbl439
            current = this.parameterTypes[i];
            kpar = this.special != false ? 1 : 0;
            karg = 0;
            while (kpar < argCount) {
                block50: {
                    block49: {
                        block111: {
                            block109: {
                                block110: {
                                    block108: {
                                        block104: {
                                            block107: {
                                                block106: {
                                                    block105: {
                                                        block103: {
                                                            block102: {
                                                                block96: {
                                                                    block101: {
                                                                        block100: {
                                                                            block99: {
                                                                                block98: {
                                                                                    block97: {
                                                                                        block90: {
                                                                                            block95: {
                                                                                                block94: {
                                                                                                    block93: {
                                                                                                        block92: {
                                                                                                            block91: {
                                                                                                                block84: {
                                                                                                                    block89: {
                                                                                                                        block88: {
                                                                                                                            block87: {
                                                                                                                                block86: {
                                                                                                                                    block85: {
                                                                                                                                        block79: {
                                                                                                                                            block83: {
                                                                                                                                                block82: {
                                                                                                                                                    block81: {
                                                                                                                                                        block80: {
                                                                                                                                                            block74: {
                                                                                                                                                                block78: {
                                                                                                                                                                    block77: {
                                                                                                                                                                        block76: {
                                                                                                                                                                            block75: {
                                                                                                                                                                                block69: {
                                                                                                                                                                                    block73: {
                                                                                                                                                                                        block72: {
                                                                                                                                                                                            block71: {
                                                                                                                                                                                                block70: {
                                                                                                                                                                                                    block64: {
                                                                                                                                                                                                        block68: {
                                                                                                                                                                                                            block67: {
                                                                                                                                                                                                                block66: {
                                                                                                                                                                                                                    block65: {
                                                                                                                                                                                                                        block58: {
                                                                                                                                                                                                                            block63: {
                                                                                                                                                                                                                                block62: {
                                                                                                                                                                                                                                    block61: {
                                                                                                                                                                                                                                        block60: {
                                                                                                                                                                                                                                            block59: {
                                                                                                                                                                                                                                                block52: {
                                                                                                                                                                                                                                                    block57: {
                                                                                                                                                                                                                                                        block56: {
                                                                                                                                                                                                                                                            block55: {
                                                                                                                                                                                                                                                                block54: {
                                                                                                                                                                                                                                                                    block53: {
                                                                                                                                                                                                                                                                        block51: {
                                                                                                                                                                                                                                                                            clz = current[kpar];
                                                                                                                                                                                                                                                                            jad = (JavaArgumentDefinition)resultArguments.get(karg);
                                                                                                                                                                                                                                                                            obj = jad.obj;
                                                                                                                                                                                                                                                                            isIokeObject = obj instanceof IokeObject;
                                                                                                                                                                                                                                                                            isWrapper = isIokeObject != false && IokeObject.data(obj) instanceof JavaWrapper != false;
                                                                                                                                                                                                                                                                            isExplicitCast = jad.type != null;
                                                                                                                                                                                                                                                                            v0 = clzIsAbstract = Modifier.isAbstract(clz.getModifiers()) != false || clz.isInterface() != false;
                                                                                                                                                                                                                                                                            if (!isExplicitCast || clz == jad.type || clz == jad.altType) break block51;
                                                                                                                                                                                                                                                                            args.clear();
                                                                                                                                                                                                                                                                            break block50;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (clz != String.class) break block52;
                                                                                                                                                                                                                                                                        if (!(obj instanceof String)) break block53;
                                                                                                                                                                                                                                                                        args.add(obj);
                                                                                                                                                                                                                                                                        break block49;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    if (!isWrapper || !(JavaWrapper.getObject(obj) instanceof String)) break block54;
                                                                                                                                                                                                                                                                    args.add(JavaWrapper.getObject(obj));
                                                                                                                                                                                                                                                                    break block49;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                if (!isIokeObject || !(IokeObject.data(obj) instanceof Text)) break block55;
                                                                                                                                                                                                                                                                args.add(Text.getText(obj));
                                                                                                                                                                                                                                                                break block49;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            if (!isIokeObject || !(IokeObject.data(obj) instanceof Symbol)) break block56;
                                                                                                                                                                                                                                                            args.add(Symbol.getText(obj));
                                                                                                                                                                                                                                                            break block49;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        if (obj != runtime.nil) break block57;
                                                                                                                                                                                                                                                        args.add(null);
                                                                                                                                                                                                                                                        break block49;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    args.clear();
                                                                                                                                                                                                                                                    break block50;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                if (clz != Character.class && clz != Character.TYPE) break block58;
                                                                                                                                                                                                                                                if (!(obj instanceof Character)) break block59;
                                                                                                                                                                                                                                                args.add(obj);
                                                                                                                                                                                                                                                break block49;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (!isWrapper || !(JavaWrapper.getObject(obj) instanceof Character)) break block60;
                                                                                                                                                                                                                                            args.add(JavaWrapper.getObject(obj));
                                                                                                                                                                                                                                            break block49;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (!isIokeObject || !(IokeObject.data(obj) instanceof Number)) break block61;
                                                                                                                                                                                                                                        args.add(new Character((char)Number.intValue(obj).intValue()));
                                                                                                                                                                                                                                        break block49;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (!isIokeObject || !(IokeObject.data(obj) instanceof Text) || Text.getText(obj).length() != 1) break block62;
                                                                                                                                                                                                                                    args.add(new Character(Text.getText(obj).charAt(0)));
                                                                                                                                                                                                                                    break block49;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (clz.isPrimitive() || obj != runtime.nil) break block63;
                                                                                                                                                                                                                                args.add(null);
                                                                                                                                                                                                                                break block49;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            args.clear();
                                                                                                                                                                                                                            break block50;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (clz != Integer.class && clz != Integer.TYPE) break block64;
                                                                                                                                                                                                                        if (!(obj instanceof Integer)) break block65;
                                                                                                                                                                                                                        args.add(obj);
                                                                                                                                                                                                                        break block49;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (!isWrapper || !(JavaWrapper.getObject(obj) instanceof Integer)) break block66;
                                                                                                                                                                                                                    args.add(JavaWrapper.getObject(obj));
                                                                                                                                                                                                                    break block49;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (!isIokeObject || !(IokeObject.data(obj) instanceof Number)) break block67;
                                                                                                                                                                                                                args.add(Number.intValue(obj).intValue());
                                                                                                                                                                                                                break block49;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (clz.isPrimitive() || obj != runtime.nil) break block68;
                                                                                                                                                                                                            args.add(null);
                                                                                                                                                                                                            break block49;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        args.clear();
                                                                                                                                                                                                        break block50;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (clz != Short.class && clz != Short.TYPE) break block69;
                                                                                                                                                                                                    if (!(obj instanceof Short)) break block70;
                                                                                                                                                                                                    args.add(obj);
                                                                                                                                                                                                    break block49;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (!isWrapper || !(JavaWrapper.getObject(obj) instanceof Short)) break block71;
                                                                                                                                                                                                args.add(JavaWrapper.getObject(obj));
                                                                                                                                                                                                break block49;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (!isIokeObject || !(IokeObject.data(obj) instanceof Number)) break block72;
                                                                                                                                                                                            args.add((short)Number.intValue(obj).intValue());
                                                                                                                                                                                            break block49;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (clz.isPrimitive() || obj != runtime.nil) break block73;
                                                                                                                                                                                        args.add(null);
                                                                                                                                                                                        break block49;
                                                                                                                                                                                    }
                                                                                                                                                                                    args.clear();
                                                                                                                                                                                    break block50;
                                                                                                                                                                                }
                                                                                                                                                                                if (clz != Byte.class && clz != Byte.TYPE) break block74;
                                                                                                                                                                                if (!(obj instanceof Byte)) break block75;
                                                                                                                                                                                args.add(obj);
                                                                                                                                                                                break block49;
                                                                                                                                                                            }
                                                                                                                                                                            if (!isWrapper || !(JavaWrapper.getObject(obj) instanceof Byte)) break block76;
                                                                                                                                                                            args.add(JavaWrapper.getObject(obj));
                                                                                                                                                                            break block49;
                                                                                                                                                                        }
                                                                                                                                                                        if (!isIokeObject || !(IokeObject.data(obj) instanceof Number)) break block77;
                                                                                                                                                                        args.add((byte)Number.intValue(obj).intValue());
                                                                                                                                                                        break block49;
                                                                                                                                                                    }
                                                                                                                                                                    if (clz.isPrimitive() || obj != runtime.nil) break block78;
                                                                                                                                                                    args.add(null);
                                                                                                                                                                    break block49;
                                                                                                                                                                }
                                                                                                                                                                args.clear();
                                                                                                                                                                break block50;
                                                                                                                                                            }
                                                                                                                                                            if (clz != Long.class && clz != Long.TYPE) break block79;
                                                                                                                                                            if (!(obj instanceof Long)) break block80;
                                                                                                                                                            args.add(obj);
                                                                                                                                                            break block49;
                                                                                                                                                        }
                                                                                                                                                        if (!isWrapper || !(JavaWrapper.getObject(obj) instanceof Long)) break block81;
                                                                                                                                                        args.add(JavaWrapper.getObject(obj));
                                                                                                                                                        break block49;
                                                                                                                                                    }
                                                                                                                                                    if (!isIokeObject || !(IokeObject.data(obj) instanceof Number)) break block82;
                                                                                                                                                    args.add(Number.value(obj).longValue());
                                                                                                                                                    break block49;
                                                                                                                                                }
                                                                                                                                                if (clz.isPrimitive() || obj != runtime.nil) break block83;
                                                                                                                                                args.add(null);
                                                                                                                                                break block49;
                                                                                                                                            }
                                                                                                                                            args.clear();
                                                                                                                                            break block50;
                                                                                                                                        }
                                                                                                                                        if (clz != Float.class && clz != Float.TYPE) break block84;
                                                                                                                                        if (!(obj instanceof Float)) break block85;
                                                                                                                                        args.add(obj);
                                                                                                                                        break block49;
                                                                                                                                    }
                                                                                                                                    if (!isWrapper || !(JavaWrapper.getObject(obj) instanceof Float)) break block86;
                                                                                                                                    args.add(JavaWrapper.getObject(obj));
                                                                                                                                    break block49;
                                                                                                                                }
                                                                                                                                if (!isIokeObject || !(IokeObject.data(obj) instanceof Decimal)) break block87;
                                                                                                                                args.add(Float.valueOf(Decimal.value(obj).floatValue()));
                                                                                                                                break block49;
                                                                                                                            }
                                                                                                                            if (!isExplicitCast || !(IokeObject.data(obj) instanceof Number)) break block88;
                                                                                                                            args.add(Float.valueOf(Number.value(obj).intValue()));
                                                                                                                            break block49;
                                                                                                                        }
                                                                                                                        if (clz.isPrimitive() || obj != runtime.nil) break block89;
                                                                                                                        args.add(null);
                                                                                                                        break block49;
                                                                                                                    }
                                                                                                                    args.clear();
                                                                                                                    break block50;
                                                                                                                }
                                                                                                                if (clz != Double.class && clz != Double.TYPE) break block90;
                                                                                                                if (!(obj instanceof Double)) break block91;
                                                                                                                args.add(obj);
                                                                                                                break block49;
                                                                                                            }
                                                                                                            if (!isWrapper || !(JavaWrapper.getObject(obj) instanceof Double)) break block92;
                                                                                                            args.add(JavaWrapper.getObject(obj));
                                                                                                            break block49;
                                                                                                        }
                                                                                                        if (!isIokeObject || !(IokeObject.data(obj) instanceof Decimal)) break block93;
                                                                                                        args.add(Decimal.value(obj).doubleValue());
                                                                                                        break block49;
                                                                                                    }
                                                                                                    if (!isExplicitCast || !(IokeObject.data(obj) instanceof Number)) break block94;
                                                                                                    args.add(Number.value(obj).longValue());
                                                                                                    break block49;
                                                                                                }
                                                                                                if (clz.isPrimitive() || obj != runtime.nil) break block95;
                                                                                                args.add(null);
                                                                                                break block49;
                                                                                            }
                                                                                            args.clear();
                                                                                            break block50;
                                                                                        }
                                                                                        if (clz != Boolean.class && clz != Boolean.TYPE) break block96;
                                                                                        if (!(obj instanceof Boolean)) break block97;
                                                                                        args.add(obj);
                                                                                        break block49;
                                                                                    }
                                                                                    if (!isWrapper || !(JavaWrapper.getObject(obj) instanceof Boolean)) break block98;
                                                                                    args.add(JavaWrapper.getObject(obj));
                                                                                    break block49;
                                                                                }
                                                                                if (obj != runtime._true) break block99;
                                                                                args.add(Boolean.TRUE);
                                                                                break block49;
                                                                            }
                                                                            if (obj != runtime._false) break block100;
                                                                            args.add(Boolean.FALSE);
                                                                            break block49;
                                                                        }
                                                                        if (clz.isPrimitive() || obj != runtime.nil) break block101;
                                                                        args.add(null);
                                                                        break block49;
                                                                    }
                                                                    args.clear();
                                                                    break block50;
                                                                }
                                                                if (clz != IokeObject.class) break block102;
                                                                if (obj instanceof IokeObject) {
                                                                    args.add(obj);
                                                                }
                                                                break block49;
                                                            }
                                                            if (clz != Object.class) break block103;
                                                            if (obj == runtime.nil) {
                                                                args.add(null);
                                                            } else if (isWrapper) {
                                                                args.add(JavaWrapper.getObject(obj));
                                                            } else {
                                                                args.add(obj);
                                                            }
                                                            break block49;
                                                        }
                                                        if (!clz.isArray()) break block104;
                                                        if (obj != runtime.nil) break block105;
                                                        args.add(null);
                                                        break block49;
                                                    }
                                                    if (isIokeObject || !clz.isAssignableFrom(obj.getClass()) && !isExplicitCast) break block106;
                                                    args.add(obj);
                                                    break block49;
                                                }
                                                if (!isWrapper || !clz.isAssignableFrom(JavaWrapper.getObject(obj).getClass()) && !isExplicitCast) break block107;
                                                args.add(JavaWrapper.getObject(obj));
                                                break block49;
                                            }
                                            args.clear();
                                            break block50;
                                        }
                                        if (obj != runtime.nil) break block108;
                                        args.add(null);
                                        break block49;
                                    }
                                    if (isIokeObject) break block109;
                                    if (!clz.isInstance(obj)) break block110;
                                    args.add(obj);
                                    break block49;
                                }
                                args.clear();
                                break block50;
                            }
                            if (!isWrapper) break block111;
                            args.add(JavaWrapper.getObject(obj));
                            break block49;
                        }
                        if (jad.associatedCode && clzIsAbstract) {
                            try {
                                obj2 = ((Message)IokeObject.data(runtime.coerceIntoJavaCodeMessage)).sendTo(runtime.coerceIntoJavaCodeMessage, context, obj, runtime.registry.wrap(clz), JavaArgumentsDefinition.findAbstractMethodNames(clz, context));
                                if (obj2 instanceof IokeObject && IokeObject.data(obj2) instanceof JavaWrapper) {
                                    obj2 = JavaWrapper.getObject(obj2);
                                }
                                args.add(obj2);
                                break block49;
                            }
                            catch (ControlFlow e) {
                                args.clear();
                                break block50;
                            }
                        }
                        args.clear();
                        break block50;
                    }
                    ++kpar;
                    ++karg;
                    continue;
                }
                ++i;
                continue block8;
            }
            break block8;
        }
        if (i == this.members.length) {
            condition = IokeObject.as(IokeObject.getCellChain(runtime.condition, message, context, new String[]{"Error", "Java", "NoMatch"}), context).mimic(message, context);
            condition.setCell("message", message);
            condition.setCell("context", context);
            condition.setCell("receiver", on);
            tries = new ArrayList<Object>(this.members.length);
            for (Member o : this.members) {
                tries.add(runtime.newText(o.toString()));
            }
            condition.setCell("alternatives", runtime.newList(tries));
            argsGiven = new ArrayList<Object>();
            for (JavaArgumentDefinition jad : resultArguments) {
                argsGiven.add(jad.obj);
            }
            condition.setCell("given", runtime.newList(argsGiven));
            runtime.errorCondition(condition);
        }
        if (this.special) {
            args.add(0, on);
        }
        return this.members[i];
    }

    public static IokeObject findAbstractMethodNames(Class<?> type, IokeObject context) throws ControlFlow {
        ArrayList<Object> names = new ArrayList<Object>();
        for (Method m : type.getMethods()) {
            if (!Modifier.isAbstract(m.getModifiers())) continue;
            names.add(context.runtime.newText(m.getName()));
        }
        return context.runtime.newList(names);
    }

    private static class JavaArgumentDefinition {
        public final Class type;
        public final Class altType;
        public final Object obj;
        public final boolean associatedCode;

        public JavaArgumentDefinition(Class type, Class altType, Object obj) {
            this(type, altType, obj, false);
        }

        public JavaArgumentDefinition(Class type, Class altType, Object obj, boolean associatedCode) {
            this.type = type;
            this.altType = altType;
            this.obj = obj;
            this.associatedCode = associatedCode;
        }

        public String toString() {
            return "<JavaArgument type=" + this.type + ", alt=" + this.altType + ">";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstructorComparator
    extends FullOrdering
    implements Comparator<Constructor> {
        private ConstructorComparator() {
        }

        @Override
        public int compare(Constructor a, Constructor b) {
            Class<?>[] bTypes;
            Class<?>[] aTypes = a.getParameterTypes();
            if (aTypes.length != (bTypes = b.getParameterTypes()).length) {
                return aTypes.length - bTypes.length;
            }
            int j = aTypes.length;
            for (int i = 0; i < j; ++i) {
                int ret = this.ordering(aTypes[i], bTypes[i]);
                if (ret == 0) continue;
                return ret;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodComparator
    extends FullOrdering
    implements Comparator<Method> {
        private MethodComparator() {
        }

        @Override
        public int compare(Method a, Method b) {
            Class<?>[] bTypes;
            Class<?>[] aTypes = a.getParameterTypes();
            if (aTypes.length != (bTypes = b.getParameterTypes()).length) {
                return aTypes.length - bTypes.length;
            }
            int j = aTypes.length;
            for (int i = 0; i < j; ++i) {
                int ret = this.ordering(aTypes[i], bTypes[i]);
                if (ret == 0) continue;
                return ret;
            }
            return 0;
        }
    }

    private static class FullOrdering {
        private FullOrdering() {
        }

        protected int ordering(Class a, Class b) {
            if (a == b) {
                return 0;
            }
            if (a.isPrimitive() && b.isPrimitive()) {
                if (a == Integer.TYPE) {
                    if (b == Short.TYPE || b == Character.TYPE || b == Long.TYPE || b == Byte.TYPE) {
                        return -1;
                    }
                } else if (a == Short.TYPE) {
                    if (b == Long.TYPE || b == Integer.TYPE || b == Character.TYPE) {
                        return 1;
                    }
                    if (b == Byte.TYPE) {
                        return -1;
                    }
                } else if (a == Byte.TYPE) {
                    if (b == Short.TYPE || b == Long.TYPE || b == Integer.TYPE || b == Character.TYPE) {
                        return 1;
                    }
                } else if (a == Character.TYPE) {
                    if (b == Long.TYPE || b == Short.TYPE || b == Byte.TYPE) {
                        return -1;
                    }
                    if (b == Integer.TYPE) {
                        return 1;
                    }
                } else if (a == Long.TYPE) {
                    if (b == Short.TYPE || b == Byte.TYPE) {
                        return -1;
                    }
                    if (b == Integer.TYPE || b == Character.TYPE) {
                        return 1;
                    }
                } else if (a == Float.TYPE) {
                    if (b == Double.TYPE) {
                        return 1;
                    }
                } else if (a == Double.TYPE && b == Float.TYPE) {
                    return -1;
                }
            } else {
                if (b.isAssignableFrom(a)) {
                    return -1;
                }
                if (a.isAssignableFrom(b)) {
                    return 1;
                }
                if (a.isPrimitive()) {
                    return -1;
                }
                if (b.isPrimitive()) {
                    return 1;
                }
            }
            return 0;
        }
    }
}

