/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.IokeObject;
import ioke.lang.IokeRegistry;
import ioke.lang.JavaArgumentsDefinition;
import ioke.lang.JavaWrapper;
import ioke.lang.Method;
import ioke.lang.NativeImplementedMethod;
import ioke.lang.exceptions.ControlFlow;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaConstructorNativeMethod
extends Method
implements NativeImplementedMethod {
    private Constructor[] ctors;
    private JavaArgumentsDefinition arguments;
    private boolean special;

    public JavaConstructorNativeMethod(Constructor[] ctors, boolean special) {
        super("new");
        this.ctors = ctors;
        this.special = special;
        this.arguments = JavaArgumentsDefinition.createFrom(ctors, special);
    }

    public String getArgumentsCode() {
        return "...";
    }

    @Override
    public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
        LinkedList<Object> args = new LinkedList<Object>();
        Constructor ctor = (Constructor)this.arguments.getJavaArguments(context, message, on, args);
        return this.activate(self, on, args, ctor, context, message);
    }

    public Object activate(IokeObject self, Object on, List<Object> args, Constructor ctor, IokeObject context, IokeObject message) throws ControlFlow {
        try {
            if (!this.special) {
                return ctor.newInstance(args.toArray());
            }
            IokeObject other = IokeObject.mimic(on, message, context);
            Object[] aa = args.toArray();
            aa[0] = other;
            Object ret = ctor.newInstance(aa);
            JavaWrapper.setObject(other, ret);
            IokeRegistry.makeWrapped(ret, other, context);
            return other;
        }
        catch (Exception e) {
            System.err.print("woops: ");
            e.printStackTrace();
            return context.runtime.nil;
        }
    }

    @Override
    public String inspect(Object self) {
        return "method(" + this.ctors[0].getDeclaringClass().getName() + "_new)";
    }
}

