/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.IokeObject;
import ioke.lang.JavaWrapper;
import ioke.lang.Method;
import ioke.lang.NativeImplementedMethod;
import ioke.lang.exceptions.ControlFlow;
import java.lang.reflect.Field;

public class JavaFieldGetterNativeMethod
extends Method
implements NativeImplementedMethod {
    private Class declaringClass;
    private Field field;

    public JavaFieldGetterNativeMethod(Field field) {
        super(field.getName());
        this.field = field;
        this.declaringClass = field.getDeclaringClass();
    }

    public String getArgumentsCode() {
        return "...";
    }

    public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
        try {
            Object result;
            if (on instanceof IokeObject && IokeObject.data(on) instanceof JavaWrapper) {
                Object result2;
                Class<?> obj = ((JavaWrapper)IokeObject.data(on)).getObject();
                if (!this.declaringClass.isInstance(obj)) {
                    obj = obj.getClass();
                }
                if ((result2 = this.field.get(obj)) == null) {
                    return context.runtime.nil;
                }
                if (result2 instanceof Boolean) {
                    return (Boolean)result2 != false ? context.runtime._true : context.runtime._false;
                }
                return result2;
            }
            Class<?> obj = on;
            if (!this.declaringClass.isInstance(obj)) {
                obj = obj.getClass();
            }
            if ((result = this.field.get(obj)) == null) {
                return context.runtime.nil;
            }
            if (result instanceof Boolean) {
                return (Boolean)result != false ? context.runtime._true : context.runtime._false;
            }
            return result;
        }
        catch (Exception e) {
            context.runtime.reportNativeException(e, message, context);
            return context.runtime.nil;
        }
    }

    public String inspect(Object self) {
        return "method(" + this.declaringClass.getName() + "_" + this.field.getName() + ")";
    }
}

