/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.IokeObject;
import ioke.lang.JavaArgumentsDefinition;
import ioke.lang.JavaWrapper;
import ioke.lang.Method;
import ioke.lang.NativeImplementedMethod;
import ioke.lang.exceptions.ControlFlow;
import java.lang.reflect.Field;
import java.util.LinkedList;

public class JavaFieldSetterNativeMethod
extends Method
implements NativeImplementedMethod {
    private Class declaringClass;
    private Field field;
    private JavaArgumentsDefinition arguments;

    public JavaFieldSetterNativeMethod(Field field) {
        super(field.getName() + "=");
        this.field = field;
        this.declaringClass = field.getDeclaringClass();
        this.arguments = JavaArgumentsDefinition.createFrom(field);
    }

    public String getArgumentsCode() {
        return "...";
    }

    public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
        LinkedList<Object> args = new LinkedList<Object>();
        this.arguments.getJavaArguments(context, message, on, args);
        return this.activate(self, on, args.get(0), context, message);
    }

    public Object activate(IokeObject self, Object on, Object arg, IokeObject context, IokeObject message) throws ControlFlow {
        try {
            if (on instanceof IokeObject && IokeObject.data(on) instanceof JavaWrapper) {
                Class<?> obj = ((JavaWrapper)IokeObject.data(on)).getObject();
                if (!this.declaringClass.isInstance(obj)) {
                    obj = obj.getClass();
                }
                this.field.set(obj, arg);
                Object result = arg;
                if (result == null) {
                    return context.runtime.nil;
                }
                if (result instanceof Boolean) {
                    return (Boolean)result != false ? context.runtime._true : context.runtime._false;
                }
                return result;
            }
            Class<?> obj = on;
            if (!this.declaringClass.isInstance(obj)) {
                obj = obj.getClass();
            }
            this.field.set(obj, arg);
            Object result = arg;
            if (result == null) {
                return context.runtime.nil;
            }
            if (result instanceof Boolean) {
                return (Boolean)result != false ? context.runtime._true : context.runtime._false;
            }
            return result;
        }
        catch (Exception e) {
            context.runtime.reportNativeException(e, message, context);
            return context.runtime.nil;
        }
    }

    public String inspect(Object self) {
        return "method(" + this.declaringClass.getName() + "_" + this.field.getName() + "=)";
    }
}

