/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.IokeObject;
import ioke.lang.JavaArgumentsDefinition;
import ioke.lang.JavaWrapper;
import ioke.lang.Method;
import ioke.lang.NativeImplementedMethod;
import ioke.lang.exceptions.ControlFlow;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethodNativeMethod
extends Method
implements NativeImplementedMethod {
    private Class declaringClass;
    private java.lang.reflect.Method[] methods;
    private JavaArgumentsDefinition arguments;

    public JavaMethodNativeMethod(java.lang.reflect.Method[] methods) {
        super(methods[0].getName());
        this.methods = methods;
        this.declaringClass = methods[0].getDeclaringClass();
        this.arguments = JavaArgumentsDefinition.createFrom(methods);
    }

    public String getArgumentsCode() {
        return "...";
    }

    @Override
    public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
        LinkedList<Object> args = new LinkedList<Object>();
        java.lang.reflect.Method method = (java.lang.reflect.Method)this.arguments.getJavaArguments(context, message, on, args);
        return this.activate(self, on, args, method, context, message);
    }

    public Object activate(IokeObject self, Object on, List<Object> args, java.lang.reflect.Method method, IokeObject context, IokeObject message) throws ControlFlow {
        try {
            Object result;
            if (on instanceof IokeObject && IokeObject.data(on) instanceof JavaWrapper) {
                Object result2;
                Class<?> obj = ((JavaWrapper)IokeObject.data(on)).getObject();
                if (!this.declaringClass.isInstance(obj)) {
                    obj = obj.getClass();
                }
                if ((result2 = method.invoke(obj, args.toArray())) == null) {
                    return context.runtime.nil;
                }
                if (result2 instanceof Boolean) {
                    return (Boolean)result2 != false ? context.runtime._true : context.runtime._false;
                }
                return result2;
            }
            Class<?> obj = on;
            if (!this.declaringClass.isInstance(obj)) {
                obj = obj.getClass();
            }
            if ((result = method.invoke(obj, args.toArray())) == null) {
                return context.runtime.nil;
            }
            if (result instanceof Boolean) {
                return (Boolean)result != false ? context.runtime._true : context.runtime._false;
            }
            return result;
        }
        catch (Exception e) {
            if ((Exception)e.getCause() != null) {
                context.runtime.reportNativeException((Exception)e.getCause(), message, context);
            } else {
                context.runtime.reportNativeException(e, message, context);
            }
            return context.runtime.nil;
        }
    }

    @Override
    public String inspect(Object self) {
        return "method(" + this.methods[0].getDeclaringClass().getName() + "_" + this.methods[0].getName() + ")";
    }
}

