/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.IokeData;
import ioke.lang.IokeObject;
import ioke.lang.NativeMethod;
import ioke.lang.Runtime;
import ioke.lang.exceptions.ControlFlow;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaWrapper
extends IokeData {
    private Object object;
    private String kind;
    private Class clazz;

    public JavaWrapper() {
        this.object = null;
    }

    public JavaWrapper(Object object) {
        this.object = object;
        this.clazz = this.object.getClass();
        this.kind = this.clazz.getName().replaceAll("\\.", ":");
    }

    public static Object getObject(Object wrapped) {
        return ((JavaWrapper)IokeObject.data((Object)wrapped)).object;
    }

    public static void setObject(Object wrapped, Object obj) {
        JavaWrapper jw = (JavaWrapper)IokeObject.data(wrapped);
        jw.object = obj;
        jw.clazz = jw.object.getClass();
        jw.kind = jw.clazz.getName().replaceAll("\\.", ":");
    }

    public static JavaWrapper wrapWithMethods(Class<?> clz, IokeObject obj, Runtime runtime) {
        return JavaWrapper.wrapWithMethods(clz, obj, runtime, false);
    }

    @Override
    public IokeData cloneData(IokeObject obj, IokeObject m, IokeObject context) {
        return this.object == null ? new JavaWrapper() : new JavaWrapper(this.object);
    }

    public static JavaWrapper wrapWithMethods(Class<?> clz, IokeObject obj, Runtime runtime, boolean special) {
        try {
            List<Method> lm;
            String name;
            String prefix = "";
            if (clz == Class.class) {
                prefix = "class:";
            }
            HashMap<String, List<Method>> ms = new HashMap<String, List<Method>>();
            HashMap<String, List<Method>> allMethods = new HashMap<String, List<Method>>();
            for (Method method : clz.getMethods()) {
                name = method.getName();
                lm = null;
                if (!allMethods.containsKey(name)) {
                    lm = new LinkedList();
                    allMethods.put(name, lm);
                } else {
                    lm = (List)allMethods.get(name);
                }
                lm.add(method);
                try {
                    method.setAccessible(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (Method method : clz.getDeclaredMethods()) {
                name = method.getName();
                lm = null;
                if (!ms.containsKey(name)) {
                    lm = new LinkedList();
                    ms.put(name, lm);
                    List mex = (List)allMethods.get(name);
                    if (mex != null) {
                        lm.addAll(mex);
                    } else {
                        lm.add(method);
                    }
                } else {
                    lm = (List)ms.get(name);
                    if (!lm.contains(method)) {
                        lm.add(method);
                    }
                }
                try {
                    method.setAccessible(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (Map.Entry mesl : ms.entrySet()) {
                char first;
                IokeObject method = runtime.createJavaMethod(((List)mesl.getValue()).toArray(new Method[0]));
                String string = (String)mesl.getKey();
                obj.setCell(prefix + string, method);
                if (string.startsWith("get") && string.length() > 3) {
                    first = Character.toLowerCase(string.charAt(3));
                    obj.setCell(prefix + first + string.substring(4), method);
                    continue;
                }
                if (string.startsWith("set") && string.length() > 3) {
                    first = Character.toLowerCase(string.charAt(3));
                    obj.setCell(prefix + first + string.substring(4) + "=", method);
                    continue;
                }
                if (!string.startsWith("is") || string.length() <= 2) continue;
                first = Character.toLowerCase(string.charAt(2));
                obj.setCell(prefix + first + string.substring(3) + "?", method);
            }
            for (AccessibleObject accessibleObject : clz.getDeclaredFields()) {
                try {
                    ((Field)accessibleObject).setAccessible(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
                IokeObject getter = runtime.createJavaFieldGetter((Field)accessibleObject);
                obj.setCell("field:" + ((Field)accessibleObject).getName(), getter);
                if (Modifier.isFinal(((Field)accessibleObject).getModifiers())) continue;
                obj.setCell("field:" + ((Field)accessibleObject).getName() + "=", runtime.createJavaFieldSetter((Field)accessibleObject));
            }
            obj.setCell("new", runtime.createJavaMethod(clz.getDeclaredConstructors(), special));
        }
        catch (Throwable e) {
            System.err.print("woopsie: ");
            e.printStackTrace();
        }
        return new JavaWrapper(clz);
    }

    public Object getObject() {
        return this.object;
    }

    @Override
    public void init(IokeObject obj) throws ControlFlow {
        Runtime runtime = obj.runtime;
        obj.registerMethod(runtime.newNativeMethod("returns the kind of this Java object.", new NativeMethod.WithNoArguments("kind"){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                if (on instanceof IokeObject) {
                    return context.runtime.newText(((JavaWrapper)IokeObject.data(on)).kind);
                }
                return context.runtime.newText(on.getClass().getName().replaceAll("\\.", ":"));
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns the true if the receiver is a class object, false otherwise.", new NativeMethod.WithNoArguments("class?"){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                if (on instanceof IokeObject) {
                    return ((JavaWrapper)IokeObject.data(on)).clazz == Class.class ? context.runtime._true : context.runtime._false;
                }
                return on instanceof Class ? context.runtime._true : context.runtime._false;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("calls toString on the receiver and returns it.", new NativeMethod.WithNoArguments("class:toString"){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                if (on instanceof IokeObject) {
                    return ((JavaWrapper)IokeObject.data(on)).object.toString();
                }
                return on.toString();
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns true if the left hand side is equal to the right hand side. this will use the Java equals method - after unwrapping both the left hand and right hand side.", new NativeMethod("=="){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositional("other").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                ArrayList<Object> args = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                Object left = on;
                Object right = args.get(0);
                if (left instanceof IokeObject && IokeObject.data(left) instanceof JavaWrapper) {
                    left = JavaWrapper.getObject(left);
                }
                if (right instanceof IokeObject && IokeObject.data(right) instanceof JavaWrapper) {
                    right = JavaWrapper.getObject(right);
                }
                if (left == null) {
                    return right == null ? context.runtime._true : context.runtime._false;
                }
                return left.equals(right) ? context.runtime._true : context.runtime._false;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns true if the left hand side is the same instance as the right hand side", new NativeMethod("same?"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositional("other").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                ArrayList<Object> args = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                Object left = on;
                Object right = args.get(0);
                if (left instanceof IokeObject && IokeObject.data(left) instanceof JavaWrapper) {
                    left = JavaWrapper.getObject(left);
                }
                if (right instanceof IokeObject && IokeObject.data(right) instanceof JavaWrapper) {
                    right = JavaWrapper.getObject(right);
                }
                return left == right ? context.runtime._true : context.runtime._false;
            }
        }));
    }
}

