/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.AssociatedCode;
import ioke.lang.Call;
import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.IokeData;
import ioke.lang.IokeList;
import ioke.lang.IokeObject;
import ioke.lang.LexicalContext;
import ioke.lang.Message;
import ioke.lang.NativeMethod;
import ioke.lang.Runtime;
import ioke.lang.exceptions.ControlFlow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexicalBlock
extends IokeData
implements AssociatedCode {
    private DefaultArgumentsDefinition arguments;
    private IokeObject context;
    private IokeObject message;

    public LexicalBlock(IokeObject context, DefaultArgumentsDefinition arguments, IokeObject message) {
        this.context = context;
        this.arguments = arguments;
        this.message = message;
    }

    public LexicalBlock(IokeObject context) {
        this(context, DefaultArgumentsDefinition.empty(), context.runtime.nilMessage);
    }

    @Override
    public IokeObject getCode() {
        return this.message;
    }

    @Override
    public String getArgumentsCode() {
        return this.arguments.getCode(false);
    }

    @Override
    public void init(IokeObject lexicalBlock) throws ControlFlow {
        lexicalBlock.setKind("LexicalBlock");
        lexicalBlock.registerMethod(lexicalBlock.runtime.newNativeMethod("takes two evaluated arguments, where this first one is a list of messages which will be used as the arguments and the code, and the second is the context where this lexical scope should be created in", new NativeMethod("createFrom"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositional("messageList").withRequiredPositional("lexicalContext").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject self, IokeObject dynamicContext, IokeObject message, Object on) throws ControlFlow {
                Runtime runtime = dynamicContext.runtime;
                ArrayList<Object> positionalArgs = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(dynamicContext, message, on, positionalArgs, new HashMap<String, Object>());
                List<Object> args = IokeList.getList(positionalArgs.get(0));
                IokeObject ground = IokeObject.as(positionalArgs.get(1), dynamicContext);
                IokeObject code = IokeObject.as(args.get(args.size() - 1), dynamicContext);
                DefaultArgumentsDefinition def = DefaultArgumentsDefinition.createFrom(args, 0, args.size() - 1, message, on, dynamicContext);
                return runtime.newLexicalBlock(null, runtime.lexicalBlock, new LexicalBlock(ground, def, code));
            }
        }));
        lexicalBlock.registerMethod(lexicalBlock.runtime.newNativeMethod("invokes the block with the arguments provided, returning the result of the last expression in the block", new NativeMethod("call"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRestUnevaluated("arguments").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject self, IokeObject dynamicContext, IokeObject message, Object on) throws ControlFlow {
                return IokeObject.as(on, dynamicContext).activate(dynamicContext, message, on);
            }
        }));
        lexicalBlock.registerMethod(lexicalBlock.runtime.newNativeMethod("returns the full code of this lexical block, as a Text", new NativeMethod.WithNoArguments("code"){

            public Object activate(IokeObject self, IokeObject dynamicContext, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(dynamicContext, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                IokeObject obj = IokeObject.as(on, dynamicContext);
                String x = obj.isActivatable() ? "x" : "";
                String args = ((LexicalBlock)IokeObject.data(on)).arguments.getCode();
                return ((LexicalBlock)LexicalBlock.this).context.runtime.newText("fn" + x + "(" + args + Message.code(((LexicalBlock)IokeObject.data(on)).message) + ")");
            }
        }));
        lexicalBlock.registerMethod(lexicalBlock.runtime.newNativeMethod("returns the code for the argument definition", new NativeMethod.WithNoArguments("argumentsCode"){

            public Object activate(IokeObject self, IokeObject dynamicContext, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(dynamicContext, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return dynamicContext.runtime.newText(((AssociatedCode)((Object)IokeObject.data(on))).getArgumentsCode());
            }
        }));
        lexicalBlock.registerMethod(lexicalBlock.runtime.newNativeMethod("returns a list of the keywords this block takes", new NativeMethod.WithNoArguments("keywords"){

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                ArrayList<Object> keywords = new ArrayList<Object>();
                for (String keyword : ((LexicalBlock)IokeObject.data(on)).arguments.getKeywords()) {
                    keywords.add(context.runtime.getSymbol(keyword.substring(0, keyword.length() - 1)));
                }
                return context.runtime.newList(keywords);
            }
        }));
        lexicalBlock.registerMethod(lexicalBlock.runtime.newNativeMethod("returns a list of the argument names the positional arguments this block takes", new NativeMethod.WithNoArguments("argumentNames"){

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                ArrayList<Object> names = new ArrayList<Object>();
                for (DefaultArgumentsDefinition.Argument arg : ((LexicalBlock)IokeObject.data(on)).arguments.getArguments()) {
                    if (arg instanceof DefaultArgumentsDefinition.KeywordArgument) continue;
                    names.add(context.runtime.getSymbol(arg.getName()));
                }
                return context.runtime.newList(names);
            }
        }));
        lexicalBlock.registerMethod(lexicalBlock.runtime.newNativeMethod("returns the message chain for this block", new NativeMethod.WithNoArguments("message"){

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return ((AssociatedCode)((Object)IokeObject.data(on))).getCode();
            }
        }));
        lexicalBlock.registerMethod(lexicalBlock.runtime.newNativeMethod("Returns a text inspection of the object", new NativeMethod.WithNoArguments("inspect"){

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return context.runtime.newText(LexicalBlock.getInspect(on));
            }
        }));
        lexicalBlock.registerMethod(lexicalBlock.runtime.newNativeMethod("Returns a brief text inspection of the object", new NativeMethod.WithNoArguments("notice"){

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return context.runtime.newText(LexicalBlock.getNotice(on));
            }
        }));
        lexicalBlock.registerMethod(lexicalBlock.runtime.newNativeMethod("returns idiomatically formatted code for this lexical block", new NativeMethod.WithNoArguments("formattedCode"){

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return context.runtime.newText(((AssociatedCode)((Object)IokeObject.data(on))).getFormattedCode(self));
            }
        }));
    }

    @Override
    public Object activateWithCallAndData(IokeObject self, IokeObject dynamicContext, IokeObject message, Object on, Object call, Map<String, Object> data) throws ControlFlow {
        LexicalContext c = new LexicalContext(self.runtime, on, "Lexical activation context", message, this.context);
        for (Map.Entry<String, Object> d : data.entrySet()) {
            String s = d.getKey();
            c.setCell(s.substring(0, s.length() - 1), d.getValue());
        }
        this.arguments.assignArgumentValues(c, dynamicContext, message, on, (Call)IokeObject.data(call));
        return ((Message)IokeObject.data(this.message)).evaluateCompleteWith(this.message, c, on);
    }

    @Override
    public Object activateWithCall(IokeObject self, IokeObject dynamicContext, IokeObject message, Object on, Object call) throws ControlFlow {
        LexicalContext c = new LexicalContext(self.runtime, on, "Lexical activation context", message, this.context);
        this.arguments.assignArgumentValues(c, dynamicContext, message, on, (Call)IokeObject.data(call));
        return ((Message)IokeObject.data(this.message)).evaluateCompleteWith(this.message, c, on);
    }

    @Override
    public Object activate(IokeObject self, IokeObject dynamicContext, IokeObject message, Object on) throws ControlFlow {
        LexicalContext c = new LexicalContext(self.runtime, on, "Lexical activation context", message, this.context);
        this.arguments.assignArgumentValues(c, dynamicContext, message, on);
        return ((Message)IokeObject.data(this.message)).evaluateCompleteWith(this.message, c, on);
    }

    @Override
    public Object activateWithData(IokeObject self, IokeObject dynamicContext, IokeObject message, Object on, Map<String, Object> data) throws ControlFlow {
        LexicalContext c = new LexicalContext(self.runtime, on, "Lexical activation context", message, this.context);
        for (Map.Entry<String, Object> d : data.entrySet()) {
            String s = d.getKey();
            c.setCell(s.substring(0, s.length() - 1), d.getValue());
        }
        this.arguments.assignArgumentValues(c, dynamicContext, message, on);
        return ((Message)IokeObject.data(this.message)).evaluateCompleteWith(this.message, c, on);
    }

    public static String getInspect(Object on) {
        return ((LexicalBlock)IokeObject.data(on)).inspect(on);
    }

    public static String getNotice(Object on) {
        return ((LexicalBlock)IokeObject.data(on)).notice(on);
    }

    @Override
    public String getFormattedCode(Object self) throws ControlFlow {
        String args;
        String string = args = this.arguments == null ? "" : this.arguments.getCode();
        if (IokeObject.as(self, (IokeObject)self).isActivatable()) {
            return "fnx(" + args + "\n  " + Message.formattedCode(this.message, 2, (IokeObject)self) + ")";
        }
        return "fn(" + args + "\n  " + Message.formattedCode(this.message, 2, (IokeObject)self) + ")";
    }

    public String inspect(Object self) {
        String args = this.arguments.getCode();
        if (IokeObject.as(self, (IokeObject)self).isActivatable()) {
            return "fnx(" + args + Message.code(this.message) + ")";
        }
        return "fn(" + args + Message.code(this.message) + ")";
    }

    public String notice(Object self) {
        if (IokeObject.as(self, (IokeObject)self).isActivatable()) {
            return "fnx(...)";
        }
        return "fn(...)";
    }
}

