/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.AliasMethod;
import ioke.lang.AssociatedCode;
import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.Inspectable;
import ioke.lang.IokeData;
import ioke.lang.IokeObject;
import ioke.lang.LexicalContext;
import ioke.lang.Message;
import ioke.lang.Named;
import ioke.lang.NativeMethod;
import ioke.lang.exceptions.ControlFlow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexicalMacro
extends IokeData
implements AssociatedCode,
Named,
Inspectable {
    String name;
    private IokeObject context;
    private IokeObject code;

    public LexicalMacro(IokeObject context, IokeObject code) {
        this.context = context;
        this.code = code;
    }

    public LexicalMacro(String name) {
        this.name = name;
    }

    @Override
    public IokeObject getCode() {
        return this.code;
    }

    public String getCodeString(Object self) throws ControlFlow {
        if (IokeObject.as(self, null).isActivatable()) {
            return "lecro(" + Message.code(this.code) + ")";
        }
        return "lecrox(" + Message.code(this.code) + ")";
    }

    @Override
    public String getFormattedCode(Object self) throws ControlFlow {
        if (IokeObject.as(self, (IokeObject)self).isActivatable()) {
            return "lecro(\n  " + Message.formattedCode(this.code, 2, (IokeObject)self) + ")";
        }
        return "lecrox(\n  " + Message.formattedCode(this.code, 2, (IokeObject)self) + ")";
    }

    @Override
    public void init(IokeObject obj) throws ControlFlow {
        obj.setKind("LexicalMacro");
        obj.registerCell("activatable", obj.runtime._true);
        obj.registerMethod(obj.runtime.newNativeMethod("returns the name of the lecro", new NativeMethod.WithNoArguments("name"){

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return context.runtime.newText(((LexicalMacro)IokeObject.data((Object)on)).name);
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("activates this lecro with the arguments given to call", new NativeMethod("call"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRestUnevaluated("arguments").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                return IokeObject.as(on, context).activate(context, message, context.getRealContext());
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("returns the message chain for this lecro", new NativeMethod.WithNoArguments("message"){

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return ((AssociatedCode)((Object)IokeObject.data(on))).getCode();
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("returns the code for the argument definition", new NativeMethod.WithNoArguments("argumentsCode"){

            public Object activate(IokeObject self, IokeObject dynamicContext, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(dynamicContext, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return dynamicContext.runtime.newText(((AssociatedCode)((Object)IokeObject.data(on))).getArgumentsCode());
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("Returns a text inspection of the object", new NativeMethod.WithNoArguments("inspect"){

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return context.runtime.newText(LexicalMacro.getInspect(on));
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("Returns a brief text inspection of the object", new NativeMethod.WithNoArguments("notice"){

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return context.runtime.newText(LexicalMacro.getNotice(on));
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("returns the full code of this lecro, as a Text", new NativeMethod.WithNoArguments("code"){

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                IokeData data = IokeObject.data(on);
                if (data instanceof LexicalMacro) {
                    return context.runtime.newText(((LexicalMacro)data).getCodeString(on));
                }
                return context.runtime.newText(((AliasMethod)data).getCodeString());
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("returns idiomatically formatted code for this lecro", new NativeMethod.WithNoArguments("formattedCode"){

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return context.runtime.newText(((AssociatedCode)((Object)IokeObject.data(on))).getFormattedCode(self));
            }
        }));
    }

    @Override
    public String getArgumentsCode() {
        return "...";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public static String getInspect(Object on) {
        return ((Inspectable)((Object)IokeObject.data(on))).inspect(on);
    }

    public static String getNotice(Object on) {
        return ((Inspectable)((Object)IokeObject.data(on))).notice(on);
    }

    @Override
    public String inspect(Object self) {
        String type = "lecro";
        if (!IokeObject.as(self, null).isActivatable()) {
            type = "lecrox";
        }
        if (this.name == null) {
            return type + "(" + Message.code(this.code) + ")";
        }
        return this.name + ":" + type + "(" + Message.code(this.code) + ")";
    }

    @Override
    public String notice(Object self) {
        String type = "lecro";
        if (!IokeObject.as(self, null).isActivatable()) {
            type = "lecrox";
        }
        if (this.name == null) {
            return type + "(...)";
        }
        return this.name + ":" + type + "(...)";
    }

    @Override
    public Object activateWithCallAndData(IokeObject self, IokeObject dynamicContext, IokeObject message, Object on, Object call, Map<String, Object> data) throws ControlFlow {
        if (this.code == null) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(dynamicContext.runtime.condition, message, dynamicContext, "Error", "Invocation", "NotActivatable"), dynamicContext).mimic(message, dynamicContext);
            condition.setCell("message", message);
            condition.setCell("context", dynamicContext);
            condition.setCell("receiver", on);
            condition.setCell("method", self);
            condition.setCell("report", dynamicContext.runtime.newText("You tried to activate a method without any code - did you by any chance activate the LexicalMacro kind by referring to it without wrapping it inside a call to cell?"));
            dynamicContext.runtime.errorCondition(condition);
            return null;
        }
        LexicalContext c = new LexicalContext(self.runtime, on, "Lexical macro activation context", message, this.context);
        c.setCell("outerScope", this.context);
        c.setCell("call", call);
        for (Map.Entry<String, Object> d : data.entrySet()) {
            String s = d.getKey();
            c.setCell(s.substring(0, s.length() - 1), d.getValue());
        }
        return ((Message)IokeObject.data(this.code)).evaluateCompleteWith(this.code, c, on);
    }

    @Override
    public Object activateWithCall(IokeObject self, IokeObject dynamicContext, IokeObject message, Object on, Object call) throws ControlFlow {
        if (this.code == null) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(dynamicContext.runtime.condition, message, dynamicContext, "Error", "Invocation", "NotActivatable"), dynamicContext).mimic(message, dynamicContext);
            condition.setCell("message", message);
            condition.setCell("context", dynamicContext);
            condition.setCell("receiver", on);
            condition.setCell("method", self);
            condition.setCell("report", dynamicContext.runtime.newText("You tried to activate a method without any code - did you by any chance activate the LexicalMacro kind by referring to it without wrapping it inside a call to cell?"));
            dynamicContext.runtime.errorCondition(condition);
            return null;
        }
        LexicalContext c = new LexicalContext(self.runtime, on, "Lexical macro activation context", message, this.context);
        c.setCell("outerScope", this.context);
        c.setCell("call", call);
        return ((Message)IokeObject.data(this.code)).evaluateCompleteWith(this.code, c, on);
    }

    @Override
    public Object activate(IokeObject self, IokeObject dynamicContext, IokeObject message, Object on) throws ControlFlow {
        if (this.code == null) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(dynamicContext.runtime.condition, message, dynamicContext, "Error", "Invocation", "NotActivatable"), dynamicContext).mimic(message, dynamicContext);
            condition.setCell("message", message);
            condition.setCell("context", dynamicContext);
            condition.setCell("receiver", on);
            condition.setCell("method", self);
            condition.setCell("report", dynamicContext.runtime.newText("You tried to activate a method without any code - did you by any chance activate the LexicalMacro kind by referring to it without wrapping it inside a call to cell?"));
            dynamicContext.runtime.errorCondition(condition);
            return null;
        }
        LexicalContext c = new LexicalContext(self.runtime, on, "Lexical macro activation context", message, this.context);
        c.setCell("outerScope", this.context);
        c.setCell("call", dynamicContext.runtime.newCallFrom(c, message, dynamicContext, IokeObject.as(on, dynamicContext)));
        return ((Message)IokeObject.data(this.code)).evaluateCompleteWith(this.code, c, on);
    }

    @Override
    public Object activateWithData(IokeObject self, IokeObject dynamicContext, IokeObject message, Object on, Map<String, Object> data) throws ControlFlow {
        if (this.code == null) {
            IokeObject condition = IokeObject.as(IokeObject.getCellChain(dynamicContext.runtime.condition, message, dynamicContext, "Error", "Invocation", "NotActivatable"), dynamicContext).mimic(message, dynamicContext);
            condition.setCell("message", message);
            condition.setCell("context", dynamicContext);
            condition.setCell("receiver", on);
            condition.setCell("method", self);
            condition.setCell("report", dynamicContext.runtime.newText("You tried to activate a method without any code - did you by any chance activate the LexicalMacro kind by referring to it without wrapping it inside a call to cell?"));
            dynamicContext.runtime.errorCondition(condition);
            return null;
        }
        LexicalContext c = new LexicalContext(self.runtime, on, "Lexical macro activation context", message, this.context);
        c.setCell("outerScope", this.context);
        c.setCell("call", dynamicContext.runtime.newCallFrom(c, message, dynamicContext, IokeObject.as(on, dynamicContext)));
        for (Map.Entry<String, Object> d : data.entrySet()) {
            String s = d.getKey();
            c.setCell(s.substring(0, s.length() - 1), d.getValue());
        }
        return ((Message)IokeObject.data(this.code)).evaluateCompleteWith(this.code, c, on);
    }
}

