/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.IokeObject;
import ioke.lang.Message;
import ioke.lang.NativeMethod;
import ioke.lang.Pair;
import ioke.lang.Runtime;
import ioke.lang.Text;
import ioke.lang.exceptions.ControlFlow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LiteralsBehavior {
    public static void init(IokeObject obj) throws ControlFlow {
        Runtime runtime = obj.runtime;
        obj.setKind("DefaultBehavior Literals");
        obj.registerMethod(runtime.newNativeMethod("returns a new message with the name given as argument to this method.", new NativeMethod("message"){
            private final DefaultArgumentsDefinition ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositional("name").getArguments();

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                ArrayList<Object> args = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                Object o = args.get(0);
                String name = null;
                name = IokeObject.data(o) instanceof Text ? Text.getText(o) : Text.getText(((Message)IokeObject.data(context.runtime.asText)).sendTo(context.runtime.asText, context, o));
                Message m = new Message(context.runtime, name);
                IokeObject ret = context.runtime.createMessage(m);
                if (".".equals(name)) {
                    Message.setIsTerminator(ret, true);
                }
                Message.copySourceLocation(message, ret);
                return ret;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("Takes one evaluated argument and returns a new Pair of the receiver and the argument", new NativeMethod("=>"){
            private final DefaultArgumentsDefinition ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositional("other").getArguments();

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                ArrayList<Object> args = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                return context.runtime.newPair(on, args.get(0));
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("Takes one evaluated argument that is expected to be a Text, and returns the symbol corresponding to that text", new NativeMethod(":"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositional("symbolText").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                ArrayList<Object> args = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                String sym = Text.getText(((Message)IokeObject.data(runtime.asText)).sendTo(runtime.asText, context, args.get(0)));
                return context.runtime.getSymbol(sym);
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("creates a new Dict from the arguments provided. these arguments can be two different things - either a keyword argument, or a pair. if it's a keyword argument, the entry added to the dict for it will be a symbol with the name from the keyword, without the ending colon. if it's not a keyword, it is expected to be an evaluated pair, where the first part of the pair is the key, and the second part is the value.", new NativeMethod("dict"){
            private final DefaultArgumentsDefinition ARGUMENTS = DefaultArgumentsDefinition.builder().withRest("pairs").withKeywordRest("keywordPairs").getArguments();

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                List<Object> arguments = message.getArguments();
                HashMap<Object, Object> moo = new HashMap<Object, Object>(arguments.size());
                for (Object o : arguments) {
                    Object value;
                    Object key;
                    if (Message.isKeyword(o)) {
                        String str = Message.name(o);
                        key = context.runtime.getSymbol(str.substring(0, str.length() - 1));
                        value = Message.next(o) != null ? Message.getEvaluatedArgument(Message.next(o), context) : context.runtime.nil;
                    } else {
                        Object result = Message.getEvaluatedArgument(o, context);
                        if (result instanceof IokeObject && IokeObject.data(result) instanceof Pair) {
                            key = Pair.getFirst(result);
                            value = Pair.getSecond(result);
                        } else {
                            key = result;
                            value = context.runtime.nil;
                        }
                    }
                    moo.put(key, value);
                }
                return context.runtime.newDict(moo);
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("creates a new Set from the result of evaluating all arguments provided.", new NativeMethod("set"){
            private final DefaultArgumentsDefinition ARGUMENTS = DefaultArgumentsDefinition.builder().withRest("elements").getArguments();

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                ArrayList<Object> args = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                return context.runtime.newSet(args);
            }
        }));
    }
}

