/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.AliasMethod;
import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.Inspectable;
import ioke.lang.IokeData;
import ioke.lang.IokeObject;
import ioke.lang.Named;
import ioke.lang.NativeMethod;
import ioke.lang.exceptions.ControlFlow;
import java.util.ArrayList;
import java.util.HashMap;

public class Method
extends IokeData
implements Named,
Inspectable {
    String name;

    public Method(String name) {
        this.name = name;
    }

    public Method(IokeObject context) {
        this((String)null);
    }

    public void init(IokeObject method) throws ControlFlow {
        method.setKind("Method");
        method.registerCell("activatable", method.runtime._true);
        method.registerMethod(method.runtime.newNativeMethod("returns the name of the method", new NativeMethod.WithNoArguments("name"){

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return context.runtime.newText(((Method)IokeObject.data((Object)on)).name);
            }
        }));
        method.registerMethod(method.runtime.newNativeMethod("Returns a text inspection of the object", new NativeMethod.WithNoArguments("inspect"){

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return context.runtime.newText(Method.getInspect(on));
            }
        }));
        method.registerMethod(method.runtime.newNativeMethod("Returns a brief text inspection of the object", new NativeMethod.WithNoArguments("notice"){

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return context.runtime.newText(Method.getNotice(on));
            }
        }));
        method.registerMethod(method.runtime.newNativeMethod("activates this method with the arguments given to call", new NativeMethod("call"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRestUnevaluated("arguments").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                return IokeObject.as(on, context).activate(context, message, context.getRealContext());
            }
        }));
        method.registerMethod(method.runtime.newNativeMethod("returns the full code of this method, as a Text", new NativeMethod.WithNoArguments("code"){

            public Object activate(IokeObject self, IokeObject dynamicContext, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(dynamicContext, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                IokeData data = IokeObject.data(on);
                if (data instanceof Method) {
                    return dynamicContext.runtime.newText(((Method)data).getCodeString());
                }
                return dynamicContext.runtime.newText(((AliasMethod)data).getCodeString());
            }
        }));
    }

    public String getName() {
        return this.name;
    }

    public String getCodeString() {
        return "method(nil)";
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
        IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, message, context, "Error", "Invocation", "NotActivatable"), context).mimic(message, context);
        condition.setCell("message", message);
        condition.setCell("context", context);
        condition.setCell("receiver", on);
        condition.setCell("method", self);
        condition.setCell("reportMsg", context.runtime.newText("You tried to activate a method (" + this.name + ") without any code - did you by any chance activate the Method kind by referring to it without wrapping it inside a call to cell?"));
        context.runtime.errorCondition(condition);
        return self.runtime.nil;
    }

    public static String getInspect(Object on) {
        return ((Inspectable)((Object)IokeObject.data(on))).inspect(on);
    }

    public static String getNotice(Object on) {
        return ((Inspectable)((Object)IokeObject.data(on))).notice(on);
    }

    public String inspect(Object self) {
        return this.getCodeString();
    }

    public String notice(Object self) {
        if (this.name == null) {
            return "method(...)";
        }
        return this.name + ":method(...)";
    }
}

