/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.AssociatedCode;
import ioke.lang.CanRun;
import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.IokeData;
import ioke.lang.IokeObject;
import ioke.lang.Method;
import ioke.lang.exceptions.ControlFlow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NativeMethod
extends Method
implements CanRun {
    public NativeMethod(String name) {
        super(name);
    }

    @Override
    public void init(IokeObject javaMethod) throws ControlFlow {
        javaMethod.setKind("NativeMethod");
        javaMethod.registerMethod(javaMethod.runtime.newNativeMethod("returns a list of the keywords this method takes", new WithNoArguments("keywords"){

            public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return context.runtime.newList(new ArrayList<Object>());
            }
        }));
        javaMethod.registerMethod(javaMethod.runtime.newNativeMethod("returns the code for the argument definition", new WithNoArguments("argumentsCode"){

            public Object activate(IokeObject self, IokeObject dynamicContext, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(dynamicContext, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                IokeData data = IokeObject.data(on);
                if (data instanceof NativeMethod) {
                    return dynamicContext.runtime.newText(((NativeMethod)data).getArgumentsCode());
                }
                return dynamicContext.runtime.newText(((AssociatedCode)((Object)data)).getArgumentsCode());
            }
        }));
    }

    public abstract DefaultArgumentsDefinition getArguments();

    public String getArgumentsCode() {
        return this.getArguments().getCode(false);
    }

    @Override
    public Object activate(IokeObject self, IokeObject context, IokeObject message, Object on) throws ControlFlow {
        ArrayList<Object> args = new ArrayList<Object>();
        HashMap<String, Object> keywords = new HashMap<String, Object>();
        this.getArguments().getEvaluatedArguments(context, message, on, args, keywords);
        return this.activate(self, on, args, keywords, context, message);
    }

    public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
        IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, message, context, "Error", "Invocation", "NotActivatable"), context).mimic(message, context);
        condition.setCell("message", message);
        condition.setCell("context", context);
        condition.setCell("receiver", on);
        condition.setCell("method", self);
        condition.setCell("report", context.runtime.newText("You tried to activate a method without any code - did you by any chance activate the NativeMethod kind by referring to it without wrapping it inside a call to cell?"));
        context.runtime.errorCondition(condition);
        return self.runtime.nil;
    }

    private String getDominantClassName() {
        String name = this.getClass().getName();
        int dollar = name.indexOf("$");
        int dot = name.lastIndexOf(".");
        if (dollar == -1) {
            dollar = name.length();
        }
        return name.substring(dot + 1, dollar);
    }

    @Override
    public String inspect(Object self) {
        return "method(" + this.getDominantClassName() + (this.name != null ? "_" + this.name : "") + ")";
    }

    public static class WithNoArguments
    extends NativeMethod {
        private static final DefaultArgumentsDefinition ARGUMENTS = DefaultArgumentsDefinition.empty();

        public WithNoArguments(String name) {
            super(name);
        }

        public DefaultArgumentsDefinition getArguments() {
            return ARGUMENTS;
        }
    }
}

