/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.IokeData;
import ioke.lang.IokeObject;
import ioke.lang.LexicalContext;
import ioke.lang.Message;
import ioke.lang.NativeMethod;
import ioke.lang.Number;
import ioke.lang.Runtime;
import ioke.lang.Sequence;
import ioke.lang.TypeCheckingArgumentsDefinition;
import ioke.lang.TypeCheckingNativeMethod;
import ioke.lang.exceptions.ControlFlow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Range
extends IokeData {
    private IokeObject from;
    private IokeObject to;
    private boolean inclusive;
    private boolean inverted = false;

    public Range(IokeObject from, IokeObject to, boolean inclusive, boolean inverted) {
        this.from = from;
        this.to = to;
        this.inclusive = inclusive;
        this.inverted = inverted;
    }

    public static IokeObject getFrom(Object range) {
        return ((Range)IokeObject.data(range)).getFrom();
    }

    public static IokeObject getTo(Object range) {
        return ((Range)IokeObject.data(range)).getTo();
    }

    public static boolean isInclusive(Object range) {
        return ((Range)IokeObject.data(range)).isInclusive();
    }

    public IokeObject getFrom() {
        return this.from;
    }

    public IokeObject getTo() {
        return this.to;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public void init(IokeObject obj) throws ControlFlow {
        Runtime runtime = obj.runtime;
        obj.setKind("Range");
        obj.mimics(IokeObject.as(runtime.mixins.getCell(null, null, "Sequenced"), null), runtime.nul, runtime.nul);
        obj.registerMethod(runtime.newNativeMethod("returns true if the left hand side range is equal to the right hand side range.", new TypeCheckingNativeMethod("=="){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(runtime.range).withRequiredPositional("other").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                Range d = (Range)IokeObject.data(on);
                Object other = args.get(0);
                return other instanceof IokeObject && IokeObject.data(other) instanceof Range && d.inclusive == ((Range)IokeObject.data(other)).inclusive && d.from.equals(((Range)IokeObject.data(other)).from) && d.to.equals(((Range)IokeObject.data(other)).to) ? context.runtime._true : context.runtime._false;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("will return a new inclusive Range based on the two arguments", new NativeMethod("inclusive"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositional("from").withRequiredPositional("to").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                Object result;
                ArrayList<Object> args = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                Object from = args.get(0);
                Object to = args.get(1);
                boolean comparing = IokeObject.isMimic(from, IokeObject.as(context.runtime.mixins.getCells().get("Comparing"), context), context);
                boolean inverted = false;
                if (comparing && (result = ((Message)IokeObject.data(context.runtime.spaceShip)).sendTo(context.runtime.spaceShip, context, from, to)) != context.runtime.nil && Number.extractInt(result, message, context) == 1) {
                    inverted = true;
                }
                return runtime.newRange(IokeObject.as(from, context), IokeObject.as(to, context), true, inverted);
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("will return a new exclusive Range based on the two arguments", new NativeMethod("exclusive"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositional("from").withRequiredPositional("to").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                Object result;
                ArrayList<Object> args = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                Object from = args.get(0);
                Object to = args.get(1);
                boolean comparing = IokeObject.isMimic(from, IokeObject.as(context.runtime.mixins.getCells().get("Comparing"), context), context);
                boolean inverted = false;
                if (comparing && (result = ((Message)IokeObject.data(context.runtime.spaceShip)).sendTo(context.runtime.spaceShip, context, from, to)) != context.runtime.nil && Number.extractInt(result, message, context) == 1) {
                    inverted = true;
                }
                return runtime.newRange(IokeObject.as(from, context), IokeObject.as(to, context), false, inverted);
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns true if the receiver is an exclusive range, false otherwise", new NativeMethod.WithNoArguments("exclusive?"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return ((Range)IokeObject.data(on)).inclusive ? context.runtime._false : context.runtime._true;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns true if the receiver is an inclusive range, false otherwise", new NativeMethod.WithNoArguments("inclusive?"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return ((Range)IokeObject.data(on)).inclusive ? context.runtime._true : context.runtime._false;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns the 'from' part of the range", new TypeCheckingNativeMethod.WithNoArguments("from", runtime.range){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return ((Range)IokeObject.data(on)).from;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns the 'to' part of the range", new NativeMethod.WithNoArguments("to"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return ((Range)IokeObject.data(on)).to;
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("returns a new sequence to iterate over this range", new TypeCheckingNativeMethod.WithNoArguments("seq", runtime.range){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                IokeObject obj = method.runtime.iteratorSequence.allocateCopy(null, null);
                obj.mimicsWithoutCheck(method.runtime.iteratorSequence);
                Range r = (Range)IokeObject.data(on);
                RangeIterator ri = new RangeIterator(r.from, r.to, r.inclusive, r.inverted, context, message);
                obj.setData(new Sequence.IteratorSequence(ri));
                return obj;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("takes either one or two or three arguments. if one argument is given, it should be a message chain that will be sent to each object in the range. the result will be thrown away. if two arguments are given, the first is an unevaluated name that will be set to each of the values in the range in succession, and then the second argument will be evaluated in a scope with that argument in it. if three arguments is given, the first one is an unevaluated name that will be set to the index of each element, and the other two arguments are the name of the argument for the value, and the actual code. the code will evaluate in a lexical context, and if the argument name is available outside the context, it will be shadowed. the method will return the range.", new NativeMethod("each"){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withOptionalPositionalUnevaluated("indexOrArgOrCode").withOptionalPositionalUnevaluated("argOrCode").withOptionalPositionalUnevaluated("code").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().checkArgumentCount(context, message, on);
                Runtime runtime = context.runtime;
                IokeObject from = IokeObject.as(((Range)IokeObject.data(on)).from, context);
                IokeObject to = IokeObject.as(((Range)IokeObject.data(on)).to, context);
                boolean inclusive = ((Range)IokeObject.data(on)).inclusive;
                IokeObject messageToSend = context.runtime.succ;
                if (((Range)IokeObject.data(on)).inverted) {
                    messageToSend = context.runtime.pred;
                }
                switch (message.getArgumentCount()) {
                    case 0: {
                        return ((Message)IokeObject.data(runtime.seqMessage)).sendTo(runtime.seqMessage, context, on);
                    }
                    case 1: {
                        IokeObject code = IokeObject.as(message.getArguments().get(0), context);
                        Object current = from;
                        while (!IokeObject.isTrue(((Message)IokeObject.data(context.runtime.eqMessage)).sendTo(context.runtime.eqMessage, context, current, to))) {
                            ((Message)IokeObject.data(code)).evaluateCompleteWithReceiver(code, context, context.getRealContext(), current);
                            current = ((Message)IokeObject.data(messageToSend)).sendTo(messageToSend, context, current);
                        }
                        if (!inclusive) break;
                        ((Message)IokeObject.data(code)).evaluateCompleteWithReceiver(code, context, context.getRealContext(), current);
                        break;
                    }
                    case 2: {
                        LexicalContext c = new LexicalContext(context.runtime, context, "Lexical activation context for Range#each", message, context);
                        String name = IokeObject.as(message.getArguments().get(0), context).getName();
                        IokeObject code = IokeObject.as(message.getArguments().get(1), context);
                        Object current = from;
                        while (!IokeObject.isTrue(((Message)IokeObject.data(context.runtime.eqMessage)).sendTo(context.runtime.eqMessage, context, current, to))) {
                            c.setCell(name, current);
                            ((Message)IokeObject.data(code)).evaluateCompleteWithoutExplicitReceiver(code, c, c.getRealContext());
                            current = ((Message)IokeObject.data(messageToSend)).sendTo(messageToSend, context, current);
                        }
                        if (!inclusive) break;
                        c.setCell(name, current);
                        ((Message)IokeObject.data(code)).evaluateCompleteWithoutExplicitReceiver(code, c, c.getRealContext());
                        break;
                    }
                    case 3: {
                        LexicalContext c = new LexicalContext(context.runtime, context, "Lexical activation context for List#each", message, context);
                        String iname = IokeObject.as(message.getArguments().get(0), context).getName();
                        String name = IokeObject.as(message.getArguments().get(1), context).getName();
                        IokeObject code = IokeObject.as(message.getArguments().get(2), context);
                        int index = 0;
                        Object current = from;
                        while (!IokeObject.isTrue(((Message)IokeObject.data(context.runtime.eqMessage)).sendTo(context.runtime.eqMessage, context, current, to))) {
                            c.setCell(name, current);
                            c.setCell(iname, runtime.newNumber(index++));
                            ((Message)IokeObject.data(code)).evaluateCompleteWithoutExplicitReceiver(code, c, c.getRealContext());
                            current = ((Message)IokeObject.data(messageToSend)).sendTo(messageToSend, context, current);
                        }
                        if (!inclusive) break;
                        c.setCell(name, current);
                        c.setCell(iname, runtime.newNumber(index++));
                        ((Message)IokeObject.data(code)).evaluateCompleteWithoutExplicitReceiver(code, c, c.getRealContext());
                        break;
                    }
                }
                return on;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("returns true if the argument is within the confines of this range. how this comparison is done depends on if the object mimics Comparing. If it does, < and > will be used. If not, all the available entries in this range will be enumerated using 'succ'/'pred' until either the end or the element we're looking for is found. in that case, comparison is done with '=='", new NativeMethod("==="){
            private final DefaultArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = DefaultArgumentsDefinition.builder().withRequiredPositional("other").getArguments();
            }

            public DefaultArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                ArrayList<Object> args = new ArrayList<Object>();
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                Object other = args.get(0);
                IokeObject from = IokeObject.as(((Range)IokeObject.data(on)).from, context);
                IokeObject to = IokeObject.as(((Range)IokeObject.data(on)).to, context);
                boolean comparing = IokeObject.isMimic(from, IokeObject.as(context.runtime.mixins.getCells().get("Comparing"), context));
                boolean inclusive = ((Range)IokeObject.data(on)).inclusive;
                if (comparing) {
                    IokeObject firstMessage = context.runtime.lteMessage;
                    IokeObject secondMessageInclusive = context.runtime.gteMessage;
                    IokeObject secondMessageExclusive = context.runtime.gtMessage;
                    if (((Range)IokeObject.data(on)).inverted) {
                        firstMessage = context.runtime.gteMessage;
                        secondMessageInclusive = context.runtime.lteMessage;
                        secondMessageExclusive = context.runtime.ltMessage;
                    }
                    if (IokeObject.isTrue(((Message)IokeObject.data(firstMessage)).sendTo(firstMessage, context, (Object)from, other)) && (inclusive && IokeObject.isTrue(((Message)IokeObject.data(secondMessageInclusive)).sendTo(secondMessageInclusive, context, (Object)to, other)) || IokeObject.isTrue(((Message)IokeObject.data(secondMessageExclusive)).sendTo(secondMessageExclusive, context, (Object)to, other)))) {
                        return context.runtime._true;
                    }
                    return context.runtime._false;
                }
                IokeObject messageToSend = context.runtime.succ;
                if (((Range)IokeObject.data(on)).inverted) {
                    messageToSend = context.runtime.pred;
                }
                Object current = from;
                while (!IokeObject.isTrue(((Message)IokeObject.data(context.runtime.eqMessage)).sendTo(context.runtime.eqMessage, context, current, to))) {
                    if (IokeObject.isTrue(((Message)IokeObject.data(context.runtime.eqMessage)).sendTo(context.runtime.eqMessage, context, current, other))) {
                        return context.runtime._true;
                    }
                    current = ((Message)IokeObject.data(messageToSend)).sendTo(messageToSend, context, current);
                }
                if (inclusive && IokeObject.isTrue(((Message)IokeObject.data(context.runtime.eqMessage)).sendTo(context.runtime.eqMessage, context, (Object)to, other))) {
                    return context.runtime._true;
                }
                return context.runtime._false;
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("Returns a text inspection of the object", new NativeMethod.WithNoArguments("inspect"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return method.runtime.newText(Range.getInspect(on));
            }
        }));
        obj.registerMethod(runtime.newNativeMethod("Returns a brief text inspection of the object", new NativeMethod.WithNoArguments("notice"){

            public Object activate(IokeObject method, IokeObject context, IokeObject message, Object on) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, new ArrayList<Object>(), new HashMap<String, Object>());
                return method.runtime.newText(Range.getNotice(on));
            }
        }));
    }

    public IokeData cloneData(IokeObject obj, IokeObject m, IokeObject context) {
        return new Range(this.from, this.to, this.inclusive, this.inverted);
    }

    public static String getInspect(Object on) throws ControlFlow {
        return ((Range)IokeObject.data(on)).inspect(on);
    }

    public static String getNotice(Object on) throws ControlFlow {
        return ((Range)IokeObject.data(on)).notice(on);
    }

    public String inspect(Object obj) throws ControlFlow {
        StringBuilder sb = new StringBuilder();
        sb.append(IokeObject.inspect(this.from));
        if (this.inclusive) {
            sb.append("..");
        } else {
            sb.append("...");
        }
        sb.append(IokeObject.inspect(this.to));
        return sb.toString();
    }

    public String notice(Object obj) throws ControlFlow {
        StringBuilder sb = new StringBuilder();
        sb.append(IokeObject.notice(this.from));
        if (this.inclusive) {
            sb.append("..");
        } else {
            sb.append("...");
        }
        sb.append(IokeObject.notice(this.to));
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RangeIterator
    implements Iterator<Object> {
        private IokeObject start;
        private IokeObject end;
        private final boolean inclusive;
        private IokeObject context;
        private IokeObject messageToSend;
        private final Runtime runtime;
        private boolean oneIteration = false;
        private boolean doLast = true;

        public RangeIterator(IokeObject start, IokeObject end, boolean inclusive, boolean inverted, IokeObject context, IokeObject message) {
            this.runtime = context.runtime;
            this.start = start;
            this.end = end;
            this.inclusive = inclusive;
            this.context = context;
            this.messageToSend = this.runtime.succ;
            if (inverted) {
                this.messageToSend = this.runtime.pred;
            }
        }

        @Override
        public boolean hasNext() {
            try {
                boolean sameEndpoints = IokeObject.isTrue(((Message)IokeObject.data(this.runtime.eqMessage)).sendTo(this.runtime.eqMessage, this.context, (Object)this.start, this.end));
                boolean shouldGoOver = this.doLast && this.inclusive;
                boolean sameStartPoint = sameEndpoints && this.inclusive && !this.oneIteration;
                return !sameEndpoints || shouldGoOver || sameStartPoint;
            }
            catch (ControlFlow controlFlow) {
                throw new RuntimeException("(TODO: fix) - got an error. =(");
            }
        }

        @Override
        public Object next() {
            IokeObject obj = this.start;
            try {
                if (!IokeObject.isTrue(((Message)IokeObject.data(this.runtime.eqMessage)).sendTo(this.runtime.eqMessage, this.context, (Object)this.start, this.end))) {
                    this.oneIteration = true;
                    this.start = (IokeObject)((Message)IokeObject.data(this.messageToSend)).sendTo(this.messageToSend, this.context, this.start);
                    this.doLast = true;
                    return obj;
                }
                if (this.inclusive && this.doLast) {
                    this.doLast = false;
                    return obj;
                }
            }
            catch (ControlFlow controlFlow) {
                // empty catch block
            }
            throw new RuntimeException("(TODO: fix) - iterating over end");
        }

        @Override
        public void remove() {
        }
    }
}

