/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import gnu.math.IntFraction;
import gnu.math.IntNum;
import gnu.math.RatNum;
import ioke.lang.Arity;
import ioke.lang.Base;
import ioke.lang.Builtin;
import ioke.lang.Call;
import ioke.lang.Condition;
import ioke.lang.DateTime;
import ioke.lang.Decimal;
import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.DefaultBehavior;
import ioke.lang.DefaultMacro;
import ioke.lang.DefaultMethod;
import ioke.lang.DefaultSyntax;
import ioke.lang.Dict;
import ioke.lang.FileSystem;
import ioke.lang.Ground;
import ioke.lang.Handler;
import ioke.lang.Hook;
import ioke.lang.IokeData;
import ioke.lang.IokeIO;
import ioke.lang.IokeList;
import ioke.lang.IokeObject;
import ioke.lang.IokeRegistry;
import ioke.lang.IokeSet;
import ioke.lang.IokeSystem;
import ioke.lang.JavaArray;
import ioke.lang.JavaConstructorNativeMethod;
import ioke.lang.JavaFieldGetterNativeMethod;
import ioke.lang.JavaFieldSetterNativeMethod;
import ioke.lang.JavaGround;
import ioke.lang.JavaIntegrationWrapper;
import ioke.lang.JavaMethodNativeMethod;
import ioke.lang.JavaWrapper;
import ioke.lang.LexicalBlock;
import ioke.lang.LexicalContext;
import ioke.lang.LexicalMacro;
import ioke.lang.Locals;
import ioke.lang.Main;
import ioke.lang.Message;
import ioke.lang.Method;
import ioke.lang.Mixins;
import ioke.lang.NativeMethod;
import ioke.lang.NullObject;
import ioke.lang.Number;
import ioke.lang.Origin;
import ioke.lang.Pair;
import ioke.lang.Range;
import ioke.lang.Reflector;
import ioke.lang.Regexp;
import ioke.lang.Rescue;
import ioke.lang.Restart;
import ioke.lang.RunnableWithControlFlow;
import ioke.lang.RunnableWithReturnAndControlFlow;
import ioke.lang.Sequence;
import ioke.lang.Symbol;
import ioke.lang.Text;
import ioke.lang.Tuple;
import ioke.lang.TypeCheckingNativeMethod;
import ioke.lang.exceptions.ControlFlow;
import ioke.lang.extensions.benchmark.Benchmark;
import ioke.lang.extensions.readline.Readline;
import ioke.lang.java.ClassRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Runtime
extends IokeData {
    private static int nextId = 1;
    public boolean debug = false;
    private final int id = Runtime.getNextId();
    public final NullObject nul = new NullObject(this);
    PrintWriter out;
    PrintWriter err;
    Reader in;
    public IokeRegistry registry = new IokeRegistry(this);
    public ClassRegistry classRegistry = new ClassRegistry(this);
    public IokeObject base = new IokeObject(this, "Base is the top of the inheritance structure. Most of the objects in the system are derived from this instance. Base should keep its cells to the bare minimum needed for the system.");
    public IokeObject iokeGround = new IokeObject(this, "IokeGround is the place that mimics default behavior, and where most global objects are defined..");
    public IokeObject ground = new IokeObject(this, "Ground is the default place code is evaluated in.");
    public IokeObject system = new IokeObject(this, "System defines things that represents the currently running system, such as the load path.", new IokeSystem());
    public IokeObject runtime = new IokeObject(this, "Runtime gives meta-circular access to the currently executing Ioke runtime.", this);
    public IokeObject defaultBehavior = new IokeObject(this, "DefaultBehavior is a mixin that provides most of the methods shared by most instances in the system.");
    public IokeObject origin = new IokeObject(this, "Any object created from scratch should usually be derived from Origin.");
    public IokeObject nil = new IokeObject(this, "nil is an oddball object that always represents itself. It can not be mimicked and (alongside false) is one of the two false values.", IokeData.Nil);
    public IokeObject _true = new IokeObject(this, "true is an oddball object that always represents itself. It can not be mimicked and represents the a true value.", IokeData.True);
    public IokeObject _false = new IokeObject(this, "false is an oddball object that always represents itself. It can not be mimicked and (alongside nil) is one of the two false values.", IokeData.False);
    public IokeObject text = new IokeObject(this, "Contains an immutable piece of text.", new Text(""));
    public IokeObject symbol = new IokeObject(this, "Represents a symbol - an object that always represents itself.", new Symbol(""));
    public IokeObject number = new IokeObject(this, "Represents an exact number", new Number(Number.getFrom("0")));
    public IokeObject method = new IokeObject(this, "Method is the origin of all methods in the system, both default and Java..", new Method((String)null));
    public IokeObject defaultMethod = new IokeObject(this, "DefaultMethod is the instance all methods in the system are derived from.", new DefaultMethod((String)null));
    public IokeObject nativeMethod = new IokeObject(this, "NativeMethod is a derivation of Method that represents a primitive implemented in Java.", new NativeMethod.WithNoArguments((String)null));
    public IokeObject lexicalBlock = new IokeObject(this, "A lexical block allows you to delay a computation in a specific lexical context. See DefaultMethod#fn for detailed documentation.", new LexicalBlock(this.ground));
    public IokeObject defaultMacro = new IokeObject(this, "DefaultMacro is the instance all non-lexical macros in the system are derived from.", new DefaultMacro(null));
    public IokeObject lexicalMacro = new IokeObject(this, "LexicalMacro is the instance all lexical macros in the system are derived from.", new LexicalMacro(null));
    public IokeObject defaultSyntax = new IokeObject(this, "DefaultSyntax is the instance all syntactical macros in the system are derived from.", new DefaultSyntax(null));
    public IokeObject arity = new IokeObject(this, "Arity provides information about the arguments needed to activate a value.", new Arity((DefaultArgumentsDefinition)null));
    public IokeObject mixins = new IokeObject(this, "Mixins is the name space for most mixins in the system. DefaultBehavior is the notable exception.");
    public IokeObject message = new IokeObject(this, "A Message is the basic code unit in Ioke.", new Message(this, ""));
    public IokeObject restart = new IokeObject(this, "A Restart is the actual object that contains restart information.");
    public IokeObject list = new IokeObject(this, "A list is a collection of objects that can change size", new IokeList());
    public IokeObject dict = new IokeObject(this, "A dictionary is a collection of mappings from one object to another object. The default Dict implementation will use hashing for this.", new Dict());
    public IokeObject set = new IokeObject(this, "A set is an unordered collection of objects that contains no duplicates.", new IokeSet());
    public IokeObject range = new IokeObject(this, "A range is a collection of two objects of the same kind. This Range can be either inclusive or exclusive.", new Range(this.nil, this.nil, false, false));
    public IokeObject pair = new IokeObject(this, "A pair is a collection of two objects of any kind. They are used among other things to represent Dict entries.", new Pair(this.nil, this.nil));
    public IokeObject tuple = new IokeObject(this, "A tuple is a collection of objects of any kind. It is immutable and supports destructuring.", new Tuple(new Object[0]));
    public IokeObject call = new IokeObject(this, "A call is the runtime structure that includes the specific information for a call, that is available inside a DefaultMacro.", new Call());
    public LexicalContext lexicalContext = new LexicalContext(this, this.ground, "A lexical activation context.", null, this.ground);
    public IokeObject dateTime = new IokeObject(this, "A DateTime represents the current date and time in a particular time zone.", new DateTime(0L));
    public IokeObject locals = new IokeObject(this, "Contains all the locals for a specific invocation.");
    public IokeObject javaWrapper = new IokeObject(this, "Wraps a java object.", new JavaWrapper());
    public IokeObject condition = new IokeObject(this, "The root mimic of all the conditions in the system.");
    public IokeObject rescue = new IokeObject(this, "A Rescue contains handling information from rescuing a Condition.");
    public IokeObject handler = new IokeObject(this, "A Handler contains handling information for handling a condition without unwinding the stack.");
    public IokeObject io = new IokeObject(this, "IO is the base for all input/output in Ioke.", new IokeIO());
    public IokeObject fileSystem = new IokeObject(this, "Gives access to things related to the file system.");
    public IokeObject regexp = new IokeObject(this, "A regular expression allows you to matching text against a pattern.", Regexp.create("", ""));
    public IokeObject javaGround = new IokeObject(this, "JavaGround is the place that defines the connections to the Java integration subsystem");
    public IokeObject javaArray = new IokeObject(this, "JavaArray is the common mimic that defines all the magic methods on native java arrays");
    public IokeObject sequence = new IokeObject(this, "The root mimic of all the sequences in the system.");
    public IokeObject iteratorSequence = new IokeObject(this, "The root mimic of all the iterator sequences in the system.", new Sequence.IteratorSequence(Arrays.asList(new Object[0]).iterator()));
    public IokeObject keyValueIteratorSequence = new IokeObject(this, "The root mimic of all the key-value-iterator sequences in the system.", new Sequence.KeyValueIteratorSequence(new HashMap().entrySet().iterator()));
    public IokeObject integer = null;
    public IokeObject decimal = null;
    public IokeObject ratio = null;
    public IokeObject infinity = null;
    public IokeObject asText = this.newMessage("asText");
    public IokeObject asRational = this.newMessage("asRational");
    public IokeObject asDecimal = this.newMessage("asDecimal");
    public IokeObject asSymbol = this.newMessage("asSymbol");
    public IokeObject asTuple = this.newMessage("asTuple");
    public IokeObject mimic = this.newMessage("mimic");
    public IokeObject spaceShip = this.newMessage("<=>");
    public IokeObject succ = this.newMessage("succ");
    public IokeObject pred = this.newMessage("pred");
    public IokeObject setValue = this.newMessage("=");
    public IokeObject nilMessage = this.newMessage("nil");
    public IokeObject name = this.newMessage("name");
    public IokeObject callMessage = this.newMessage("call");
    public IokeObject closeMessage = this.newMessage("close");
    public IokeObject code = this.newMessage("code");
    public IokeObject each = this.newMessage("each");
    public IokeObject textMessage = this.newMessage("text");
    public IokeObject conditionsMessage = this.newMessage("conditions");
    public IokeObject handlerMessage = this.newMessage("handler");
    public IokeObject reportMessage = this.newMessage("report");
    public IokeObject printMessage = this.newMessage("print");
    public IokeObject printlnMessage = this.newMessage("println");
    public IokeObject outMessage = this.newMessage("out");
    public IokeObject currentDebuggerMessage = this.newMessage("currentDebugger");
    public IokeObject invokeMessage = this.newMessage("invoke");
    public IokeObject errorMessage = this.newMessage("error!");
    public IokeObject ErrorMessage = this.newMessage("Error");
    public IokeObject FileMessage = this.newMessage("File");
    public IokeObject inspectMessage = this.newMessage("inspect");
    public IokeObject noticeMessage = this.newMessage("notice");
    public IokeObject removeCellMessage = this.newMessage("removeCell!");
    public IokeObject plusMessage = this.newMessage("+");
    public IokeObject minusMessage = this.newMessage("-");
    public IokeObject multMessage = this.newMessage("*");
    public IokeObject divMessage = this.newMessage("/");
    public IokeObject modMessage = this.newMessage("%");
    public IokeObject expMessage = this.newMessage("**");
    public IokeObject binAndMessage = this.newMessage("&");
    public IokeObject binOrMessage = this.newMessage("|");
    public IokeObject binXorMessage = this.newMessage("^");
    public IokeObject lshMessage = this.newMessage("<<");
    public IokeObject rshMessage = this.newMessage(">>");
    public IokeObject ltMessage = this.newMessage("<");
    public IokeObject lteMessage = this.newMessage("<=");
    public IokeObject gtMessage = this.newMessage(">");
    public IokeObject gteMessage = this.newMessage(">=");
    public IokeObject eqMessage = this.newMessage("==");
    public IokeObject eqqMessage = this.newMessage("===");
    public IokeObject testMessage = this.newMessage("test");
    public IokeObject isApplicableMessage = this.newMessage("applicable?");
    public IokeObject coerceIntoJavaCodeMessage = this.newMessage("java:coerceCode");
    public IokeObject useWhatMessage = this.newMessage("UseWhat");
    public IokeObject cellAddedMessage = this.newMessage("cellAdded");
    public IokeObject cellChangedMessage = this.newMessage("cellChanged");
    public IokeObject cellRemovedMessage = this.newMessage("cellRemoved");
    public IokeObject cellUndefinedMessage = this.newMessage("cellUndefined");
    public IokeObject mimicAddedMessage = this.newMessage("mimicAdded");
    public IokeObject mimicRemovedMessage = this.newMessage("mimicRemoved");
    public IokeObject mimicsChangedMessage = this.newMessage("mimicsChanged");
    public IokeObject mimickedMessage = this.newMessage("mimicked");
    public IokeObject seqMessage = this.newMessage("seq");
    public IokeObject hashMessage = this.newMessage("hash");
    private Map<String, Builtin> builtins = new HashMap<String, Builtin>();
    private Map<IntNum, IokeObject> numCache = new HashMap<IntNum, IokeObject>();
    private Map<String, IokeObject> symbolTable = new HashMap<String, IokeObject>();
    private ThreadLocal<List<List<RestartInfo>>> restarts = new ThreadLocal<List<List<RestartInfo>>>(){

        @Override
        protected List<List<RestartInfo>> initialValue() {
            return new ArrayList<List<RestartInfo>>();
        }
    };
    private ThreadLocal<List<List<RescueInfo>>> rescues = new ThreadLocal<List<List<RescueInfo>>>(){

        @Override
        protected List<List<RescueInfo>> initialValue() {
            return new ArrayList<List<RescueInfo>>();
        }
    };
    private ThreadLocal<List<List<HandlerInfo>>> handlers = new ThreadLocal<List<List<HandlerInfo>>>(){

        @Override
        protected List<List<HandlerInfo>> initialValue() {
            return new ArrayList<List<HandlerInfo>>();
        }
    };

    private static synchronized int getNextId() {
        int ret = nextId++;
        return ret;
    }

    public Runtime() throws Exception {
        this(new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8")), new InputStreamReader(System.in, "UTF-8"), new PrintWriter(new OutputStreamWriter((OutputStream)System.err, "UTF-8")));
    }

    public Runtime(PrintWriter out, Reader in, PrintWriter err) {
        this.out = out;
        this.in = in;
        this.err = err;
    }

    public static Runtime getRuntime() throws ControlFlow, Exception {
        return Runtime.getRuntime(new PrintWriter(System.out), new InputStreamReader(System.in, "UTF-8"), new PrintWriter(System.err));
    }

    public static Runtime getRuntime(PrintWriter out, Reader in, PrintWriter err) throws ControlFlow {
        Runtime r = new Runtime(out, in, err);
        r.init();
        return r;
    }

    public void setCurrentWorkingDirectory(String cwd) {
        ((IokeSystem)IokeObject.data(this.system)).setCurrentWorkingDirectory(cwd);
    }

    public String getCurrentWorkingDirectory() {
        return ((IokeSystem)IokeObject.data(this.system)).getCurrentWorkingDirectory();
    }

    public PrintWriter getOut() {
        return this.out;
    }

    public void addArgument(String arg) {
        ((IokeSystem)IokeObject.data(this.system)).addArgument(arg);
    }

    public void init() throws ControlFlow {
        Base.init(this.base);
        DefaultBehavior.init(this.defaultBehavior);
        Mixins.init(this.mixins);
        this.system.init();
        Runtime.initRuntime(this.runtime);
        this.message.init();
        Ground.init(this.iokeGround, this.ground);
        Origin.init(this.origin);
        this.nil.init();
        this._true.init();
        this._false.init();
        this.text.init();
        this.symbol.init();
        this.number.init();
        this.range.init();
        this.pair.init();
        this.tuple.init();
        this.dateTime.init();
        this.lexicalContext.init();
        this.list.init();
        this.dict.init();
        this.set.init();
        this.call.init();
        Locals.init(this.locals);
        Condition.init(this.condition);
        Rescue.init(this.rescue);
        Handler.init(this.handler);
        this.io.init();
        FileSystem.init(this.fileSystem);
        this.regexp.init();
        JavaGround.init(this.javaGround);
        JavaArray.init(this.javaArray);
        this.javaWrapper.init();
        this.iokeGround.mimicsWithoutCheck(this.defaultBehavior);
        this.iokeGround.mimicsWithoutCheck(this.base);
        this.ground.mimicsWithoutCheck(this.iokeGround);
        this.ground.mimicsWithoutCheck(this.javaGround);
        this.origin.mimicsWithoutCheck(this.ground);
        this.mixins.mimicsWithoutCheck(this.defaultBehavior);
        this.system.mimicsWithoutCheck(this.ground);
        this.system.mimicsWithoutCheck(this.defaultBehavior);
        this.runtime.mimicsWithoutCheck(this.ground);
        this.runtime.mimicsWithoutCheck(this.defaultBehavior);
        this.nil.mimicsWithoutCheck(this.origin);
        this._true.mimicsWithoutCheck(this.origin);
        this._false.mimicsWithoutCheck(this.origin);
        this.text.mimicsWithoutCheck(this.origin);
        this.symbol.mimicsWithoutCheck(this.origin);
        this.number.mimicsWithoutCheck(this.origin);
        this.range.mimicsWithoutCheck(this.origin);
        this.pair.mimicsWithoutCheck(this.origin);
        this.dateTime.mimicsWithoutCheck(this.origin);
        this.message.mimicsWithoutCheck(this.origin);
        this.method.mimicsWithoutCheck(this.origin);
        this.list.mimicsWithoutCheck(this.origin);
        this.dict.mimicsWithoutCheck(this.origin);
        this.set.mimicsWithoutCheck(this.origin);
        this.condition.mimicsWithoutCheck(this.origin);
        this.rescue.mimicsWithoutCheck(this.origin);
        this.handler.mimicsWithoutCheck(this.origin);
        this.io.mimicsWithoutCheck(this.origin);
        this.fileSystem.mimicsWithoutCheck(this.origin);
        this.regexp.mimicsWithoutCheck(this.origin);
        this.method.init();
        this.defaultMethod.init();
        this.nativeMethod.init();
        this.lexicalBlock.init();
        this.defaultMacro.init();
        this.lexicalMacro.init();
        this.defaultSyntax.init();
        this.arity.init();
        this.call.mimicsWithoutCheck(this.origin);
        this.method.mimicsWithoutCheck(this.origin);
        this.defaultMethod.mimicsWithoutCheck(this.method);
        this.nativeMethod.mimicsWithoutCheck(this.method);
        this.defaultMacro.mimicsWithoutCheck(this.origin);
        this.lexicalMacro.mimicsWithoutCheck(this.origin);
        this.defaultSyntax.mimicsWithoutCheck(this.origin);
        this.arity.mimicsWithoutCheck(this.origin);
        this.lexicalBlock.mimicsWithoutCheck(this.origin);
        Restart.init(this.restart);
        this.restart.mimicsWithoutCheck(this.origin);
        this.javaWrapper.mimicsWithoutCheck(this.origin);
        Reflector.init(this);
        Hook.init(this);
        Sequence.init(this.sequence);
        this.iteratorSequence.init();
        this.keyValueIteratorSequence.init();
        this.afterInitRuntime(this.runtime);
        this.addBuiltinScript("benchmark", new Builtin(){

            public IokeObject load(Runtime runtime, IokeObject context, IokeObject message) throws ControlFlow {
                return Benchmark.create(runtime);
            }
        });
        this.addBuiltinScript("readline", new Builtin(){

            public IokeObject load(Runtime runtime, IokeObject context, IokeObject message) throws ControlFlow {
                return Readline.create(runtime);
            }
        });
        try {
            this.evaluateString("System lowLevelLoad!(\"builtin/A01_use\", false)", this.message, this.ground);
            this.evaluateString("use(\"builtin/A05_conditions\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/A10_defaultBehavior\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/A15_dmacro\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/A20_comparing\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/A25_defaultBehavior_inspection\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/A30_system\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/D05_number\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/D10_call\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/D15_range\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/D20_booleans\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/D25_list\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/D30_dict\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/D35_pair\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/D37_tuple\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/D40_text\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/D43_regexp\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/D45_fileSystem\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/F05_case\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/F10_comprehensions\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/F15_message\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/F20_set\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/F25_cond\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/F30_enumerable\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/F32_sequence\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/G05_aspects\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/G10_origin\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/G10_arity\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/G50_hook\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/H10_lexicalBlock\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/H50_struct\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/M05_ignoreErrors\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/O05_misc\")", this.message, this.ground);
            this.evaluateString("use(\"builtin/J05_javaGround\")", this.message, this.ground);
        }
        catch (ControlFlow controlFlow) {
            // empty catch block
        }
    }

    public NullObject getNul() {
        return this.nul;
    }

    public IokeObject getGround() {
        return this.ground;
    }

    public IokeObject getOrigin() {
        return this.origin;
    }

    public IokeObject getSystem() {
        return this.system;
    }

    public IokeObject getIokeRuntime() {
        return this.runtime;
    }

    public IokeObject getMixins() {
        return this.mixins;
    }

    public IokeObject getText() {
        return this.text;
    }

    public IokeObject getSymbol() {
        return this.symbol;
    }

    public IokeObject getNumber() {
        return this.number;
    }

    public IokeObject getBase() {
        return this.base;
    }

    public IokeObject getTrue() {
        return this._true;
    }

    public IokeObject getSet() {
        return this.set;
    }

    public IokeObject getFalse() {
        return this._false;
    }

    public IokeObject getMethod() {
        return this.method;
    }

    public IokeObject getNativeMethod() {
        return this.nativeMethod;
    }

    public IokeObject getDefaultMethod() {
        return this.defaultMethod;
    }

    public IokeObject getDefaultMacro() {
        return this.defaultMacro;
    }

    public IokeObject getLexicalBlock() {
        return this.lexicalBlock;
    }

    public IokeObject getDefaultBehavior() {
        return this.defaultBehavior;
    }

    public IokeObject getRestart() {
        return this.restart;
    }

    public IokeObject getCondition() {
        return this.condition;
    }

    public IokeObject getRescue() {
        return this.rescue;
    }

    public IokeObject getHandler() {
        return this.handler;
    }

    public IokeObject getFileSystem() {
        return this.fileSystem;
    }

    public IokeObject getPair() {
        return this.pair;
    }

    public IokeObject getDateTime() {
        return this.dateTime;
    }

    public IokeObject getNil() {
        return this.nil;
    }

    public IokeObject getCall() {
        return this.call;
    }

    public IokeObject getIO() {
        return this.io;
    }

    public void addBuiltinScript(String name, Builtin builtin) {
        this.builtins.put(name, builtin);
    }

    public Builtin getBuiltin(String name) {
        return this.builtins.get(name);
    }

    public IokeObject parseStream(Reader reader, IokeObject message, IokeObject context) throws ControlFlow {
        return Message.newFromStream(this, reader, message, context);
    }

    public Object evaluateStream(Reader reader, IokeObject message, IokeObject context) throws ControlFlow {
        IokeObject msg = this.parseStream(reader, message, context);
        if (msg != null) {
            return ((Message)IokeObject.data(msg)).evaluateComplete(msg);
        }
        return this.nil;
    }

    public Object evaluateString(String str, IokeObject message, IokeObject context) throws ControlFlow {
        IokeObject msg = this.parseStream(new StringReader(str), message, context);
        if (msg != null) {
            return ((Message)IokeObject.data(msg)).evaluateComplete(msg);
        }
        return this.nil;
    }

    public Object evaluateStream(Reader reader) throws ControlFlow {
        return this.evaluateStream(reader, this.message, this.ground);
    }

    public Object evaluateString(String str) throws ControlFlow {
        return this.evaluateString(str, this.message, this.ground);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluateStream(String name, Reader reader, IokeObject message, IokeObject context) throws ControlFlow {
        try {
            ((IokeSystem)IokeObject.data(this.system)).pushCurrentFile(name);
            Object object = this.evaluateStream(reader, message, context);
            return object;
        }
        catch (Exception e) {
            this.reportNativeException(e, message, context);
            Object var6_7 = null;
            return var6_7;
        }
        finally {
            ((IokeSystem)IokeObject.data(this.system)).popCurrentFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluateFile(File f, IokeObject message, IokeObject context) throws ControlFlow {
        try {
            ((IokeSystem)IokeObject.data(this.system)).pushCurrentFile(f.getCanonicalPath());
            Object object = this.evaluateStream(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"), message, context);
            return object;
        }
        catch (Exception e) {
            this.reportNativeException(e, message, context);
            Object var5_6 = null;
            return var5_6;
        }
        finally {
            ((IokeSystem)IokeObject.data(this.system)).popCurrentFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluateFile(String filename, IokeObject message, IokeObject context) throws ControlFlow {
        try {
            ((IokeSystem)IokeObject.data(this.system)).pushCurrentFile(filename);
            if (IokeSystem.isAbsoluteFileName(filename)) {
                Object object = this.evaluateStream(new InputStreamReader((InputStream)new FileInputStream(new File(filename)), "UTF-8"), message, context);
                return object;
            }
            Object object = this.evaluateStream(new InputStreamReader((InputStream)new FileInputStream(new File(((IokeSystem)IokeObject.data(this.system)).getCurrentWorkingDirectory(), filename)), "UTF-8"), message, context);
            return object;
        }
        catch (Exception e) {
            this.reportNativeException(e, message, context);
            Object var5_7 = null;
            return var5_7;
        }
        finally {
            ((IokeSystem)IokeObject.data(this.system)).popCurrentFile();
        }
    }

    public void reportNativeException(Exception e, IokeObject message, IokeObject context) throws ControlFlow {
        IokeObject condition = IokeObject.as(IokeObject.getCellChain(this.condition, message, context, "Error", "NativeException"), context).mimic(message, context);
        condition.setCell("message", message);
        condition.setCell("context", context);
        condition.setCell("receiver", context);
        condition.setCell("rootException", e);
        condition.setCell("exceptionType", this.newText(e.getClass().getName()));
        if (e.getMessage() != null) {
            condition.setCell("exceptionMessage", this.newText(e.getMessage()));
        } else {
            condition.setCell("exceptionMessage", this.nil);
        }
        ArrayList<Object> ob = new ArrayList<Object>();
        for (StackTraceElement ste : e.getStackTrace()) {
            ob.add(this.newText(ste.toString()));
        }
        condition.setCell("exceptionStackTrace", this.newList(ob));
        this.errorCondition(condition);
    }

    public IokeObject newFromOrigin() throws ControlFlow {
        return this.origin.mimic(null, null);
    }

    public IokeObject newText(String text) {
        IokeObject obj = this.text.allocateCopy(null, null);
        obj.mimicsWithoutCheck(this.text);
        obj.setData(new Text(text));
        return obj;
    }

    public IokeObject newRegexp(String pattern, String flags, IokeObject context, IokeObject message) throws ControlFlow {
        IokeObject obj = this.regexp.allocateCopy(null, null);
        obj.mimicsWithoutCheck(this.regexp);
        obj.setData(Regexp.create(pattern, flags, context, message));
        return obj;
    }

    public IokeObject newDecimal(String number) throws ControlFlow {
        IokeObject obj = this.decimal.allocateCopy(null, null);
        obj.mimicsWithoutCheck(this.decimal);
        obj.setData(Decimal.decimal(number));
        return obj;
    }

    public IokeObject newDecimal(Number number) throws ControlFlow {
        IokeObject obj = this.decimal.allocateCopy(null, null);
        obj.mimicsWithoutCheck(this.decimal);
        obj.setData(Decimal.decimal(number.getValue()));
        return obj;
    }

    public IokeObject newDecimal(BigDecimal number) throws ControlFlow {
        IokeObject obj = this.decimal.allocateCopy(null, null);
        obj.mimicsWithoutCheck(this.decimal);
        obj.setData(Decimal.decimal(number));
        return obj;
    }

    public IokeObject createJavaWrapper(Object object) {
        if (object instanceof Class) {
            if (object == Object.class) {
                IokeObject obj = this.javaWrapper.allocateCopy(null, null);
                obj.mimicsWithoutCheck(this.javaWrapper);
                obj.setData(JavaWrapper.wrapWithMethods((Class)object, obj, this));
                return obj;
            }
            if (object == Class.class) {
                IokeObject obj = this.javaWrapper.allocateCopy(null, null);
                Class clz = (Class)object;
                IokeObject objWrap = this.registry.wrap(clz.getSuperclass());
                obj.mimicsWithoutCheck(objWrap);
                obj.setData(JavaWrapper.wrapWithMethods(clz, obj, this));
                objWrap.mimicsWithoutCheck(0, obj);
                return obj;
            }
            IokeObject obj = this.javaWrapper.allocateCopy(null, null);
            Class clz = (Class)object;
            if (((Class)object).isArray()) {
                obj.mimicsWithoutCheck(this.javaArray);
            }
            obj.mimicsWithoutCheck(this.registry.wrap(Class.class));
            obj.mimicsWithoutCheck(this.registry.wrap(clz.getSuperclass()));
            for (Class<?> i : clz.getInterfaces()) {
                obj.mimicsWithoutCheck(this.registry.wrap(i));
            }
            obj.setData(JavaWrapper.wrapWithMethods(clz, obj, this));
            return obj;
        }
        IokeObject obj = this.javaWrapper.allocateCopy(null, null);
        obj.mimicsWithoutCheck(this.registry.wrap(object.getClass()));
        obj.setData(new JavaWrapper(object));
        return obj;
    }

    public IokeObject createIntegratedJavaWrapper(Class clz) {
        IokeObject obj = this.javaWrapper.allocateCopy(null, null);
        obj.mimicsWithoutCheck(this.registry.wrap(Class.class));
        obj.mimicsWithoutCheck(this.registry.wrap(clz.getSuperclass()));
        for (Class<?> i : clz.getInterfaces()) {
            obj.mimicsWithoutCheck(this.registry.wrap(i));
        }
        obj.setData(JavaIntegrationWrapper.wrapWithMethods(clz, obj, this));
        return obj;
    }

    public IokeObject createJavaMethod(java.lang.reflect.Method[] methods) throws ControlFlow {
        return this.newMethod(null, this.nativeMethod, new JavaMethodNativeMethod(methods));
    }

    public IokeObject createJavaMethod(Constructor[] ctors, boolean special) throws ControlFlow {
        return this.newMethod(null, this.nativeMethod, new JavaConstructorNativeMethod(ctors, special));
    }

    public IokeObject createJavaFieldGetter(Field field) throws ControlFlow {
        return this.newMethod(null, this.nativeMethod, new JavaFieldGetterNativeMethod(field));
    }

    public IokeObject createJavaFieldSetter(Field field) throws ControlFlow {
        return this.newMethod(null, this.nativeMethod, new JavaFieldSetterNativeMethod(field));
    }

    public IokeObject newNumber(String number) {
        return this.newNumber(Number.getFrom(number));
    }

    public IokeObject newNumber(long number) {
        return this.newNumber(Number.getFrom(number));
    }

    public IokeObject newNumber(IntNum number) {
        IokeObject obj = null;
        obj = this.numCache.get(number);
        if (obj == null) {
            obj = this.integer.allocateCopy(null, null);
            obj.mimicsWithoutCheck(this.integer);
            obj.setData(Number.integer(number));
            this.numCache.put(number, obj);
        }
        return obj;
    }

    public IokeObject newNumber(RatNum number) {
        if (number instanceof IntNum) {
            return this.newNumber((IntNum)number);
        }
        IokeObject obj = this.ratio.allocateCopy(null, null);
        obj.mimicsWithoutCheck(this.ratio);
        obj.setData(Number.ratio((IntFraction)number));
        return obj;
    }

    public IokeObject newMethod(String doc, IokeObject tp, Method impl) throws ControlFlow {
        IokeObject obj = tp.allocateCopy(null, null);
        obj.setDocumentation(doc, null, null);
        obj.mimicsWithoutCheck(tp);
        obj.setData(impl);
        return obj;
    }

    public IokeObject newMacro(String doc, IokeObject tp, IokeData impl) throws ControlFlow {
        IokeObject obj = tp.allocateCopy(null, null);
        obj.setDocumentation(doc, null, null);
        obj.mimicsWithoutCheck(tp);
        obj.setData(impl);
        return obj;
    }

    public IokeObject newNativeMethod(String doc, NativeMethod impl) throws ControlFlow {
        return this.newMethod(doc, this.nativeMethod, impl);
    }

    public IokeObject newMessage(String name) {
        return this.createMessage(new Message(this, name));
    }

    public IokeObject createMessage(Message m) {
        IokeObject obj = this.message.allocateCopy(null, null);
        obj.mimicsWithoutCheck(this.message);
        obj.setData(m);
        return obj;
    }

    public IokeObject newMessageFrom(IokeObject m, String name, List<Object> args) throws ControlFlow {
        Message mess = new Message(this, name);
        mess.setFile(m.getFile());
        mess.setLine(m.getLine());
        mess.setPosition(m.getPosition());
        mess.setArguments(args);
        return this.createMessage(mess);
    }

    public IokeObject newLexicalBlock(String doc, IokeObject tp, LexicalBlock impl) throws ControlFlow {
        IokeObject obj = tp.allocateCopy(null, null);
        obj.setDocumentation(doc, null, null);
        obj.mimicsWithoutCheck(tp);
        obj.setData(impl);
        return obj;
    }

    public IokeObject newDict(Map<Object, Object> map) {
        IokeObject obj = this.dict.allocateCopy(null, null);
        obj.mimicsWithoutCheck(this.dict);
        obj.setData(new Dict(map));
        return obj;
    }

    public IokeObject newSet(Collection<Object> objs) {
        IokeObject obj = this.set.allocateCopy(null, null);
        obj.mimicsWithoutCheck(this.set);
        obj.setData(new IokeSet(new HashSet<Object>(objs)));
        return obj;
    }

    public void errorCondition(IokeObject cond) throws ControlFlow {
        ((Message)IokeObject.data(this.errorMessage)).sendTo(this.errorMessage, this.ground, (Object)this.ground, this.createMessage(Message.wrap(cond)));
    }

    public IokeObject newList(List<Object> list) {
        IokeObject obj = this.list.allocateCopy(null, null);
        obj.mimicsWithoutCheck(this.list);
        obj.setData(new IokeList(list));
        return obj;
    }

    public IokeObject newList(List<Object> list, IokeObject orig) {
        IokeObject obj = orig.allocateCopy(null, null);
        obj.mimicsWithoutCheck(orig);
        obj.setData(new IokeList(list));
        return obj;
    }

    public IokeObject newCallFrom(IokeObject ctx, IokeObject message, IokeObject surroundingContext, IokeObject on) {
        IokeObject obj = this.call.allocateCopy(null, null);
        obj.mimicsWithoutCheck(this.call);
        obj.setData(new Call(ctx, message, surroundingContext, on));
        return obj;
    }

    public IokeObject newRange(IokeObject from, IokeObject to, boolean inclusive, boolean inverted) {
        IokeObject obj = this.range.allocateCopy(null, null);
        obj.mimicsWithoutCheck(this.range);
        obj.setData(new Range(from, to, inclusive, inverted));
        return obj;
    }

    public IokeObject newTuple(Object one, Object two) {
        IokeObject tp = (IokeObject)this.tuple.getCells().get("Two");
        IokeObject obj = tp.allocateCopy(null, null);
        obj.mimicsWithoutCheck(tp);
        obj.setData(new Tuple(new Object[]{one, two}));
        return obj;
    }

    public IokeObject newFile(IokeObject context, File eff) throws ControlFlow {
        IokeObject fileMimic = IokeObject.as(((Message)IokeObject.data(this.FileMessage)).sendTo(this.FileMessage, context, this.fileSystem), context);
        IokeObject obj = fileMimic.allocateCopy(null, null);
        obj.mimicsWithoutCheck(fileMimic);
        obj.setData(new FileSystem.IokeFile(eff));
        return obj;
    }

    public IokeObject newPair(Object first, Object second) {
        IokeObject obj = this.pair.allocateCopy(null, null);
        obj.mimicsWithoutCheck(this.pair);
        obj.setData(new Pair(first, second));
        return obj;
    }

    public IokeObject newDateTime(org.joda.time.DateTime dt) {
        IokeObject obj = this.dateTime.allocateCopy(null, null);
        obj.mimicsWithoutCheck(this.dateTime);
        obj.setData(new DateTime(dt));
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IokeObject getSymbol(String name) {
        Map<String, IokeObject> map = this.symbolTable;
        synchronized (map) {
            IokeObject obj = this.symbolTable.get(name);
            if (obj == null) {
                obj = new IokeObject(this, null, new Symbol(name));
                obj.mimicsWithoutCheck(this.symbol);
                this.symbolTable.put(name, obj);
            }
            return obj;
        }
    }

    public Object withRestartReturningArguments(RunnableWithControlFlow code, IokeObject context, Restart.JavaRestart ... restarts) throws ControlFlow {
        ArrayList<RestartInfo> rrs = new ArrayList<RestartInfo>();
        BindIndex index = this.getBindIndex();
        for (Restart.JavaRestart rjr : restarts) {
            IokeObject rr = IokeObject.as(((Message)IokeObject.data(this.mimic)).sendTo(this.mimic, context, this.restart), context);
            IokeObject.setCell(rr, "name", this.getSymbol(rjr.getName()), context);
            ArrayList<Object> args = new ArrayList<Object>();
            for (String argName : rjr.getArgumentNames()) {
                args.add(this.getSymbol(argName));
            }
            IokeObject.setCell(rr, "name", this.getSymbol(rjr.getName()), context);
            IokeObject.setCell(rr, "argumentNames", this.newList(args), context);
            String report = rjr.report();
            if (report != null) {
                IokeObject.setCell(rr, "report", this.evaluateString("fn(r, \"" + report + "\")", this.message, this.ground), context);
            }
            rrs.add(0, new RestartInfo(rjr.getName(), rr, rrs, index, rjr));
            index = index.nextCol();
        }
        this.registerRestarts(rrs);
        try {
            code.run();
            ArrayList arrayList = new ArrayList();
            return arrayList;
        }
        catch (ControlFlow.Restart restart) {
            RestartInfo ri = null;
            ri = restart.getRestart();
            if (ri.token == rrs) {
                IokeObject result;
                Restart.JavaRestart currentRjr = (Restart.JavaRestart)ri.data;
                IokeObject iokeObject = result = currentRjr.invoke(context, restart.getArguments());
                return iokeObject;
            }
            throw restart;
        }
        finally {
            this.unregisterRestarts(rrs);
        }
    }

    public void withReturningRestart(String name, IokeObject context, RunnableWithControlFlow code) throws ControlFlow {
        IokeObject rr = IokeObject.as(((Message)IokeObject.data(this.mimic)).sendTo(this.mimic, context, this.restart), context);
        IokeObject.setCell(rr, "name", this.getSymbol(name), context);
        IokeObject.setCell(rr, "argumentNames", this.newList(new ArrayList<Object>()), context);
        ArrayList<RestartInfo> rrs = new ArrayList<RestartInfo>();
        BindIndex index = this.getBindIndex();
        rrs.add(0, new RestartInfo(name, rr, rrs, index, null));
        index = index.nextCol();
        this.registerRestarts(rrs);
        try {
            code.run();
        }
        catch (ControlFlow.Restart e) {
            RestartInfo ri = null;
            ri = e.getRestart();
            if (ri.token == rrs) {
                return;
            }
            throw e;
        }
        finally {
            this.unregisterRestarts(rrs);
        }
    }

    public Object withReturningRescue(IokeObject context, Object toReturn, RunnableWithReturnAndControlFlow javaRescue) throws ControlFlow {
        ArrayList<RescueInfo> rescues = new ArrayList<RescueInfo>();
        IokeObject rr = IokeObject.as(((Message)IokeObject.data(this.mimic)).sendTo(this.mimic, context, this.rescue), context);
        ArrayList<Object> conds = new ArrayList<Object>();
        conds.add(this.condition);
        rescues.add(new RescueInfo(rr, conds, rescues, this.getBindIndex()));
        this.registerRescues(rescues);
        try {
            Object object = javaRescue.run();
            return object;
        }
        catch (ControlFlow.Rescue e) {
            if (e.getRescue().token == rescues) {
                Object object = toReturn;
                return object;
            }
            throw e;
        }
        finally {
            this.unregisterRescues(rescues);
        }
    }

    public void registerRestarts(List<RestartInfo> restarts) {
        this.restarts.get().add(0, restarts);
    }

    public void unregisterRestarts(List<RestartInfo> restarts) {
        this.restarts.get().remove(restarts);
    }

    public void registerRescues(List<RescueInfo> rescues) {
        this.rescues.get().add(0, rescues);
    }

    public void unregisterRescues(List<RescueInfo> rescues) {
        this.rescues.get().remove(rescues);
    }

    public void registerHandlers(List<HandlerInfo> handlers) {
        this.handlers.get().add(0, handlers);
    }

    public void unregisterHandlers(List<HandlerInfo> handlers) {
        this.handlers.get().remove(handlers);
    }

    public BindIndex getBindIndex() {
        return new BindIndex(this.rescues.get().size());
    }

    public List<HandlerInfo> findActiveHandlersFor(IokeObject condition, BindIndex stopIndex) {
        ArrayList<HandlerInfo> result = new ArrayList<HandlerInfo>();
        for (List<HandlerInfo> lrp : this.handlers.get()) {
            for (HandlerInfo rp : lrp) {
                if (rp.index.lessThan(stopIndex)) {
                    return result;
                }
                for (Object possibleKind : rp.applicableConditions) {
                    if (!IokeObject.isMimic(condition, IokeObject.as(possibleKind, condition))) continue;
                    result.add(rp);
                }
            }
        }
        return result;
    }

    public RescueInfo findActiveRescueFor(IokeObject condition) {
        for (List<RescueInfo> lrp : this.rescues.get()) {
            for (RescueInfo rp : lrp) {
                for (Object possibleKind : rp.applicableConditions) {
                    if (!IokeObject.isMimic(condition, IokeObject.as(possibleKind, condition))) continue;
                    return rp;
                }
            }
        }
        return null;
    }

    public List<List<RestartInfo>> getActiveRestarts() {
        return this.restarts.get();
    }

    public RestartInfo findActiveRestart(String name) {
        for (List<RestartInfo> lrp : this.restarts.get()) {
            for (RestartInfo rp : lrp) {
                if (!name.equals(rp.name)) continue;
                return rp;
            }
        }
        return null;
    }

    public RestartInfo findActiveRestart(IokeObject restart) {
        for (List<RestartInfo> lrp : this.restarts.get()) {
            for (RestartInfo rp : lrp) {
                if (rp.restart != restart) continue;
                return rp;
            }
        }
        return null;
    }

    public void tearDown() throws ControlFlow.Exit {
        boolean status = false;
        List<IokeSystem.AtExitInfo> atExits = IokeSystem.getAtExits(this.system);
        while (!atExits.isEmpty()) {
            IokeSystem.AtExitInfo atExit = atExits.remove(0);
            try {
                ((Message)IokeObject.data(atExit.message)).evaluateCompleteWithoutExplicitReceiver(atExit.message, atExit.context, atExit.context.getRealContext());
            }
            catch (ControlFlow.Exit e) {
                status = true;
            }
            catch (ControlFlow e) {
                String name = e.getClass().getName();
                System.err.println("unexpected control flow: " + name.substring(name.indexOf("$") + 1).toLowerCase());
                if (this.debug) {
                    e.printStackTrace(System.err);
                }
                status = true;
            }
        }
        if (status) {
            throw new ControlFlow.Exit();
        }
    }

    public void afterInitRuntime(IokeObject obj) throws ControlFlow {
        try {
            Properties props = new Properties();
            props.load(Main.class.getResourceAsStream("/ioke/lang/version.properties"));
            String version = props.getProperty("ioke.build.version");
            String runtimeVersion = props.getProperty("ioke.build.runtimeVersion");
            String versionString = props.getProperty("ioke.build.versionString");
            String date = props.getProperty("ioke.build.date");
            String commit = props.getProperty("ioke.build.commit");
            IokeObject versionObj = this.newFromOrigin();
            versionObj.setCell("machine", this.newText("ikj"));
            ArrayList<Object> versionParts = new ArrayList<Object>();
            for (String s : runtimeVersion.split("[\\.-]")) {
                try {
                    versionParts.add(this.newNumber(s));
                }
                catch (Exception e) {
                    versionParts.add(this.newText(s));
                }
            }
            versionObj.setCell("versionNumber", this.newList(versionParts));
            versionObj.setCell("release", this.newText(version));
            versionObj.setCell("fullVersion", this.newText(versionString));
            versionObj.setCell("commit", this.newText(commit));
            versionObj.setCell("date", this.newText(date));
            obj.setCell("version", versionObj);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void initRuntime(IokeObject obj) throws ControlFlow {
        obj.setKind("Runtime");
        obj.registerMethod(obj.runtime.newNativeMethod("returns the node id for the runtime it's called on", new TypeCheckingNativeMethod.WithNoArguments("nodeId", obj){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                Runtime r = (Runtime)IokeObject.data(on);
                return method.runtime.newNumber(r.id);
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("creates a new runtime and returns that. be careful using this since it will result in some fairly strange behavior if used incorrectly. it will not copy the state of this runtime, but just create a new one from scratch.", new TypeCheckingNativeMethod.WithNoArguments("create", obj){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                Runtime r = new Runtime(method.runtime.out, method.runtime.in, method.runtime.err);
                r.init();
                IokeObject o = method.runtime.runtime.allocateCopy(null, null);
                o.mimicsWithoutCheck(method.runtime.runtime);
                o.setData(r);
                return o;
            }
        }));
    }

    public static class BindIndex {
        public final int row;
        public final int col;

        public BindIndex(int row) {
            this(row, 0);
        }

        public BindIndex(int row, int col) {
            this.row = row;
            this.col = col;
        }

        public BindIndex nextCol() {
            return new BindIndex(this.row, this.col + 1);
        }

        public boolean lessThan(BindIndex other) {
            return this.row < other.row || this.row == other.row && this.col < other.col;
        }

        public boolean greaterThan(BindIndex other) {
            return this.row > other.row || this.row == other.row && this.col > other.col;
        }

        public String toString() {
            return "ix[" + this.row + "," + this.col + "]";
        }
    }

    public static class RestartInfo {
        public final String name;
        public final IokeObject restart;
        public final Object token;
        public final BindIndex index;
        public final Object data;

        public RestartInfo(String name, IokeObject restart, Object token, BindIndex index, Object data) {
            this.name = name;
            this.restart = restart;
            this.token = token;
            this.index = index;
            this.data = data;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HandlerInfo {
        public final IokeObject handler;
        public final List<Object> applicableConditions;
        public final Object token;
        public final BindIndex index;

        public HandlerInfo(IokeObject handler, List<Object> applicableConditions, Object token, BindIndex index) {
            this.handler = handler;
            this.applicableConditions = applicableConditions;
            this.token = token;
            this.index = index;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RescueInfo {
        public final IokeObject rescue;
        public final List<Object> applicableConditions;
        public final Object token;
        public final BindIndex index;

        public RescueInfo(IokeObject rescue, List<Object> applicableConditions, Object token, BindIndex index) {
            this.rescue = rescue;
            this.applicableConditions = applicableConditions;
            this.token = token;
            this.index = index;
        }

        public String toString() {
            return "rescueInfo(" + this.index + ")";
        }
    }
}

